/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PFont;
import processing.core.PImage;
import processing.core.PMatrix;

public abstract class PGraphics
extends PImage
implements PConstants {
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public static final int R = 3;
    public static final int G = 4;
    public static final int B = 5;
    public static final int A = 6;
    public static final int U = 7;
    public static final int V = 8;
    public static final int MX = 9;
    public static final int MY = 10;
    public static final int MZ = 11;
    public static final int SR = 12;
    public static final int SG = 13;
    public static final int SB = 14;
    public static final int SA = 15;
    public static final int SW = 16;
    public static final int NX = 17;
    public static final int NY = 18;
    public static final int NZ = 19;
    public static final int VX = 20;
    public static final int VY = 21;
    public static final int VZ = 22;
    public static final int VW = 23;
    public static final int AR = 24;
    public static final int AG = 25;
    public static final int AB = 26;
    public static final int DR = 3;
    public static final int DG = 4;
    public static final int DB = 5;
    public static final int DA = 6;
    public static final int SPR = 27;
    public static final int SPG = 28;
    public static final int SPB = 29;
    public static final int SPA = 30;
    public static final int SHINE = 31;
    public static final int ER = 32;
    public static final int EG = 33;
    public static final int EB = 34;
    public static final int BEEN_LIT = 35;
    static final int VERTEX_FIELD_COUNT = 36;
    public static final int INDEX = 0;
    public static final int VERTEX1 = 1;
    public static final int VERTEX2 = 2;
    public static final int VERTEX3 = 3;
    public static final int TEXTURE_INDEX = 4;
    public static final int STROKE_MODE = 3;
    public static final int STROKE_WEIGHT = 4;
    public static final int LINE_FIELD_COUNT = 5;
    public static final int TRIANGLE_FIELD_COUNT = 5;
    public static final int TRI_DIFFUSE_R = 0;
    public static final int TRI_DIFFUSE_G = 1;
    public static final int TRI_DIFFUSE_B = 2;
    public static final int TRI_DIFFUSE_A = 3;
    public static final int TRI_SPECULAR_R = 4;
    public static final int TRI_SPECULAR_G = 5;
    public static final int TRI_SPECULAR_B = 6;
    public static final int TRI_SPECULAR_A = 7;
    public static final int TRIANGLE_COLOR_COUNT = 8;
    public static final int AUTO_NORMAL = 0;
    public static final int MANUAL_SHAPE_NORMAL = 1;
    public static final int MANUAL_VERTEX_NORMAL = 2;
    public int width1;
    public int height1;
    public int pixelCount;
    public boolean settingsInited;
    protected boolean mainDrawingSurface;
    DirectColorModel cm;
    MemoryImageSource mis;
    public Image image;
    public PGraphics raw;
    protected boolean[] hints = new boolean[10];
    public int colorMode;
    public float colorModeX;
    public float colorModeY;
    public float colorModeZ;
    public float colorModeA;
    boolean colorScale;
    boolean colorRgb255;
    public boolean tint;
    public int tintColor;
    protected boolean tintAlpha;
    protected float tintR;
    protected float tintG;
    protected float tintB;
    protected float tintA;
    protected int tintRi;
    protected int tintGi;
    protected int tintBi;
    protected int tintAi;
    public boolean fill;
    public int fillColor = -1;
    protected boolean fillAlpha;
    protected float fillR;
    protected float fillG;
    protected float fillB;
    protected float fillA;
    protected int fillRi;
    protected int fillGi;
    protected int fillBi;
    protected int fillAi;
    public boolean stroke;
    public int strokeColor = -16777216;
    protected boolean strokeAlpha;
    protected float strokeR;
    protected float strokeG;
    protected float strokeB;
    protected float strokeA;
    protected int strokeRi;
    protected int strokeGi;
    protected int strokeBi;
    protected int strokeAi;
    public int backgroundColor = -3355444;
    protected boolean backgroundAlpha;
    protected float backgroundR;
    protected float backgroundG;
    protected float backgroundB;
    protected float backgroundA;
    protected int backgroundRi;
    protected int backgroundGi;
    protected int backgroundBi;
    protected int backgroundAi;
    protected float calcR;
    protected float calcG;
    protected float calcB;
    protected float calcA;
    int calcRi;
    int calcGi;
    int calcBi;
    int calcAi;
    int calcColor;
    boolean calcAlpha;
    int cacheHsbKey;
    float[] cacheHsbValue = new float[3];
    static final float DEFAULT_STROKE_WEIGHT = 1.0f;
    static final int DEFAULT_STROKE_JOIN = 8;
    static final int DEFAULT_STROKE_CAP = 2;
    public float strokeWeight = 1.0f;
    public int strokeJoin = 8;
    public int strokeCap = 2;
    public float m00;
    public float m01;
    public float m02;
    public float m03;
    public float m10;
    public float m11;
    public float m12;
    public float m13;
    public float m20;
    public float m21;
    public float m22;
    public float m23;
    public float m30;
    public float m31;
    public float m32;
    public float m33;
    static final int MATRIX_STACK_DEPTH = 32;
    float[][] matrixStack = new float[32][16];
    int matrixStackDepth;
    protected int shape;
    static final int DEFAULT_VERTICES = 512;
    protected float[][] vertices = new float[512][36];
    protected int vertexCount;
    protected boolean bezierInited = false;
    public int bezierDetail = 20;
    protected float[][] bezier_basis = new float[][]{{-1.0f, 3.0f, -3.0f, 1.0f}, {3.0f, -6.0f, 3.0f, 0.0f}, {-3.0f, 3.0f, 0.0f, 0.0f}, {1.0f, 0.0f, 0.0f, 0.0f}};
    protected PMatrix bezierBasis = new PMatrix(-1.0f, 3.0f, -3.0f, 1.0f, 3.0f, -6.0f, 3.0f, 0.0f, -3.0f, 3.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f);
    protected float[][] bezierForwardMatrix;
    protected float[][] bezierDrawMatrix;
    protected boolean curve_inited = false;
    protected int curveDetail = 20;
    public float curveTightness = 0.0f;
    protected float[][] curve_basis;
    protected float[][] curve_forward;
    protected float[][] curve_draw;
    protected PMatrix bezierBasisInverse;
    protected PMatrix curveToBezierMatrix;
    static final int DEFAULT_SPLINE_VERTICES = 128;
    protected float[][] splineVertices;
    protected int splineVertexCount;
    protected static final float[] sinLUT = new float[720];
    protected static final float[] cosLUT = new float[720];
    protected static final float SINCOS_PRECISION = 0.5f;
    protected static final int SINCOS_LENGTH = 720;
    public int rectMode;
    public int ellipseMode;
    public PFont textFont;
    public Font textFontNative;
    public FontMetrics textFontNativeMetrics;
    public int textAlign;
    public int textAlignY;
    public int textMode;
    public float textSize;
    public float textLeading;
    public float textX;
    public float textY;
    public float textZ;
    protected char[] textBuffer = new char[8192];
    protected char[] textWidthBuffer = new char[8192];
    protected int textBreakCount;
    protected int[] textBreakStart;
    protected int[] textBreakStop;
    public PMatrix modelview;
    public PMatrix modelviewInv;
    public PMatrix camera;
    public PMatrix cameraInv;
    public float ambientR;
    public float ambientG;
    public float ambientB;
    public float specularR;
    public float specularG;
    public float specularB;
    public float specularA;
    public float emissiveR;
    public float emissiveG;
    public float emissiveB;
    public float shininess;
    public float cameraFOV;
    public float cameraX;
    public float cameraY;
    public float cameraZ;
    public float cameraNear;
    public float cameraFar;
    public float cameraAspect;
    public PMatrix projection;
    public int[] stencil;
    public float[] zbuffer;
    public static final int MAX_LIGHTS = 8;
    public int lightCount = 0;
    public int[] lightType;
    public float[][] lightPosition;
    public float[][] lightNormal;
    public float[] lightFalloffConstant;
    public float[] lightFalloffLinear;
    public float[] lightFalloffQuadratic;
    public float[] lightSpotAngle;
    public float[] lightSpotAngleCos;
    public float[] lightSpotConcentration;
    public float[][] lightDiffuse;
    public float[][] lightSpecular;
    public float[] currentLightSpecular;
    public float currentLightFalloffConstant;
    public float currentLightFalloffLinear;
    public float currentLightFalloffQuadratic;
    public int textureMode;
    public float textureU;
    public float textureV;
    public PImage textureImage;
    public float normalX;
    public float normalY;
    public float normalZ;
    public int normalMode;
    public int normalCount;
    public int sphereDetailU = 0;
    public int sphereDetailV = 0;
    static float[] lerpColorHSB1;
    static float[] lerpColorHSB2;

    public PGraphics(int n, int n2, PApplet pApplet) {
        this.parent = pApplet;
        if (pApplet != null) {
            this.setMainDrawingSurface();
        }
        this.resize(n, n2);
    }

    public void setMainDrawingSurface() {
        this.mainDrawingSurface = true;
        this.format = 1;
    }

    public void resize(int n, int n2) {
        System.out.println("PGraphics.resize() " + n + " " + n2);
        this.width = n;
        this.height = n2;
        this.width1 = this.width - 1;
        this.height1 = this.height - 1;
        this.allocate();
        this.reapplySettings();
    }

    protected abstract void allocate();

    public boolean canDraw() {
        return true;
    }

    public abstract void beginDraw();

    public abstract void endDraw();

    protected void checkSettings() {
        if (!this.settingsInited) {
            this.defaultSettings();
        }
    }

    protected void defaultSettings() {
        this.colorMode(1, 255.0f);
        this.fill(255);
        this.stroke(0);
        this.shape = 0;
        this.matrixStackDepth = 0;
        this.rectMode(0);
        this.ellipseMode(3);
        this.textFont = null;
        this.textSize = 12.0f;
        this.textLeading = 14.0f;
        this.textAlign = 37;
        this.textMode = 4;
        if (this.mainDrawingSurface) {
            this.background(this.backgroundColor);
        }
        this.settingsInited = true;
    }

    protected void reapplySettings() {
        if (!this.settingsInited) {
            return;
        }
        this.colorMode(this.colorMode, this.colorModeX, this.colorModeY, this.colorModeZ);
        if (this.fill) {
            this.fill(this.fillColor);
        } else {
            this.noFill();
        }
        if (this.stroke) {
            this.stroke(this.strokeColor);
            if (this.strokeWeight != 1.0f) {
                this.strokeWeight(this.strokeWeight);
            }
            if (this.strokeCap != 2) {
                this.strokeCap(this.strokeCap);
            }
            if (this.strokeJoin != 8) {
                this.strokeJoin(this.strokeJoin);
            }
        } else {
            this.noStroke();
        }
        if (this.tint) {
            this.tint(this.tintColor);
        } else {
            this.noTint();
        }
        if (this.smooth) {
            this.smooth();
        }
        if (this.textFont != null) {
            float f = this.textLeading;
            this.textFont(this.textFont, this.textSize);
            this.textLeading(f);
        }
        this.background(this.backgroundColor);
    }

    protected void flush() {
    }

    public void hint(int n) {
        this.hints[n] = true;
    }

    public void unhint(int n) {
        this.hints[n] = false;
    }

    public void beginShape() {
        this.beginShape(256);
    }

    public abstract void beginShape(int var1);

    public void normal(float f, float f2, float f3) {
    }

    public void textureMode(int n) {
        this.textureMode = n;
    }

    public void texture(PImage pImage) {
        this.textureImage = pImage;
    }

    protected void textureVertex(float f, float f2) {
        if (this.textureImage == null) {
            throw new RuntimeException("need to set an image with texture() before using u and v coordinates");
        }
        if (this.textureMode == 2) {
            f /= (float)this.textureImage.width;
            f2 /= (float)this.textureImage.height;
        }
        this.textureU = f;
        this.textureV = f2;
        if (this.textureU < 0.0f) {
            this.textureU = 0.0f;
        } else if (this.textureU > 1.0f) {
            this.textureU = 1.0f;
        }
        if (this.textureV < 0.0f) {
            this.textureV = 0.0f;
        } else if (this.textureV > 1.0f) {
            this.textureV = 1.0f;
        }
    }

    public abstract void vertex(float var1, float var2);

    public abstract void vertex(float var1, float var2, float var3);

    public abstract void vertex(float var1, float var2, float var3, float var4);

    public abstract void vertex(float var1, float var2, float var3, float var4, float var5);

    public void bezierVertex(float f, float f2, float f3, float f4, float f5, float f6) {
        this.bezierVertex(f, f2, Float.MAX_VALUE, f3, f4, Float.MAX_VALUE, f5, f6, Float.MAX_VALUE);
    }

    public void bezierVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        if (this.shape != 256) {
            throw new RuntimeException("beginShape() and vertex() must be used before bezierVertex()");
        }
        if (this.splineVertexCount > 0) {
            float[] fArray = this.splineVertices[this.splineVertexCount - 1];
            this.splineVertex(fArray[9], fArray[10], fArray[11], true);
        } else if (this.vertexCount > 0) {
            float[] fArray = this.vertices[this.vertexCount - 1];
            this.splineVertex(fArray[9], fArray[10], fArray[11], true);
        } else {
            throw new RuntimeException("A call to vertex() must be used before bezierVertex()");
        }
        this.splineVertex(f, f2, f3, true);
        this.splineVertex(f4, f5, f6, true);
        this.splineVertex(f7, f8, f9, true);
    }

    public void curveVertex(float f, float f2) {
        this.splineVertex(f, f2, Float.MAX_VALUE, false);
    }

    public void curveVertex(float f, float f2, float f3) {
        this.splineVertex(f, f2, f3, false);
    }

    protected void splineVertex(float f, float f2, float f3, boolean bl) {
        int n;
        if (this.splineVertices == null) {
            this.splineVertices = new float[128][36];
        }
        if (this.splineVertexCount == 128) {
            System.arraycopy(this.splineVertices[125], 0, this.splineVertices[0], 0, 36);
            System.arraycopy(this.splineVertices[126], 0, this.splineVertices[1], 0, 36);
            System.arraycopy(this.splineVertices[127], 0, this.splineVertices[2], 0, 36);
            this.splineVertexCount = 3;
        }
        float[] fArray = this.splineVertices[this.splineVertexCount];
        fArray[9] = f;
        fArray[10] = f2;
        if (this.fill) {
            fArray[3] = this.fillR;
            fArray[4] = this.fillG;
            fArray[5] = this.fillB;
            fArray[6] = this.fillA;
        }
        if (this.stroke) {
            fArray[12] = this.strokeR;
            fArray[13] = this.strokeG;
            fArray[14] = this.strokeB;
            fArray[15] = this.strokeA;
            fArray[16] = this.strokeWeight;
        }
        if (this.textureImage != null) {
            fArray[7] = this.textureU;
            fArray[8] = this.textureV;
        }
        int n2 = n = f3 == Float.MAX_VALUE ? 2 : 3;
        if (n == 3) {
            fArray[11] = f3;
            fArray[17] = this.normalX;
            fArray[18] = this.normalY;
            fArray[19] = this.normalZ;
        }
        ++this.splineVertexCount;
        if (this.splineVertexCount > 3) {
            if (bl) {
                if (this.splineVertexCount % 4 == 0) {
                    if (!this.bezierInited) {
                        this.bezierInit();
                    }
                    this.splineSegment(this.splineVertexCount - 4, this.splineVertexCount - 4, this.bezierDrawMatrix, n, this.bezierDetail);
                }
            } else {
                if (!this.curve_inited) {
                    this.curve_init();
                }
                this.splineSegment(this.splineVertexCount - 4, this.splineVertexCount - 3, this.curve_draw, n, this.curveDetail);
            }
        }
    }

    public void breakShape() {
    }

    public final void endShape() {
        this.endShape(1);
    }

    public abstract void endShape(int var1);

    public void point(float f, float f2) {
        this.beginShape(16);
        this.vertex(f, f2);
        this.endShape();
    }

    public void point(float f, float f2, float f3) {
        this.beginShape(16);
        this.vertex(f, f2, f3);
        this.endShape();
    }

    public void line(float f, float f2, float f3, float f4) {
        this.beginShape(32);
        this.vertex(f, f2);
        this.vertex(f3, f4);
        this.endShape();
    }

    public void line(float f, float f2, float f3, float f4, float f5, float f6) {
        this.beginShape(32);
        this.vertex(f, f2, f3);
        this.vertex(f4, f5, f6);
        this.endShape();
    }

    public void triangle(float f, float f2, float f3, float f4, float f5, float f6) {
        this.beginShape(64);
        this.vertex(f, f2);
        this.vertex(f3, f4);
        this.vertex(f5, f6);
        this.endShape();
    }

    public void quad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.beginShape(128);
        this.vertex(f, f2);
        this.vertex(f3, f4);
        this.vertex(f5, f6);
        this.vertex(f7, f8);
        this.endShape();
    }

    public void rectMode(int n) {
        this.rectMode = n;
    }

    public void rect(float f, float f2, float f3, float f4) {
        float f5;
        switch (this.rectMode) {
            case 1: {
                break;
            }
            case 0: {
                f3 += f;
                f4 += f2;
                break;
            }
            case 2: {
                float f6 = f3;
                float f7 = f4;
                f3 = f + f6;
                f4 = f2 + f7;
                f -= f6;
                f2 -= f7;
                break;
            }
            case 3: {
                float f8 = f3 / 2.0f;
                float f9 = f4 / 2.0f;
                f3 = f + f8;
                f4 = f2 + f9;
                f -= f8;
                f2 -= f9;
            }
        }
        if (f > f3) {
            f5 = f;
            f = f3;
            f3 = f5;
        }
        if (f2 > f4) {
            f5 = f2;
            f2 = f4;
            f4 = f5;
        }
        this.rectImpl(f, f2, f3, f4);
    }

    protected void rectImpl(float f, float f2, float f3, float f4) {
        this.quad(f, f2, f3, f2, f3, f4, f, f4);
    }

    public void ellipseMode(int n) {
        this.ellipseMode = n;
    }

    public void ellipse(float f, float f2, float f3, float f4) {
        float f5 = f;
        float f6 = f2;
        float f7 = f3;
        float f8 = f4;
        if (this.ellipseMode == 1) {
            f7 = f3 - f;
            f8 = f4 - f2;
        } else if (this.ellipseMode == 2) {
            f5 = f - f3;
            f6 = f2 - f4;
            f7 = f3 * 2.0f;
            f8 = f4 * 2.0f;
        } else if (this.ellipseMode == 3) {
            f5 = f - f3 / 2.0f;
            f6 = f2 - f4 / 2.0f;
        }
        if (f7 < 0.0f) {
            f5 += f7;
            f7 = -f7;
        }
        if (f8 < 0.0f) {
            f6 += f8;
            f8 = -f8;
        }
        this.ellipseImpl(f5, f6, f7, f8);
    }

    protected void ellipseImpl(float f, float f2, float f3, float f4) {
        int n;
        boolean bl;
        float f5 = f3 / 2.0f;
        float f6 = f4 / 2.0f;
        float f7 = f + f5;
        float f8 = f2 + f6;
        int n2 = (int)(4.0 + Math.sqrt(f5 + f6) * 3.0);
        float f9 = 720.0f / (float)n2;
        float f10 = 0.0f;
        if (this.fill) {
            bl = this.stroke;
            this.stroke = false;
            this.beginShape(66);
            this.normal(0.0f, 0.0f, 1.0f);
            this.vertex(f7, f8);
            for (n = 0; n < n2; ++n) {
                this.vertex(f7 + cosLUT[(int)f10] * f5, f8 + sinLUT[(int)f10] * f6);
                f10 += f9;
            }
            this.vertex(f7 + cosLUT[0] * f5, f8 + sinLUT[0] * f6);
            this.endShape();
            this.stroke = bl;
        }
        if (this.stroke) {
            bl = this.fill;
            this.fill = false;
            f10 = 0.0f;
            this.beginShape();
            for (n = 0; n < n2; ++n) {
                this.vertex(f7 + cosLUT[(int)f10] * f5, f8 + sinLUT[(int)f10] * f6);
                f10 += f9;
            }
            this.endShape(2);
            this.fill = bl;
        }
    }

    public void arc(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = f;
        float f8 = f2;
        float f9 = f3;
        float f10 = f4;
        if (this.ellipseMode == 1) {
            f9 = f3 - f;
            f10 = f4 - f2;
        } else if (this.ellipseMode == 2) {
            f7 = f - f3;
            f8 = f2 - f4;
            f9 = f3 * 2.0f;
            f10 = f4 * 2.0f;
        } else if (this.ellipseMode == 3) {
            f7 = f - f3 / 2.0f;
            f8 = f2 - f4 / 2.0f;
        }
        if (Float.isInfinite(f5) || Float.isInfinite(f6)) {
            return;
        }
        while (f6 < f5) {
            f6 += (float)Math.PI * 2;
        }
        this.arcImpl(f7, f8, f9, f10, f5, f6);
    }

    protected void arcImpl(float f, float f2, float f3, float f4, float f5, float f6) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl;
        float f7 = f3 / 2.0f;
        float f8 = f4 / 2.0f;
        float f9 = f + f7;
        float f10 = f2 + f8;
        if (this.fill) {
            bl = this.stroke;
            this.stroke = false;
            n5 = (int)(0.5f + f5 / ((float)Math.PI * 2) * 720.0f);
            n4 = (int)(0.5f + f6 / ((float)Math.PI * 2) * 720.0f);
            this.beginShape(66);
            this.vertex(f9, f10);
            n3 = 1;
            for (n2 = n5; n2 < n4; n2 += n3) {
                n = n2 % 720;
                if (n < 0) {
                    n += 720;
                }
                this.vertex(f9 + cosLUT[n] * f7, f10 + sinLUT[n] * f8);
            }
            this.vertex(f9 + cosLUT[n4 % 720] * f7, f10 + sinLUT[n4 % 720] * f8);
            this.endShape();
            this.stroke = bl;
        }
        if (this.stroke) {
            bl = this.fill;
            this.fill = false;
            n5 = (int)(0.5f + f5 / ((float)Math.PI * 2) * 720.0f);
            n4 = (int)(0.5f + f6 / ((float)Math.PI * 2) * 720.0f);
            this.beginShape();
            n3 = 1;
            for (n2 = n5; n2 < n4; n2 += n3) {
                n = n2 % 720;
                if (n < 0) {
                    n += 720;
                }
                this.vertex(f9 + cosLUT[n] * f7, f10 + sinLUT[n] * f8);
            }
            this.vertex(f9 + cosLUT[n4 % 720] * f7, f10 + sinLUT[n4 % 720] * f8);
            this.endShape();
            this.fill = bl;
        }
    }

    public void box(float f) {
        this.depthError("box");
    }

    public void box(float f, float f2, float f3) {
        this.depthError("box");
    }

    public void sphereDetail(int n) {
        this.depthError("sphereDetail");
    }

    public void sphereDetail(int n, int n2) {
        this.depthError("sphereDetail");
    }

    public void sphere(float f) {
        this.depthError("sphere");
    }

    public float bezierPoint(float f, float f2, float f3, float f4, float f5) {
        float f6 = 1.0f - f5;
        return f * f6 * f6 * f6 + 3.0f * f2 * f5 * f6 * f6 + 3.0f * f3 * f5 * f5 * f6 + f4 * f5 * f5 * f5;
    }

    public float bezierTangent(float f, float f2, float f3, float f4, float f5) {
        return 3.0f * f5 * f5 * (-f + 3.0f * f2 - 3.0f * f3 + f4) + 6.0f * f5 * (f - 2.0f * f2 + f3) + 3.0f * (-f + f2);
    }

    protected void bezierInit() {
        this.bezierDetail(this.bezierDetail);
    }

    public void bezierDetail(int n) {
        if (this.bezierForwardMatrix == null) {
            this.bezierForwardMatrix = new float[4][4];
            this.bezierDrawMatrix = new float[4][4];
        }
        this.bezierDetail = n;
        this.bezierInited = true;
        this.setup_spline_forward(n, this.bezierForwardMatrix);
        this.mult_spline_matrix(this.bezierForwardMatrix, this.bezier_basis, this.bezierDrawMatrix, 4);
    }

    public void bezier(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.beginShape();
        this.vertex(f, f2);
        this.bezierVertex(f3, f4, f5, f6, f7, f8);
        this.endShape();
    }

    public void bezier(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.beginShape();
        this.vertex(f, f2, f3);
        this.bezierVertex(f4, f5, f6, f7, f8, f9, f10, f11, f12);
        this.endShape();
    }

    public float curvePoint(float f, float f2, float f3, float f4, float f5) {
        if (!this.curve_inited) {
            this.curve_init();
        }
        float f6 = f5 * f5;
        float f7 = f5 * f6;
        float[][] fArray = this.curve_basis;
        return f * (f7 * fArray[0][0] + f6 * fArray[1][0] + f5 * fArray[2][0] + fArray[3][0]) + f2 * (f7 * fArray[0][1] + f6 * fArray[1][1] + f5 * fArray[2][1] + fArray[3][1]) + f3 * (f7 * fArray[0][2] + f6 * fArray[1][2] + f5 * fArray[2][2] + fArray[3][2]) + f4 * (f7 * fArray[0][3] + f6 * fArray[1][3] + f5 * fArray[2][3] + fArray[3][3]);
    }

    public float curveTangent(float f, float f2, float f3, float f4, float f5) {
        if (!this.curve_inited) {
            this.curve_init();
        }
        float f6 = f5 * f5 * 3.0f;
        float f7 = f5 * 2.0f;
        float[][] fArray = this.curve_basis;
        return f * (f6 * fArray[0][0] + f7 * fArray[1][0] + fArray[2][0]) + f2 * (f6 * fArray[0][1] + f7 * fArray[1][1] + fArray[2][1]) + f3 * (f6 * fArray[0][2] + f7 * fArray[1][2] + fArray[2][2]) + f4 * (f6 * fArray[0][3] + f7 * fArray[1][3] + fArray[2][3]);
    }

    public void curveDetail(int n) {
        this.curve_mode(n, this.curveTightness);
    }

    public void curveTightness(float f) {
        this.curve_mode(this.curveDetail, f);
    }

    protected void curve_init() {
        this.curve_mode(this.curveDetail, this.curveTightness);
    }

    protected void curve_mode(int n, float f) {
        this.curveDetail = n;
        if (this.curve_basis == null) {
            this.curve_basis = new float[4][4];
            this.curve_forward = new float[4][4];
            this.curve_draw = new float[4][4];
            this.curve_inited = true;
        }
        float[][] fArray = this.curve_basis;
        fArray[0][0] = f - 1.0f;
        fArray[0][1] = f + 3.0f;
        fArray[0][2] = -3.0f - f;
        fArray[0][3] = 1.0f - f;
        fArray[1][0] = 2.0f * (1.0f - f);
        fArray[1][1] = -5.0f - f;
        fArray[1][2] = 2.0f * (f + 2.0f);
        fArray[1][3] = f - 1.0f;
        fArray[2][0] = f - 1.0f;
        fArray[2][1] = 0.0f;
        fArray[2][2] = 1.0f - f;
        fArray[2][3] = 0.0f;
        fArray[3][0] = 0.0f;
        fArray[3][1] = 2.0f;
        fArray[3][2] = 0.0f;
        fArray[3][3] = 0.0f;
        for (int i = 0; i < 4; ++i) {
            int n2 = 0;
            while (n2 < 4) {
                float[] fArray2 = fArray[i];
                int n3 = n2++;
                fArray2[n3] = fArray2[n3] / 2.0f;
            }
        }
        this.setup_spline_forward(n, this.curve_forward);
        if (this.bezierBasisInverse == null) {
            this.bezierBasisInverse = new PMatrix(this.bezierBasis).invert();
        }
        this.curveToBezierMatrix = new PMatrix(fArray[0][0], fArray[0][1], fArray[0][2], fArray[0][3], fArray[1][0], fArray[1][1], fArray[1][2], fArray[1][3], fArray[2][0], fArray[2][1], fArray[2][2], fArray[2][3], fArray[3][0], fArray[3][1], fArray[3][2], fArray[3][3]);
        this.curveToBezierMatrix.preApply(this.bezierBasisInverse);
        this.mult_spline_matrix(this.curve_forward, this.curve_basis, this.curve_draw, 4);
    }

    public void curve(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.beginShape();
        this.curveVertex(f, f2);
        this.curveVertex(f3, f4);
        this.curveVertex(f5, f6);
        this.curveVertex(f7, f8);
        this.endShape();
    }

    public void curve(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.beginShape();
        this.curveVertex(f, f2, f3);
        this.curveVertex(f4, f5, f6);
        this.curveVertex(f7, f8, f9);
        this.curveVertex(f10, f11, f12);
        this.endShape();
    }

    protected void setup_spline_forward(int n, float[][] fArray) {
        float f = 1.0f / (float)n;
        float f2 = f * f;
        float f3 = f2 * f;
        fArray[0][0] = 0.0f;
        fArray[0][1] = 0.0f;
        fArray[0][2] = 0.0f;
        fArray[0][3] = 1.0f;
        fArray[1][0] = f3;
        fArray[1][1] = f2;
        fArray[1][2] = f;
        fArray[1][3] = 0.0f;
        fArray[2][0] = 6.0f * f3;
        fArray[2][1] = 2.0f * f2;
        fArray[2][2] = 0.0f;
        fArray[2][3] = 0.0f;
        fArray[3][0] = 6.0f * f3;
        fArray[3][1] = 0.0f;
        fArray[3][2] = 0.0f;
        fArray[3][3] = 0.0f;
    }

    protected void mult_spline_matrix(float[][] fArray, float[][] fArray2, float[][] fArray3, int n) {
        int n2;
        int n3;
        for (n3 = 0; n3 < 4; ++n3) {
            for (n2 = 0; n2 < n; ++n2) {
                fArray3[n3][n2] = 0.0f;
            }
        }
        for (n3 = 0; n3 < 4; ++n3) {
            for (n2 = 0; n2 < n; ++n2) {
                for (int i = 0; i < 4; ++i) {
                    fArray3[n3][n2] = fArray3[n3][n2] + fArray[n3][i] * fArray2[i][n2];
                }
            }
        }
    }

    protected void splineSegment(int n, int n2, float[][] fArray, int n3, int n4) {
        float f = this.splineVertices[n + 0][9];
        float f2 = this.splineVertices[n + 1][9];
        float f3 = this.splineVertices[n + 2][9];
        float f4 = this.splineVertices[n + 3][9];
        float f5 = this.splineVertices[n2][9];
        float f6 = this.splineVertices[n + 0][10];
        float f7 = this.splineVertices[n + 1][10];
        float f8 = this.splineVertices[n + 2][10];
        float f9 = this.splineVertices[n + 3][10];
        float f10 = this.splineVertices[n2][10];
        float f11 = fArray[1][0] * f + fArray[1][1] * f2 + fArray[1][2] * f3 + fArray[1][3] * f4;
        float f12 = fArray[2][0] * f + fArray[2][1] * f2 + fArray[2][2] * f3 + fArray[2][3] * f4;
        float f13 = fArray[3][0] * f + fArray[3][1] * f2 + fArray[3][2] * f3 + fArray[3][3] * f4;
        float f14 = fArray[1][0] * f6 + fArray[1][1] * f7 + fArray[1][2] * f8 + fArray[1][3] * f9;
        float f15 = fArray[2][0] * f6 + fArray[2][1] * f7 + fArray[2][2] * f8 + fArray[2][3] * f9;
        float f16 = fArray[3][0] * f6 + fArray[3][1] * f7 + fArray[3][2] * f8 + fArray[3][3] * f9;
        int n5 = this.splineVertexCount;
        if (n3 == 3) {
            float f17 = this.splineVertices[n + 0][11];
            float f18 = this.splineVertices[n + 1][11];
            float f19 = this.splineVertices[n + 2][11];
            float f20 = this.splineVertices[n + 3][11];
            float f21 = this.splineVertices[n2][11];
            float f22 = fArray[1][0] * f17 + fArray[1][1] * f18 + fArray[1][2] * f19 + fArray[1][3] * f20;
            float f23 = fArray[2][0] * f17 + fArray[2][1] * f18 + fArray[2][2] * f19 + fArray[2][3] * f20;
            float f24 = fArray[3][0] * f17 + fArray[3][1] * f18 + fArray[3][2] * f19 + fArray[3][3] * f20;
            this.vertex(f5, f10, f21);
            for (int i = 0; i < n4; ++i) {
                f5 += f11;
                f11 += f12;
                f12 += f13;
                f14 += f15;
                f15 += f16;
                f23 += f24;
                this.vertex(f5, f10 += f14, f21 += (f22 += f23));
            }
        } else {
            this.vertex(f5, f10);
            for (int i = 0; i < n4; ++i) {
                f11 += f12;
                f12 += f13;
                f15 += f16;
                this.vertex(f5 += f11, f10 += (f14 += f15));
            }
        }
        this.splineVertexCount = n5;
    }

    public void image(PImage pImage, float f, float f2) {
        if (pImage.width == -1 || pImage.height == -1) {
            return;
        }
        this.imageImpl(pImage, f, f2, f + (float)pImage.width, f2 + (float)pImage.height, 0, 0, pImage.width, pImage.height);
    }

    public void image(PImage pImage, float f, float f2, float f3, float f4) {
        this.image(pImage, f, f2, f3, f4, 0, 0, pImage.width, pImage.height);
    }

    public void image(PImage pImage, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4) {
        if (pImage.width == -1 || pImage.height == -1) {
            return;
        }
        if (this.imageMode == 0) {
            if (f3 < 0.0f) {
                f += f3;
                f3 = -f3;
            }
            if (f4 < 0.0f) {
                f2 += f4;
                f4 = -f4;
            }
            this.imageImpl(pImage, f, f2, f + f3, f2 + f4, n, n2, n3, n4);
        } else if (this.imageMode == 1) {
            float f5;
            if (f3 < f) {
                f5 = f;
                f = f3;
                f3 = f5;
            }
            if (f4 < f2) {
                f5 = f2;
                f2 = f4;
                f4 = f5;
            }
            this.imageImpl(pImage, f, f2, f3, f4, n, n2, n3, n4);
        } else if (this.imageMode == 3) {
            if (f3 < 0.0f) {
                f3 = -f3;
            }
            if (f4 < 0.0f) {
                f4 = -f4;
            }
            float f6 = f - f3 / 2.0f;
            float f7 = f2 - f4 / 2.0f;
            this.imageImpl(pImage, f6, f7, f6 + f3, f7 + f4, n, n2, n3, n4);
        }
    }

    protected void imageImpl(PImage pImage, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4) {
        boolean bl = this.stroke;
        boolean bl2 = this.fill;
        int n5 = this.textureMode;
        this.stroke = false;
        this.fill = true;
        this.textureMode = 2;
        float f5 = this.fillR;
        float f6 = this.fillG;
        float f7 = this.fillB;
        float f8 = this.fillA;
        if (this.tint) {
            this.fillR = this.tintR;
            this.fillG = this.tintG;
            this.fillB = this.tintB;
            this.fillA = this.tintA;
        } else {
            this.fillR = 1.0f;
            this.fillG = 1.0f;
            this.fillB = 1.0f;
            this.fillA = 1.0f;
        }
        this.beginShape(128);
        this.texture(pImage);
        this.vertex(f, f2, n, n2);
        this.vertex(f, f4, n, n4);
        this.vertex(f3, f4, n3, n4);
        this.vertex(f3, f2, n3, n2);
        this.endShape();
        this.stroke = bl;
        this.fill = bl2;
        this.textureMode = n5;
        this.fillR = f5;
        this.fillG = f6;
        this.fillB = f7;
        this.fillA = f8;
    }

    public void textAlign(int n) {
        this.textAlign(n, 0);
    }

    public void textAlign(int n, int n2) {
        this.textAlign = n;
        this.textAlignY = n2;
    }

    public float textAscent() {
        if (this.textFont == null) {
            throw new RuntimeException("use textFont() before textAscent()");
        }
        return this.textFont.ascent() * (this.textMode == 256 ? (float)this.textFont.size : this.textSize);
    }

    public float textDescent() {
        if (this.textFont != null) {
            return this.textFont.descent() * (this.textMode == 256 ? (float)this.textFont.size : this.textSize);
        }
        throw new RuntimeException("use textFont() before textDescent()");
    }

    public void textFont(PFont pFont) {
        if (pFont != null) {
            this.textFont = pFont;
            if (this.hints[2] && pFont.font == null) {
                pFont.findFont();
            }
            this.textFontNative = pFont.font;
            if (this.textFontNative != null) {
                this.textFontNativeMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.textFontNative);
            }
        } else {
            throw new RuntimeException("a null PFont was passed to textFont()");
        }
        this.textSize(pFont.size);
    }

    public void textFont(PFont pFont, float f) {
        this.textFont(pFont);
        this.textSize(f);
    }

    public void textLeading(float f) {
        this.textLeading = f;
    }

    public void textMode(int n) {
        if (n == 37 || n == 39) {
            throw new RuntimeException("textMode() is now textAlign() in Processing beta");
        }
        if (n != 256 && n != 4) {
            throw new RuntimeException("Only textMode(SCREEN) and textMode(MODEL) are available with this renderer.");
        }
        this.textMode = n;
    }

    public void textSize(float f) {
        if (this.textFont != null) {
            if (this.textMode == 256 && f != (float)this.textFont.size) {
                throw new RuntimeException("textSize() cannot be used with textMode(SCREEN)");
            }
        } else {
            throw new RuntimeException("Use textFont() before textSize()");
        }
        this.textSize = f;
        this.textLeading = (this.textAscent() + this.textDescent()) * 1.275f;
    }

    public float textWidth(char c) {
        this.textWidthBuffer[0] = c;
        return this.textWidthImpl(this.textWidthBuffer, 0, 1);
    }

    public float textWidth(String string) {
        int n;
        if (this.textFont == null) {
            throw new RuntimeException("use textFont() before textWidth()");
        }
        int n2 = string.length();
        if (n2 > this.textWidthBuffer.length) {
            this.textWidthBuffer = new char[n2 + 10];
        }
        string.getChars(0, n2, this.textWidthBuffer, 0);
        float f = 0.0f;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (this.textWidthBuffer[n] != '\n') continue;
            f = Math.max(f, this.textWidthImpl(this.textWidthBuffer, n3, n));
            n3 = n + 1;
        }
        if (n3 < n2) {
            f = Math.max(f, this.textWidthImpl(this.textWidthBuffer, n3, n));
        }
        return f;
    }

    protected float textWidthImpl(char[] cArray, int n, int n2) {
        float f = 0.0f;
        for (int i = n; i < n2; ++i) {
            f += this.textFont.width(cArray[i]) * this.textSize;
        }
        return f;
    }

    public void text(char c) {
        this.text(c, this.textX, this.textY, this.textZ);
    }

    public void text(char c, float f, float f2) {
        if (this.textFont == null) {
            throw new RuntimeException("use textFont() before text()");
        }
        if (this.textMode == 256) {
            this.loadPixels();
        }
        this.textBuffer[0] = c;
        this.textLineImpl(this.textBuffer, 0, 1, f, f2);
        if (this.textMode == 256) {
            this.updatePixels();
        }
    }

    public void text(char c, float f, float f2, float f3) {
        if (f3 != 0.0f && this.textMode == 256) {
            String string = "textMode(SCREEN) cannot have a z coordinate";
            throw new RuntimeException(string);
        }
        if (f3 != 0.0f) {
            this.translate(0.0f, 0.0f, f3);
        }
        this.text(c, f, f2);
        this.textZ = f3;
        if (f3 != 0.0f) {
            this.translate(0.0f, 0.0f, -f3);
        }
    }

    public void text(String string) {
        this.text(string, this.textX, this.textY, this.textZ);
    }

    public void text(String string, float f, float f2) {
        int n;
        int n2;
        int n3;
        if (this.textFont == null) {
            throw new RuntimeException("use textFont() before text()");
        }
        if (this.textMode == 256) {
            this.loadPixels();
        }
        if ((n3 = string.length()) > this.textBuffer.length) {
            this.textBuffer = new char[n3 + 10];
        }
        string.getChars(0, n3, this.textBuffer, 0);
        float f3 = 0.0f;
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.textBuffer[n2] != '\n') continue;
            f3 += this.textLeading;
        }
        if (this.textAlignY == 3) {
            f2 += (this.textAscent() - f3) / 2.0f;
        } else if (this.textAlignY == 101) {
            f2 += this.textAscent();
        } else if (this.textAlignY == 102) {
            f2 -= this.textDescent() + f3;
        }
        n2 = 0;
        for (n = 0; n < n3; ++n) {
            if (this.textBuffer[n] != '\n') continue;
            this.textLineImpl(this.textBuffer, n2, n, f, f2);
            n2 = n + 1;
            f2 += this.textLeading;
        }
        if (n2 < n3) {
            this.textLineImpl(this.textBuffer, n2, n, f, f2);
        }
        if (this.textMode == 256) {
            this.updatePixels();
        }
    }

    public void text(String string, float f, float f2, float f3) {
        if (f3 != 0.0f && this.textMode == 256) {
            String string2 = "textMode(SCREEN) cannot have a z coordinate";
            throw new RuntimeException(string2);
        }
        if (f3 != 0.0f) {
            this.translate(0.0f, 0.0f, f3);
        }
        this.text(string, f, f2);
        this.textZ = f3;
        if (f3 != 0.0f) {
            this.translate(0.0f, 0.0f, -f3);
        }
    }

    protected void textLineImpl(char[] cArray, int n, int n2, float f, float f2) {
        if (this.textAlign == 3) {
            f -= this.textWidthImpl(cArray, n, n2) / 2.0f;
        } else if (this.textAlign == 39) {
            f -= this.textWidthImpl(cArray, n, n2);
        }
        this.textLinePlacedImpl(cArray, n, n2, f, f2);
    }

    protected void textLinePlacedImpl(char[] cArray, int n, int n2, float f, float f2) {
        for (int i = n; i < n2; ++i) {
            this.textCharImpl(cArray[i], f, f2);
            f += this.textWidth(cArray[i]);
        }
        this.textX = f;
        this.textY = f2;
        this.textZ = 0.0f;
    }

    public void text(String string, float f, float f2, float f3, float f4) {
        float f5;
        if (this.textFont == null) {
            throw new RuntimeException("use textFont() before text()");
        }
        if (this.textMode == 256) {
            this.loadPixels();
        }
        switch (this.rectMode) {
            case 0: {
                f3 += f;
                f4 += f2;
                break;
            }
            case 2: {
                float f6 = f3;
                float f7 = f4;
                f3 = f + f6;
                f4 = f2 + f7;
                f -= f6;
                f2 -= f7;
                break;
            }
            case 3: {
                float f6 = f3 / 2.0f;
                float f7 = f4 / 2.0f;
                f3 = f + f6;
                f4 = f2 + f7;
                f -= f6;
                f2 -= f7;
            }
        }
        if (f3 < f) {
            f5 = f;
            f = f3;
            f3 = f5;
        }
        if (f4 < f2) {
            f5 = f2;
            f2 = f4;
            f4 = f5;
        }
        f5 = f3 - f;
        float f8 = this.textWidth(' ');
        if (this.textBreakStart == null) {
            this.textBreakStart = new int[20];
            this.textBreakStop = new int[20];
        }
        this.textBreakCount = 0;
        int n = string.length();
        if (n + 1 > this.textBuffer.length) {
            this.textBuffer = new char[n + 1];
        }
        string.getChars(0, n, this.textBuffer, 0);
        this.textBuffer[n++] = 10;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (this.textBuffer[i] != '\n') continue;
            boolean bl = this.textSentence(this.textBuffer, n2, i, f5, f8);
            if (!bl) break;
            n2 = i + 1;
        }
        float f9 = f;
        if (this.textAlign == 3) {
            f9 += f5 / 2.0f;
        } else if (this.textAlign == 39) {
            f9 = f3;
        }
        float f10 = f4 - f2;
        int n3 = 1 + PApplet.floor((f10 - this.textAscent()) / this.textLeading);
        if (this.textAlignY == 3) {
            int n4 = Math.min(this.textBreakCount, n3);
            float f11 = this.textAscent() + this.textLeading * (float)(n4 - 1);
            float f12 = f2 + this.textAscent() + (f10 - f11) / 2.0f;
            for (int i = 0; i < n4; ++i) {
                this.textLineImpl(this.textBuffer, this.textBreakStart[i], this.textBreakStop[i], f9, f12);
                f12 += this.textLeading;
            }
        } else if (this.textAlignY == 102) {
            int n5 = Math.min(this.textBreakCount, n3);
            float f13 = f4 - this.textDescent() - this.textLeading * (float)(n5 - 1);
            for (int i = 0; i < n5; ++i) {
                this.textLineImpl(this.textBuffer, this.textBreakStart[i], this.textBreakStop[i], f9, f13);
                f13 += this.textLeading;
            }
        } else {
            float f14 = f2 + this.textAscent();
            for (int i = 0; i < n3; ++i) {
                this.textLineImpl(this.textBuffer, this.textBreakStart[i], this.textBreakStop[i], f9, f14);
                f14 += this.textLeading;
            }
        }
        if (this.textMode == 256) {
            this.updatePixels();
        }
    }

    protected boolean textSentence(char[] cArray, int n, int n2, float f, float f2) {
        float f3 = 0.0f;
        int n3 = n;
        int n4 = n;
        int n5 = n;
        while (n5 <= n2) {
            if (cArray[n5] == ' ' || n5 == n2) {
                float f4 = this.textWidthImpl(cArray, n4, n5);
                if (f3 + f4 > f) {
                    if (f3 != 0.0f) {
                        this.textSentenceBreak(n3, n5);
                        while (n5 < n2 && cArray[n5] == ' ') {
                            ++n5;
                        }
                    } else {
                        do {
                            if (--n5 != n4) continue;
                            return false;
                        } while ((f4 = this.textWidthImpl(cArray, n4, n5)) > f);
                        this.textSentenceBreak(n3, n5);
                    }
                    n3 = n5;
                    n4 = n5;
                    f3 = 0.0f;
                    continue;
                }
                if (n5 == n2) {
                    this.textSentenceBreak(n3, n5);
                    ++n5;
                    continue;
                }
                f3 += f4 + f2;
                n4 = n5 + 1;
                ++n5;
                continue;
            }
            ++n5;
        }
        return true;
    }

    protected void textSentenceBreak(int n, int n2) {
        if (this.textBreakCount == this.textBreakStart.length) {
            this.textBreakStart = PApplet.expand(this.textBreakStart);
            this.textBreakStop = PApplet.expand(this.textBreakStop);
        }
        this.textBreakStart[this.textBreakCount] = n;
        this.textBreakStop[this.textBreakCount] = n2;
        ++this.textBreakCount;
    }

    public void text(String string, float f, float f2, float f3, float f4, float f5) {
        if (f5 != 0.0f && this.textMode == 256) {
            String string2 = "textMode(SCREEN) cannot have a z coordinate";
            throw new RuntimeException(string2);
        }
        if (f5 != 0.0f) {
            this.translate(0.0f, 0.0f, f5);
        }
        this.text(string, f, f2, f3, f4);
        this.textZ = f5;
        if (f5 != 0.0f) {
            this.translate(0.0f, 0.0f, -f5);
        }
    }

    public void text(int n, float f, float f2) {
        this.text(String.valueOf(n), f, f2);
    }

    public void text(int n, float f, float f2, float f3) {
        this.text(String.valueOf(n), f, f2, f3);
    }

    public void text(float f, float f2, float f3) {
        this.text(PApplet.nfs(f, 0, 3), f2, f3);
    }

    public void text(float f, float f2, float f3, float f4) {
        this.text(PApplet.nfs(f, 0, 3), f2, f3, f4);
    }

    protected void textCharImpl(char c, float f, float f2) {
        int n = this.textFont.index(c);
        if (n == -1) {
            return;
        }
        PImage pImage = this.textFont.images[n];
        if (this.textMode == 4) {
            float f3 = (float)this.textFont.height[n] / this.textFont.fheight;
            float f4 = (float)this.textFont.width[n] / this.textFont.fwidth;
            float f5 = (float)this.textFont.leftExtent[n] / this.textFont.fwidth;
            float f6 = (float)this.textFont.topExtent[n] / this.textFont.fheight;
            float f7 = f + f5 * this.textSize;
            float f8 = f2 - f6 * this.textSize;
            float f9 = f7 + f4 * this.textSize;
            float f10 = f8 + f3 * this.textSize;
            this.textCharModelImpl(pImage, f7, f8, f9, f10, this.textFont.width[n], this.textFont.height[n]);
        } else if (this.textMode == 256) {
            int n2 = (int)f + this.textFont.leftExtent[n];
            int n3 = (int)f2 - this.textFont.topExtent[n];
            int n4 = this.textFont.width[n];
            int n5 = this.textFont.height[n];
            this.textCharScreenImpl(pImage, n2, n3, n4, n5);
        }
    }

    protected void textCharModelImpl(PImage pImage, float f, float f2, float f3, float f4, int n, int n2) {
        boolean bl = this.tint;
        int n3 = this.tintColor;
        float f5 = this.tintR;
        float f6 = this.tintG;
        float f7 = this.tintB;
        float f8 = this.tintA;
        boolean bl2 = this.tintAlpha;
        this.tint = true;
        this.tintColor = this.fillColor;
        this.tintR = this.fillR;
        this.tintG = this.fillG;
        this.tintB = this.fillB;
        this.tintA = this.fillA;
        this.tintAlpha = this.fillAlpha;
        this.imageImpl(pImage, f, f2, f3, f4, 0, 0, n, n2);
        this.tint = bl;
        this.tintColor = n3;
        this.tintR = f5;
        this.tintG = f6;
        this.tintB = f7;
        this.tintA = f8;
        this.tintAlpha = bl2;
    }

    protected void textCharScreenImpl(PImage pImage, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        if (n >= this.width || n2 >= this.height || n + n3 < 0 || n2 + n4 < 0) {
            return;
        }
        if (n < 0) {
            n5 -= n;
            n3 += n;
            n = 0;
        }
        if (n2 < 0) {
            n6 -= n2;
            n4 += n2;
            n2 = 0;
        }
        if (n + n3 > this.width) {
            n3 -= n + n3 - this.width;
        }
        if (n2 + n4 > this.height) {
            n4 -= n2 + n4 - this.height;
        }
        int n7 = this.fillRi;
        int n8 = this.fillGi;
        int n9 = this.fillBi;
        int n10 = this.fillAi;
        int[] nArray = pImage.pixels;
        for (int i = n6; i < n6 + n4; ++i) {
            for (int j = n5; j < n5 + n3; ++j) {
                int n11 = n10 * nArray[i * this.textFont.twidth + j] >> 8;
                int n12 = n11 ^ 0xFF;
                int n13 = this.pixels[(n2 + i - n6) * this.width + (n + j - n5)];
                this.pixels[(n2 + i - n6) * this.width + n + j - n5] = 0xFF000000 | (n11 * n7 + n12 * (n13 >> 16 & 0xFF) & 0xFF00) << 8 | n11 * n8 + n12 * (n13 >> 8 & 0xFF) & 0xFF00 | n11 * n9 + n12 * (n13 & 0xFF) >> 8;
            }
        }
    }

    public void translate(float f, float f2) {
        this.m02 += f * this.m00 + f2 * this.m01 + this.m02;
        this.m12 += f * this.m10 + f2 * this.m11 + this.m12;
    }

    public void translate(float f, float f2, float f3) {
        this.depthErrorXYZ("translate");
    }

    public void rotate(float f) {
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        this.applyMatrix(f2, -f3, 0.0f, f3, f2, 0.0f);
    }

    public void rotateX(float f) {
        this.depthError("rotateX");
    }

    public void rotateY(float f) {
        this.depthError("rotateY");
    }

    public void rotateZ(float f) {
        this.depthError("rotateZ");
    }

    public void rotate(float f, float f2, float f3, float f4) {
        throw new RuntimeException("rotate(angle, x, y, z) can only be used with P3D or OPENGL");
    }

    public void scale(float f) {
        this.applyMatrix(f, 0.0f, 0.0f, 0.0f, f, 0.0f);
    }

    public void scale(float f, float f2) {
        this.applyMatrix(f, 0.0f, 0.0f, 0.0f, f2, 0.0f);
    }

    public void scale(float f, float f2, float f3) {
        this.depthErrorXYZ("scale");
    }

    public void pushMatrix() {
        if (this.matrixStackDepth + 1 == 32) {
            throw new RuntimeException("too many calls to pushMatrix()");
        }
        float[] fArray = this.matrixStack[this.matrixStackDepth];
        fArray[0] = this.m00;
        fArray[1] = this.m01;
        fArray[2] = this.m02;
        fArray[3] = this.m10;
        fArray[4] = this.m11;
        fArray[5] = this.m12;
        ++this.matrixStackDepth;
    }

    public void popMatrix() {
        if (this.matrixStackDepth == 0) {
            throw new RuntimeException("too many calls to popMatrix() (and not enough to pushMatrix)");
        }
        --this.matrixStackDepth;
        float[] fArray = this.matrixStack[this.matrixStackDepth];
        this.m00 = fArray[0];
        this.m01 = fArray[1];
        this.m02 = fArray[2];
        this.m10 = fArray[3];
        this.m11 = fArray[4];
        this.m12 = fArray[5];
    }

    public void resetMatrix() {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = this.m00 * f + this.m01 * f4;
        float f8 = this.m00 * f2 + this.m01 * f5;
        float f9 = this.m00 * f3 + this.m01 * f6 + this.m02;
        float f10 = this.m10 * f + this.m11 * f4;
        float f11 = this.m10 * f2 + this.m11 * f5;
        float f12 = this.m10 * f3 + this.m11 * f6 + this.m12;
        this.m00 = f7;
        this.m01 = f8;
        this.m02 = f9;
        this.m10 = f10;
        this.m11 = f11;
        this.m12 = f12;
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        throw new RuntimeException("applyMatrix() with a 4x4 matrix can only be used with OPENGL or P3D");
    }

    public void loadMatrix() {
    }

    public void printMatrix() {
        this.loadMatrix();
        float f = Math.abs(this.m00);
        if (Math.abs(this.m01) > f) {
            f = Math.abs(this.m01);
        }
        if (Math.abs(this.m02) > f) {
            f = Math.abs(this.m02);
        }
        if (Math.abs(this.m10) > f) {
            f = Math.abs(this.m10);
        }
        if (Math.abs(this.m11) > f) {
            f = Math.abs(this.m11);
        }
        if (Math.abs(this.m12) > f) {
            f = Math.abs(this.m12);
        }
        if (Float.isNaN(f) || Float.isInfinite(f)) {
            f = 1000000.0f;
        }
        int n = 1;
        int n2 = (int)f;
        while ((n2 /= 10) != 0) {
            ++n;
        }
        System.out.println(PApplet.nfs(this.m00, n, 4) + " " + PApplet.nfs(this.m01, n, 4) + " " + PApplet.nfs(this.m02, n, 4));
        System.out.println(PApplet.nfs(this.m10, n, 4) + " " + PApplet.nfs(this.m11, n, 4) + " " + PApplet.nfs(this.m12, n, 4));
        System.out.println();
    }

    public void beginCamera() {
        this.depthError("beginCamera");
    }

    public void endCamera() {
        this.depthError("endCamera");
    }

    public void camera() {
        this.depthError("camera");
    }

    public void camera(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.depthError("camera");
    }

    public void printCamera() {
        this.depthError("printCamera");
    }

    public void ortho() {
        this.depthError("ortho");
    }

    public void ortho(float f, float f2, float f3, float f4, float f5, float f6) {
        this.depthError("ortho");
    }

    public void perspective() {
        this.depthError("perspective");
    }

    public void perspective(float f, float f2, float f3, float f4) {
        this.depthError("perspective");
    }

    public void frustum(float f, float f2, float f3, float f4, float f5, float f6) {
        this.depthError("frustum");
    }

    public void printProjection() {
        this.depthError("printCamera");
    }

    public float screenX(float f, float f2) {
        return this.m00 * f + this.m01 * f2 + this.m02;
    }

    public float screenY(float f, float f2) {
        return this.m10 * f + this.m11 * f2 + this.m12;
    }

    public float screenX(float f, float f2, float f3) {
        this.depthErrorXYZ("screenX");
        return 0.0f;
    }

    public float screenY(float f, float f2, float f3) {
        this.depthErrorXYZ("screenY");
        return 0.0f;
    }

    public float screenZ(float f, float f2, float f3) {
        this.depthErrorXYZ("screenZ");
        return 0.0f;
    }

    public float modelX(float f, float f2, float f3) {
        this.depthError("modelX");
        return 0.0f;
    }

    public float modelY(float f, float f2, float f3) {
        this.depthError("modelY");
        return 0.0f;
    }

    public float modelZ(float f, float f2, float f3) {
        this.depthError("modelZ");
        return 0.0f;
    }

    public void colorMode(int n) {
        this.colorMode(n, this.colorModeX, this.colorModeY, this.colorModeZ, this.colorModeA);
    }

    public void colorMode(int n, float f) {
        this.colorMode(n, f, f, f, f);
    }

    public void colorMode(int n, float f, float f2, float f3) {
        this.colorMode(n, f, f2, f3, this.colorModeA);
    }

    public void colorMode(int n, float f, float f2, float f3, float f4) {
        this.colorMode = n;
        this.colorModeX = f;
        this.colorModeY = f2;
        this.colorModeZ = f3;
        this.colorModeA = f4;
        this.colorScale = f4 != 1.0f || f != f2 || f2 != f3 || f3 != f4;
        this.colorRgb255 = this.colorMode == 1 && this.colorModeA == 255.0f && this.colorModeX == 255.0f && this.colorModeY == 255.0f && this.colorModeZ == 255.0f;
    }

    protected void colorCalc(float f) {
        this.colorCalc(f, this.colorModeA);
    }

    protected void colorCalc(float f, float f2) {
        if (f > this.colorModeX) {
            f = this.colorModeX;
        }
        if (f2 > this.colorModeA) {
            f2 = this.colorModeA;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        this.calcG = this.calcR = this.colorScale ? f / this.colorModeX : f;
        this.calcB = this.calcR;
        this.calcA = this.colorScale ? f2 / this.colorModeA : f2;
        this.calcRi = (int)(this.calcR * 255.0f);
        this.calcGi = (int)(this.calcG * 255.0f);
        this.calcBi = (int)(this.calcB * 255.0f);
        this.calcAi = (int)(this.calcA * 255.0f);
        this.calcColor = this.calcAi << 24 | this.calcRi << 16 | this.calcGi << 8 | this.calcBi;
        this.calcAlpha = this.calcAi != 255;
    }

    protected void colorCalc(float f, float f2, float f3) {
        this.colorCalc(f, f2, f3, this.colorModeA);
    }

    protected void colorCalc(float f, float f2, float f3, float f4) {
        if (f > this.colorModeX) {
            f = this.colorModeX;
        }
        if (f2 > this.colorModeY) {
            f2 = this.colorModeY;
        }
        if (f3 > this.colorModeZ) {
            f3 = this.colorModeZ;
        }
        if (f4 > this.colorModeA) {
            f4 = this.colorModeA;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f4 < 0.0f) {
            f4 = 0.0f;
        }
        block0 : switch (this.colorMode) {
            case 1: {
                if (this.colorScale) {
                    this.calcR = f / this.colorModeX;
                    this.calcG = f2 / this.colorModeY;
                    this.calcB = f3 / this.colorModeZ;
                    this.calcA = f4 / this.colorModeA;
                    break;
                }
                this.calcR = f;
                this.calcG = f2;
                this.calcB = f3;
                this.calcA = f4;
                break;
            }
            case 3: {
                f /= this.colorModeX;
                f3 /= this.colorModeZ;
                float f5 = this.calcA = this.colorScale ? f4 / this.colorModeA : f4;
                if ((f2 /= this.colorModeY) == 0.0f) {
                    this.calcG = this.calcB = f3;
                    this.calcR = this.calcB;
                    break;
                }
                float f6 = (f - (float)((int)f)) * 6.0f;
                float f7 = f6 - (float)((int)f6);
                float f8 = f3 * (1.0f - f2);
                float f9 = f3 * (1.0f - f2 * f7);
                float f10 = f3 * (1.0f - f2 * (1.0f - f7));
                switch ((int)f6) {
                    case 0: {
                        this.calcR = f3;
                        this.calcG = f10;
                        this.calcB = f8;
                        break block0;
                    }
                    case 1: {
                        this.calcR = f9;
                        this.calcG = f3;
                        this.calcB = f8;
                        break block0;
                    }
                    case 2: {
                        this.calcR = f8;
                        this.calcG = f3;
                        this.calcB = f10;
                        break block0;
                    }
                    case 3: {
                        this.calcR = f8;
                        this.calcG = f9;
                        this.calcB = f3;
                        break block0;
                    }
                    case 4: {
                        this.calcR = f10;
                        this.calcG = f8;
                        this.calcB = f3;
                        break block0;
                    }
                    case 5: {
                        this.calcR = f3;
                        this.calcG = f8;
                        this.calcB = f9;
                    }
                }
            }
        }
        this.calcRi = (int)(255.0f * this.calcR);
        this.calcGi = (int)(255.0f * this.calcG);
        this.calcBi = (int)(255.0f * this.calcB);
        this.calcAi = (int)(255.0f * this.calcA);
        this.calcColor = this.calcAi << 24 | this.calcRi << 16 | this.calcGi << 8 | this.calcBi;
        this.calcAlpha = this.calcAi != 255;
    }

    protected void colorCalcARGB(int n, float f) {
        if (f == this.colorModeA) {
            this.calcAi = n >> 24 & 0xFF;
            this.calcColor = n;
        } else {
            this.calcAi = (int)((float)(n >> 24 & 0xFF) * (f / this.colorModeA));
            this.calcColor = this.calcAi << 24 | n & 0xFFFFFF;
        }
        this.calcRi = n >> 16 & 0xFF;
        this.calcGi = n >> 8 & 0xFF;
        this.calcBi = n & 0xFF;
        this.calcA = (float)this.calcAi / 255.0f;
        this.calcR = (float)this.calcRi / 255.0f;
        this.calcG = (float)this.calcGi / 255.0f;
        this.calcB = (float)this.calcBi / 255.0f;
        this.calcAlpha = this.calcAi != 255;
    }

    public void strokeWeight(float f) {
        this.strokeWeight = f;
    }

    public void strokeJoin(int n) {
        this.strokeJoin = n;
    }

    public void strokeCap(int n) {
        this.strokeCap = n;
    }

    public void noStroke() {
        this.stroke = false;
    }

    public void stroke(int n) {
        if ((n & 0xFF000000) == 0 && (float)n <= this.colorModeX) {
            this.stroke((float)n);
        } else {
            this.colorCalcARGB(n, this.colorModeA);
            this.strokeFromCalc();
        }
    }

    public void stroke(int n, float f) {
        if ((n & 0xFF000000) == 0 && (float)n <= this.colorModeX) {
            this.stroke((float)n, f);
        } else {
            this.colorCalcARGB(n, f);
            this.strokeFromCalc();
        }
    }

    public void stroke(float f) {
        this.colorCalc(f);
        this.strokeFromCalc();
    }

    public void stroke(float f, float f2) {
        this.colorCalc(f, f2);
        this.strokeFromCalc();
    }

    public void stroke(float f, float f2, float f3) {
        this.colorCalc(f, f2, f3);
        this.strokeFromCalc();
    }

    public void stroke(float f, float f2, float f3, float f4) {
        this.colorCalc(f, f2, f3, f4);
        this.strokeFromCalc();
    }

    protected void strokeFromCalc() {
        this.stroke = true;
        this.strokeR = this.calcR;
        this.strokeG = this.calcG;
        this.strokeB = this.calcB;
        this.strokeA = this.calcA;
        this.strokeRi = this.calcRi;
        this.strokeGi = this.calcGi;
        this.strokeBi = this.calcBi;
        this.strokeAi = this.calcAi;
        this.strokeColor = this.calcColor;
        this.strokeAlpha = this.calcAlpha;
    }

    public void noTint() {
        this.tint = false;
    }

    public void tint(int n) {
        if ((n & 0xFF000000) == 0 && (float)n <= this.colorModeX) {
            this.tint((float)n);
        } else {
            this.colorCalcARGB(n, this.colorModeA);
            this.tintFromCalc();
        }
    }

    public void tint(int n, float f) {
        if ((n & 0xFF000000) == 0 && (float)n <= this.colorModeX) {
            this.tint((float)n, f);
        } else {
            this.colorCalcARGB(n, f);
            this.tintFromCalc();
        }
    }

    public void tint(float f) {
        this.colorCalc(f);
        this.tintFromCalc();
    }

    public void tint(float f, float f2) {
        this.colorCalc(f, f2);
        this.tintFromCalc();
    }

    public void tint(float f, float f2, float f3) {
        this.colorCalc(f, f2, f3);
        this.tintFromCalc();
    }

    public void tint(float f, float f2, float f3, float f4) {
        this.colorCalc(f, f2, f3, f4);
        this.tintFromCalc();
    }

    protected void tintFromCalc() {
        this.tint = true;
        this.tintR = this.calcR;
        this.tintG = this.calcG;
        this.tintB = this.calcB;
        this.tintA = this.calcA;
        this.tintRi = this.calcRi;
        this.tintGi = this.calcGi;
        this.tintBi = this.calcBi;
        this.tintAi = this.calcAi;
        this.tintColor = this.calcColor;
        this.tintAlpha = this.calcAlpha;
    }

    public void noFill() {
        this.fill = false;
    }

    public void fill(int n) {
        if ((n & 0xFF000000) == 0 && (float)n <= this.colorModeX) {
            this.fill((float)n);
        } else {
            this.colorCalcARGB(n, this.colorModeA);
            this.fillFromCalc();
        }
    }

    public void fill(int n, float f) {
        if ((n & 0xFF000000) == 0 && (float)n <= this.colorModeX) {
            this.fill((float)n, f);
        } else {
            this.colorCalcARGB(n, f);
            this.fillFromCalc();
        }
    }

    public void fill(float f) {
        this.colorCalc(f);
        this.fillFromCalc();
    }

    public void fill(float f, float f2) {
        this.colorCalc(f, f2);
        this.fillFromCalc();
    }

    public void fill(float f, float f2, float f3) {
        this.colorCalc(f, f2, f3);
        this.fillFromCalc();
    }

    public void fill(float f, float f2, float f3, float f4) {
        this.colorCalc(f, f2, f3, f4);
        this.fillFromCalc();
    }

    protected void fillFromCalc() {
        this.fill = true;
        this.fillR = this.calcR;
        this.fillG = this.calcG;
        this.fillB = this.calcB;
        this.fillA = this.calcA;
        this.fillRi = this.calcRi;
        this.fillGi = this.calcGi;
        this.fillBi = this.calcBi;
        this.fillAi = this.calcAi;
        this.fillColor = this.calcColor;
        this.fillAlpha = this.calcAlpha;
    }

    public void ambient(int n) {
        this.depthError("ambient");
    }

    public void ambient(float f) {
        this.depthError("ambient");
    }

    public void ambient(float f, float f2, float f3) {
        this.depthError("ambient");
    }

    public void specular(int n) {
        this.depthError("specular");
    }

    public void specular(float f) {
        this.depthError("specular");
    }

    public void specular(float f, float f2) {
        this.depthError("specular");
    }

    public void specular(float f, float f2, float f3) {
        this.depthError("specular");
    }

    public void specular(float f, float f2, float f3, float f4) {
        this.depthError("specular");
    }

    public void shininess(float f) {
        this.depthError("shininess");
    }

    public void emissive(int n) {
        this.depthError("emissive");
    }

    public void emissive(float f) {
        this.depthError("emissive");
    }

    public void emissive(float f, float f2, float f3) {
        this.depthError("emissive");
    }

    public void lights() {
        this.depthError("lights");
    }

    public void noLights() {
        this.depthError("noLights");
    }

    public void ambientLight(float f, float f2, float f3) {
        this.depthError("ambientLight");
    }

    public void ambientLight(float f, float f2, float f3, float f4, float f5, float f6) {
        this.depthError("ambientLight");
    }

    public void directionalLight(float f, float f2, float f3, float f4, float f5, float f6) {
        this.depthError("directionalLight");
    }

    public void pointLight(float f, float f2, float f3, float f4, float f5, float f6) {
        this.depthError("pointLight");
    }

    public void spotLight(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        this.depthError("spotLight");
    }

    public void lightFalloff(float f, float f2, float f3) {
        this.depthError("lightFalloff");
    }

    public void lightSpecular(float f, float f2, float f3) {
        this.depthError("lightSpecular");
    }

    public void background(int n) {
        if ((n & 0xFF000000) == 0 && (float)n <= this.colorModeX) {
            this.background((float)n);
        } else {
            if (this.mainDrawingSurface) {
                n |= 0xFF000000;
            }
            this.colorCalcARGB(n, this.colorModeA);
            this.backgroundFromCalc();
            this.clear();
        }
    }

    public void background(int n, float f) {
        if (this.mainDrawingSurface) {
            this.background(n);
        } else if ((n & 0xFF000000) == 0 && (float)n <= this.colorModeX) {
            this.background((float)n, f);
        } else {
            this.colorCalcARGB(n, f);
            this.backgroundFromCalc();
            this.clear();
        }
    }

    public void background(float f) {
        this.colorCalc(f);
        this.backgroundFromCalc();
        this.clear();
    }

    public void background(float f, float f2) {
        if (this.mainDrawingSurface) {
            this.background(f);
        } else {
            this.colorCalc(f, f2);
            this.backgroundFromCalc();
            this.clear();
        }
    }

    public void background(float f, float f2, float f3) {
        this.colorCalc(f, f2, f3);
        this.backgroundFromCalc();
        this.clear();
    }

    public void background(float f, float f2, float f3, float f4) {
        if (this.mainDrawingSurface) {
            this.background(f, f2, f3);
        } else {
            this.colorCalc(f, f2, f3, f4);
            this.backgroundFromCalc();
            this.clear();
        }
    }

    protected void backgroundFromCalc() {
        this.backgroundR = this.calcR;
        this.backgroundG = this.calcG;
        this.backgroundB = this.calcB;
        this.backgroundA = this.calcA;
        this.backgroundRi = this.calcRi;
        this.backgroundGi = this.calcGi;
        this.backgroundBi = this.calcBi;
        this.backgroundAi = this.calcAi;
        this.backgroundAlpha = this.calcAlpha;
        this.backgroundColor = this.calcColor;
    }

    public void background(PImage pImage) {
        if (pImage.width != this.width || pImage.height != this.height) {
            throw new RuntimeException("background image must be the same size as your application");
        }
        if (pImage.format != 1 && pImage.format != 2) {
            throw new RuntimeException("background images should be RGB or ARGB");
        }
        this.backgroundColor = 0;
        System.arraycopy(pImage.pixels, 0, this.pixels, 0, this.pixels.length);
    }

    protected abstract void clear();

    protected void depthError(String string) {
        throw new RuntimeException(string + "() can only be used " + "with P3D or OPENGL.");
    }

    protected void depthErrorXYZ(String string) {
        throw new RuntimeException(string + "(x, y, z) can only be used with " + "OPENGL or P3D, use " + string + "(x, y) instead.");
    }

    protected void unavailableError(String string) {
        throw new RuntimeException(string + " is not available with this renderer");
    }

    public final int color(int n) {
        if ((n & 0xFF000000) == 0 && (float)n <= this.colorModeX) {
            if (this.colorRgb255) {
                if (n > 255) {
                    n = 255;
                } else if (n < 0) {
                    n = 0;
                }
                return 0xFF000000 | n << 16 | n << 8 | n;
            }
            this.colorCalc(n);
        } else {
            this.colorCalcARGB(n, this.colorModeA);
        }
        return this.calcColor;
    }

    public final int color(float f) {
        this.colorCalc(f);
        return this.calcColor;
    }

    public final int color(int n, int n2) {
        if (this.colorRgb255) {
            if (n > 255) {
                n = 255;
            } else if (n < 0) {
                n = 0;
            }
            if (n2 > 255) {
                n2 = 255;
            } else if (n2 < 0) {
                n2 = 0;
            }
            return (n2 & 0xFF) << 24 | n << 16 | n << 8 | n;
        }
        this.colorCalc(n, n2);
        return this.calcColor;
    }

    public final int color(int n, float f) {
        if ((n & 0xFF000000) == 0 && (float)n <= this.colorModeX) {
            this.colorCalc(n, f);
        } else {
            this.colorCalcARGB(n, f);
        }
        return this.calcColor;
    }

    public final int color(float f, float f2) {
        this.colorCalc(f, f2);
        return this.calcColor;
    }

    public final int color(int n, int n2, int n3) {
        if (this.colorRgb255) {
            if (n > 255) {
                n = 255;
            } else if (n < 0) {
                n = 0;
            }
            if (n2 > 255) {
                n2 = 255;
            } else if (n2 < 0) {
                n2 = 0;
            }
            if (n3 > 255) {
                n3 = 255;
            } else if (n3 < 0) {
                n3 = 0;
            }
            return 0xFF000000 | n << 16 | n2 << 8 | n3;
        }
        this.colorCalc(n, n2, n3);
        return this.calcColor;
    }

    public final int color(float f, float f2, float f3) {
        this.colorCalc(f, f2, f3);
        return this.calcColor;
    }

    public final int color(int n, int n2, int n3, int n4) {
        if (this.colorRgb255) {
            if (n4 > 255) {
                n4 = 255;
            } else if (n4 < 0) {
                n4 = 0;
            }
            if (n > 255) {
                n = 255;
            } else if (n < 0) {
                n = 0;
            }
            if (n2 > 255) {
                n2 = 255;
            } else if (n2 < 0) {
                n2 = 0;
            }
            if (n3 > 255) {
                n3 = 255;
            } else if (n3 < 0) {
                n3 = 0;
            }
            return n4 << 24 | n << 16 | n2 << 8 | n3;
        }
        this.colorCalc(n, n2, n3, n4);
        return this.calcColor;
    }

    public final int color(float f, float f2, float f3, float f4) {
        this.colorCalc(f, f2, f3, f4);
        return this.calcColor;
    }

    public final float alpha(int n) {
        float f = n >> 24 & 0xFF;
        if (this.colorModeA == 255.0f) {
            return f;
        }
        return f / 255.0f * this.colorModeA;
    }

    public final float red(int n) {
        float f = n >> 16 & 0xFF;
        if (this.colorRgb255) {
            return f;
        }
        return f / 255.0f * this.colorModeX;
    }

    public final float green(int n) {
        float f = n >> 8 & 0xFF;
        if (this.colorRgb255) {
            return f;
        }
        return f / 255.0f * this.colorModeY;
    }

    public final float blue(int n) {
        float f = n & 0xFF;
        if (this.colorRgb255) {
            return f;
        }
        return f / 255.0f * this.colorModeZ;
    }

    public final float hue(int n) {
        if (n != this.cacheHsbKey) {
            Color.RGBtoHSB(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF, this.cacheHsbValue);
            this.cacheHsbKey = n;
        }
        return this.cacheHsbValue[0] * this.colorModeX;
    }

    public final float saturation(int n) {
        if (n != this.cacheHsbKey) {
            Color.RGBtoHSB(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF, this.cacheHsbValue);
            this.cacheHsbKey = n;
        }
        return this.cacheHsbValue[1] * this.colorModeY;
    }

    public final float brightness(int n) {
        if (n != this.cacheHsbKey) {
            Color.RGBtoHSB(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF, this.cacheHsbValue);
            this.cacheHsbKey = n;
        }
        return this.cacheHsbValue[2] * this.colorModeZ;
    }

    public int lerpColor(int n, int n2, float f) {
        return PGraphics.lerpColor(n, n2, f, this.colorMode);
    }

    public static int lerpColor(int n, int n2, float f, int n3) {
        if (n3 == 1) {
            float f2 = n >> 24 & 0xFF;
            float f3 = n >> 16 & 0xFF;
            float f4 = n >> 8 & 0xFF;
            float f5 = n & 0xFF;
            float f6 = n2 >> 24 & 0xFF;
            float f7 = n2 >> 16 & 0xFF;
            float f8 = n2 >> 8 & 0xFF;
            float f9 = n2 & 0xFF;
            return (int)(f2 + (f6 - f2) * f) << 24 | (int)(f3 + (f7 - f3) * f) << 16 | (int)(f4 + (f8 - f4) * f) << 8 | (int)(f5 + (f9 - f5) * f);
        }
        if (n3 == 3) {
            if (lerpColorHSB1 == null) {
                lerpColorHSB1 = new float[3];
                lerpColorHSB2 = new float[3];
            }
            float f10 = n >> 24 & 0xFF;
            float f11 = n2 >> 24 & 0xFF;
            int n4 = (int)(f10 + (f11 - f10) * f) << 24;
            Color.RGBtoHSB(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF, lerpColorHSB1);
            Color.RGBtoHSB(n2 >> 16 & 0xFF, n2 >> 8 & 0xFF, n2 & 0xFF, lerpColorHSB2);
            float f12 = PApplet.lerp(lerpColorHSB1[0], lerpColorHSB2[0], f);
            float f13 = PApplet.lerp(lerpColorHSB1[1], lerpColorHSB2[1], f);
            float f14 = PApplet.lerp(lerpColorHSB1[2], lerpColorHSB2[2], f);
            return n4 | Color.HSBtoRGB(f12, f13, f14) & 0xFFFFFF;
        }
        return 0;
    }

    static final float sqrt(float f) {
        return (float)Math.sqrt(f);
    }

    public void mask(int[] nArray) {
        super.mask(nArray);
    }

    public void mask(PImage pImage) {
        super.mask(pImage);
    }

    public void beginRaw(PGraphics pGraphics) {
        this.raw = pGraphics;
        pGraphics.beginDraw();
    }

    public void endRaw() {
        if (this.raw != null) {
            this.flush();
            this.raw.endDraw();
            this.raw.dispose();
            this.raw = null;
        }
    }

    public void dispose() {
    }

    public boolean displayable() {
        return true;
    }

    static {
        for (int i = 0; i < 720; ++i) {
            PGraphics.sinLUT[i] = (float)Math.sin((float)i * ((float)Math.PI / 180) * 0.5f);
            PGraphics.cosLUT[i] = (float)Math.cos((float)i * ((float)Math.PI / 180) * 0.5f);
        }
    }
}

