/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.util.Arrays;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PLine;
import processing.core.PPolygon;

public class PGraphics2D
extends PGraphics {
    PPolygon polygon;
    PPolygon fpolygon;
    PPolygon spolygon;
    float[][] svertices;
    private PPolygon tpolygon;
    private int TPOLYGON_MAX_VERTICES = 512;
    private int[] tpolygon_vertex_order;
    PLine line;
    boolean strokeChanged = true;
    boolean fillChanged = true;
    static final int CVERTEX_ALLOC = 128;
    float[][] cvertex = new float[128][36];
    int cvertexIndex;

    public PGraphics2D(int n, int n2, PApplet pApplet) {
        super(n, n2, pApplet);
    }

    protected void allocate() {
        this.pixelCount = this.width * this.height;
        this.pixels = new int[this.pixelCount];
        if (this.mainDrawingSurface) {
            this.cm = new DirectColorModel(32, 0xFF0000, 65280, 255);
            this.mis = new MemoryImageSource(this.width, this.height, this.pixels, 0, this.width);
            this.mis.setFullBufferUpdates(true);
            this.mis.setAnimated(true);
            this.image = Toolkit.getDefaultToolkit().createImage(this.mis);
        }
    }

    public void beginDraw() {
        if (!this.settingsInited) {
            this.defaultSettings();
            this.polygon = new PPolygon(this);
            this.fpolygon = new PPolygon(this);
            this.spolygon = new PPolygon(this);
            this.spolygon.vertexCount = 4;
            this.svertices = new float[2][];
        }
        this.resetMatrix();
        this.vertexCount = 0;
    }

    public void endDraw() {
        if (this.mis != null) {
            this.mis.newPixels(this.pixels, (ColorModel)this.cm, 0, this.width);
        }
        this.updatePixels();
    }

    public void beginShape(int n) {
        this.shape = n;
        this.vertexCount = 0;
        this.splineVertexCount = 0;
        this.polygon.reset(0);
        this.fpolygon.reset(4);
        this.spolygon.reset(4);
        this.polygon.interpUV = false;
    }

    public void vertex(float f, float f2) {
        float[] fArray = this.polygon.nextVertex();
        this.cvertexIndex = 0;
        fArray[9] = f;
        fArray[10] = f2;
        if (this.fill) {
            fArray[3] = this.fillR;
            fArray[4] = this.fillG;
            fArray[5] = this.fillB;
            fArray[6] = this.fillA;
        }
        if (this.stroke) {
            fArray[12] = this.strokeR;
            fArray[13] = this.strokeG;
            fArray[14] = this.strokeB;
            fArray[15] = this.strokeA;
            fArray[16] = this.strokeWeight;
        }
        if (this.textureImage != null) {
            fArray[7] = this.textureU;
            fArray[8] = this.textureV;
        }
    }

    public void vertex(float f, float f2, float f3, float f4) {
        this.textureVertex(f3, f4);
        this.vertex(f, f2);
    }

    public void vertex(float f, float f2, float f3) {
        this.depthErrorXYZ("vertex");
    }

    public void vertex(float f, float f2, float f3, float f4, float f5) {
        this.depthErrorXYZ("vertex");
    }

    public void endShape(int n) {
        int n2;
        int n3 = this.polygon.vertexCount;
        float[][] fArray = this.polygon.vertices;
        if (this.untransformed()) {
            for (n2 = 0; n2 < n3; ++n2) {
                fArray[n2][0] = fArray[n2][9];
                fArray[n2][1] = fArray[n2][10];
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                fArray[n2][0] = this.m00 * fArray[n2][9] + this.m01 * fArray[n2][10] + this.m03;
                fArray[n2][1] = this.m10 * fArray[n2][9] + this.m11 * fArray[n2][10] + this.m13;
            }
        }
        if (this.polygon.interpUV) {
            this.fpolygon.texture(this.textureImage);
        }
        this.spolygon.interpARGB = this.strokeChanged;
        this.fpolygon.interpARGB = this.fillChanged;
        switch (this.shape) {
            case 16: {
                if (this.untransformed() && this.strokeWeight == 1.0f) {
                    if (!this.strokeChanged) {
                        for (int i = 0; i < n3; ++i) {
                            this.thin_point((int)fArray[i][0], (int)fArray[i][1], 0.0f, this.strokeColor);
                        }
                    } else {
                        for (int i = 0; i < n3; ++i) {
                            this.thin_point((int)fArray[i][0], (int)fArray[i][1], 0.0f, PGraphics2D.float_color(fArray[i][12], fArray[i][13], fArray[i][14]));
                        }
                    }
                } else {
                    float[] fArray2 = fArray[0];
                    for (int i = 0; i < n3; ++i) {
                        float[] fArray3 = fArray[i];
                        if (i == 0 || this.strokeChanged) {
                            this.calc_lighting(fArray3[12], fArray3[13], fArray3[14], fArray3[0], fArray3[1], fArray3[2], fArray3[17], fArray3[18], fArray3[19], fArray2, 3);
                        }
                        this.thick_point(fArray3[0], fArray3[1], fArray3[2], fArray2[3], fArray2[4], fArray2[5], fArray2[15]);
                    }
                }
                break;
            }
            case 32: {
                if (!this.stroke) {
                    return;
                }
                if (n == 2) {
                    float[] fArray4 = this.polygon.vertices[0];
                    float[] fArray5 = this.polygon.nextVertex();
                    ++n3;
                    fArray5[0] = fArray4[0];
                    fArray5[1] = fArray4[1];
                    fArray5[2] = fArray4[2];
                    fArray5[12] = fArray4[12];
                    fArray5[13] = fArray4[13];
                    fArray5[14] = fArray4[14];
                }
                n2 = this.shape == 32 ? 2 : 1;
                this.draw_lines(fArray, n3 - 1, 1, n2, 0);
                break;
            }
            case 64: 
            case 65: {
                int n4 = n2 = this.shape == 64 ? 3 : 1;
                if (this.fill) {
                    this.fpolygon.vertexCount = 3;
                    for (int i = 0; i < n3 - 2; i += n2) {
                        for (int j = 0; j < 3; ++j) {
                            this.fpolygon.vertices[j][3] = fArray[i + j][3];
                            this.fpolygon.vertices[j][4] = fArray[i + j][4];
                            this.fpolygon.vertices[j][5] = fArray[i + j][5];
                            this.fpolygon.vertices[j][6] = fArray[i + j][6];
                            this.fpolygon.vertices[j][0] = fArray[i + j][0];
                            this.fpolygon.vertices[j][1] = fArray[i + j][1];
                            this.fpolygon.vertices[j][2] = fArray[i + j][2];
                            if (!this.polygon.interpUV) continue;
                            this.fpolygon.vertices[j][7] = fArray[i + j][7];
                            this.fpolygon.vertices[j][8] = fArray[i + j][8];
                        }
                        this.fpolygon.render();
                    }
                }
                if (!this.stroke) break;
                if (this.shape == 65) {
                    this.draw_lines(fArray, n3 - 1, 1, 1, 0);
                } else {
                    this.draw_lines(fArray, n3 - 1, 1, 1, 3);
                }
                this.draw_lines(fArray, n3 - 2, 2, n2, 0);
                break;
            }
            case 128: 
            case 129: {
                int n5 = n2 = this.shape == 128 ? 4 : 2;
                if (this.fill) {
                    this.fpolygon.vertexCount = 4;
                    for (int i = 0; i < n3 - 3; i += n2) {
                        for (int j = 0; j < 4; ++j) {
                            this.fpolygon.vertices[j][3] = fArray[i + j][3];
                            this.fpolygon.vertices[j][4] = fArray[i + j][4];
                            this.fpolygon.vertices[j][5] = fArray[i + j][5];
                            this.fpolygon.vertices[j][6] = fArray[i + j][6];
                            this.fpolygon.vertices[j][0] = fArray[i + j][0];
                            this.fpolygon.vertices[j][1] = fArray[i + j][1];
                            this.fpolygon.vertices[j][2] = fArray[i + j][2];
                            if (!this.polygon.interpUV) continue;
                            this.fpolygon.vertices[j][7] = fArray[i + j][7];
                            this.fpolygon.vertices[j][8] = fArray[i + j][8];
                        }
                        this.fpolygon.render();
                    }
                }
                if (!this.stroke) break;
                if (this.shape == 129) {
                    this.draw_lines(fArray, n3 - 1, 1, 1, 0);
                } else {
                    this.draw_lines(fArray, n3, 1, 1, 4);
                }
                this.draw_lines(fArray, n3 - 2, 3, n2, 0);
                break;
            }
            case 256: {
                if (this.isConvex()) {
                    if (this.fill) {
                        this.polygon.render();
                        if (this.stroke) {
                            this.polygon.unexpand();
                        }
                    }
                    if (!this.stroke) break;
                    this.draw_lines(fArray, n3 - 1, 1, 1, 0);
                    this.svertices[0] = fArray[n3 - 1];
                    this.svertices[1] = fArray[0];
                    this.draw_lines(this.svertices, 1, 1, 1, 0);
                    break;
                }
                if (this.fill) {
                    boolean bl = this.smooth;
                    if (this.stroke) {
                        this.smooth = false;
                    }
                    this.concaveRender();
                    if (this.stroke) {
                        this.smooth = bl;
                    }
                }
                if (!this.stroke) break;
                this.draw_lines(fArray, n3 - 1, 1, 1, 0);
                this.svertices[0] = fArray[n3 - 1];
                this.svertices[1] = fArray[0];
                this.draw_lines(this.svertices, 1, 1, 1, 0);
            }
        }
        this.shape = 0;
    }

    private boolean isConvex() {
        float[][] fArray = this.polygon.vertices;
        int n = this.polygon.vertexCount;
        int n2 = 0;
        if (n < 3) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            int n3 = (i + 1) % n;
            int n4 = (i + 2) % n;
            float f = (fArray[n3][0] - fArray[i][0]) * (fArray[n4][1] - fArray[n3][1]);
            if ((f -= (fArray[n3][1] - fArray[i][1]) * (fArray[n4][0] - fArray[n3][0])) < 0.0f) {
                n2 |= 1;
            } else if (f > 0.0f) {
                n2 |= 2;
            }
            if (n2 != 3) continue;
            return false;
        }
        if (n2 != 0) {
            return true;
        }
        return true;
    }

    private void concaveRender() {
        int n;
        float[][] fArray = this.polygon.vertices;
        if (this.tpolygon == null) {
            this.tpolygon = new PPolygon(this);
            this.tpolygon_vertex_order = new int[this.TPOLYGON_MAX_VERTICES];
        }
        this.tpolygon.reset(3);
        if (this.textureImage != null) {
            this.tpolygon.texture(this.textureImage);
        }
        this.tpolygon.interpX = this.polygon.interpX;
        this.tpolygon.interpZ = this.polygon.interpZ;
        this.tpolygon.interpUV = this.polygon.interpUV;
        this.tpolygon.interpARGB = this.polygon.interpARGB;
        boolean bl = false;
        int n2 = this.polygon.vertexCount;
        float[] fArray2 = new float[]{fArray[0][0], fArray[0][1]};
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!(fArray[i][1] < fArray2[1]) && (fArray[i][1] != fArray2[1] || !(fArray[i][0] > fArray2[0]))) continue;
            n3 = i;
            fArray2[0] = fArray[n3][0];
            fArray2[1] = fArray[n3][1];
        }
        float[] fArray3 = new float[2];
        float[] fArray4 = new float[2];
        float[] fArray5 = new float[2];
        int n4 = (n3 + (n2 - 1)) % n2;
        for (n = 0; n < 2; ++n) {
            fArray3[n] = fArray[n4][n];
            fArray4[n] = fArray[n3][n];
            fArray5[n] = fArray[(n3 + 1) % n2][n];
        }
        float f = fArray3[0] * fArray4[1] - fArray3[1] * fArray4[0] + fArray3[1] * fArray5[0] - fArray3[0] * fArray5[1] + fArray4[0] * fArray5[1] - fArray5[0] * fArray4[1];
        bl = f > 0.0f;
        if (!bl) {
            for (n = 0; n < n2; ++n) {
                this.tpolygon_vertex_order[n] = n;
            }
        } else {
            for (n = 0; n < n2; ++n) {
                this.tpolygon_vertex_order[n] = n2 - 1 - n;
            }
        }
        n = n2;
        int n5 = 2 * n;
        int n6 = 0;
        int n7 = n - 1;
        while (n > 2) {
            float f2;
            float f3;
            float f4;
            float f5;
            float f6;
            float f7;
            int n8;
            boolean bl2 = true;
            if (0 >= n5--) break;
            int n9 = n7;
            if (n <= n9) {
                n9 = 0;
            }
            if (n <= (n7 = n9 + 1)) {
                n7 = 0;
            }
            if (n <= (n8 = n7 + 1)) {
                n8 = 0;
            }
            if (1.0E-4f > ((f7 = -fArray[this.tpolygon_vertex_order[n7]][0]) - (f6 = -fArray[this.tpolygon_vertex_order[n9]][0])) * ((f5 = fArray[this.tpolygon_vertex_order[n8]][1]) - (f4 = fArray[this.tpolygon_vertex_order[n9]][1])) - ((f3 = fArray[this.tpolygon_vertex_order[n7]][1]) - f4) * ((f2 = -fArray[this.tpolygon_vertex_order[n8]][0]) - f6)) continue;
            for (int i = 0; i < n; ++i) {
                if (i == n9 || i == n7 || i == n8) continue;
                float f8 = -fArray[this.tpolygon_vertex_order[i]][0];
                float f9 = fArray[this.tpolygon_vertex_order[i]][1];
                float f10 = f2 - f7;
                float f11 = f5 - f3;
                float f12 = f6 - f2;
                float f13 = f4 - f5;
                float f14 = f7 - f6;
                float f15 = f3 - f4;
                float f16 = f8 - f6;
                float f17 = f9 - f4;
                float f18 = f8 - f7;
                float f19 = f9 - f3;
                float f20 = f8 - f2;
                float f21 = f9 - f5;
                float f22 = f10 * f19 - f11 * f18;
                float f23 = f14 * f17 - f15 * f16;
                float f24 = f12 * f21 - f13 * f20;
                if (!(f22 >= 0.0f) || !(f24 >= 0.0f) || !(f23 >= 0.0f)) continue;
                bl2 = false;
            }
            if (!bl2) continue;
            int[] nArray = new int[]{this.tpolygon_vertex_order[n9], this.tpolygon_vertex_order[n7], this.tpolygon_vertex_order[n8]};
            for (int i = 0; i < 3; ++i) {
                float[] fArray6 = this.polygon.vertices[nArray[i]];
                float[] fArray7 = this.tpolygon.vertices[i];
                for (int j = 0; j < 36; ++j) {
                    fArray7[j] = fArray6[j];
                }
            }
            this.tpolygon.render();
            ++n6;
            int n10 = n7;
            for (int i = n7 + 1; i < n; ++i) {
                this.tpolygon_vertex_order[n10] = this.tpolygon_vertex_order[i];
                ++n10;
            }
            n5 = 2 * --n;
        }
    }

    protected void rectImpl(float f, float f2, float f3, float f4) {
        if (this.untransformed() && !this.fillAlpha) {
            int n = (int)f;
            int n2 = (int)f2;
            int n3 = (int)f3;
            int n4 = (int)f4;
            this.rectImplFillUntranSolidRGB(n, n2, n3, n4);
            if (this.stroke) {
                if (this.strokeWeight == 1.0f) {
                    this.thin_flat_line(n, n2, n3, n2);
                    this.thin_flat_line(n3, n2, n3, n4);
                    this.thin_flat_line(n3, n4, n, n4);
                    this.thin_flat_line(n, n4, n, n2);
                } else {
                    this.thick_flat_line(n, n2, this.fillR, this.fillG, this.fillB, this.fillA, n3, n2, this.fillR, this.fillG, this.fillB, this.fillA);
                    this.thick_flat_line(n3, n2, this.fillR, this.fillG, this.fillB, this.fillA, n3, n4, this.fillR, this.fillG, this.fillB, this.fillA);
                    this.thick_flat_line(n3, n4, this.fillR, this.fillG, this.fillB, this.fillA, n, n4, this.fillR, this.fillG, this.fillB, this.fillA);
                    this.thick_flat_line(n, n4, this.fillR, this.fillG, this.fillB, this.fillA, n, n2, this.fillR, this.fillG, this.fillB, this.fillA);
                }
            }
        } else {
            this.beginShape(128);
            this.vertex(f, f2);
            this.vertex(f3, f2);
            this.vertex(f3, f4);
            this.vertex(f, f4);
            this.endShape();
        }
    }

    private void rectImplFillUntranSolidRGB(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (n4 < n2) {
            n6 = n2;
            n2 = n4;
            n4 = n6;
        }
        if (n3 < n) {
            n6 = n;
            n = n3;
            n3 = n6;
        }
        if (n > this.width1 || n3 < 0 || n2 > this.height1 || n4 < 0) {
            return;
        }
        n6 = n;
        int n7 = n2;
        int n8 = n3;
        int n9 = n4;
        if (n6 < 0) {
            n6 = 0;
        }
        if (n8 > this.width) {
            n8 = this.width;
        }
        if (n7 < 0) {
            n7 = 0;
        }
        if (n9 > this.height) {
            n9 = this.height;
        }
        int n10 = n8 - n6;
        int n11 = n9 - n7;
        int[] nArray = new int[n10];
        for (n5 = 0; n5 < n10; ++n5) {
            nArray[n5] = this.fillColor;
        }
        n5 = n7 * this.width + n6;
        for (int i = 0; i < n11; ++i) {
            System.arraycopy(nArray, 0, this.pixels, n5, n10);
            n5 += this.width;
        }
        nArray = null;
    }

    public void ellipseImpl(float f, float f2, float f3, float f4) {
        if (!this.smooth && this.strokeWeight == 1.0f && !this.fillAlpha && !this.strokeAlpha && this.untransformed()) {
            float f5 = f3 / 2.0f;
            float f6 = f4 / 2.0f;
            int n = (int)(f + f5);
            int n2 = (int)(f2 + f6);
            if (f5 == f6) {
                this.flat_circle(n, n2, (int)f5);
            } else {
                this.flat_ellipse(n, n2, (int)f5, (int)f6);
            }
        } else {
            super.ellipseImpl(f, f2, f3, f4);
        }
    }

    private void flat_circle(int n, int n2, int n3) {
        if (this.unwarped()) {
            float f = this.m00 * (float)n + this.m01 * (float)n2 + this.m02;
            float f2 = this.m10 * (float)n + this.m11 * (float)n2 + this.m12;
            n = (int)f;
            n2 = (int)f2;
        }
        if (this.fill) {
            this.flat_circle_fill(n, n2, n3);
        }
        if (this.stroke) {
            this.flat_circle_stroke(n, n2, n3);
        }
    }

    private void flat_circle_stroke(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n3;
        int n6 = 1;
        int n7 = 2 * n3 - 1;
        int n8 = 0;
        while (n4 < n5) {
            this.thin_point(n + n4, n2 + n5, 0.0f, this.strokeColor);
            this.thin_point(n + n5, n2 - n4, 0.0f, this.strokeColor);
            this.thin_point(n - n4, n2 - n5, 0.0f, this.strokeColor);
            this.thin_point(n - n5, n2 + n4, 0.0f, this.strokeColor);
            ++n4;
            if (n7 < 2 * (n8 += (n6 += 2))) {
                --n5;
                n8 -= n7;
                n7 -= 2;
            }
            if (n4 > n5) break;
            this.thin_point(n + n5, n2 + n4, 0.0f, this.strokeColor);
            this.thin_point(n + n4, n2 - n5, 0.0f, this.strokeColor);
            this.thin_point(n - n5, n2 - n4, 0.0f, this.strokeColor);
            this.thin_point(n - n4, n2 + n5, 0.0f, this.strokeColor);
        }
    }

    private void flat_circle_fill(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n3;
        int n6 = 1;
        int n7 = 2 * n3 - 1;
        int n8 = 0;
        while (n4 < n5) {
            int n9;
            for (n9 = n; n9 < n + n4; ++n9) {
                this.thin_point(n9, n2 + n5, 0.0f, this.fillColor);
            }
            for (n9 = n; n9 < n + n5; ++n9) {
                this.thin_point(n9, n2 - n4, 0.0f, this.fillColor);
            }
            for (n9 = n - n4; n9 < n; ++n9) {
                this.thin_point(n9, n2 - n5, 0.0f, this.fillColor);
            }
            for (n9 = n - n5; n9 < n; ++n9) {
                this.thin_point(n9, n2 + n4, 0.0f, this.fillColor);
            }
            ++n4;
            if (n7 < 2 * (n8 += (n6 += 2))) {
                --n5;
                n8 -= n7;
                n7 -= 2;
            }
            if (n4 > n5) break;
            for (n9 = n; n9 < n + n5; ++n9) {
                this.thin_point(n9, n2 + n4, 0.0f, this.fillColor);
            }
            for (n9 = n; n9 < n + n4; ++n9) {
                this.thin_point(n9, n2 - n5, 0.0f, this.fillColor);
            }
            for (n9 = n - n5; n9 < n; ++n9) {
                this.thin_point(n9, n2 - n4, 0.0f, this.fillColor);
            }
            for (n9 = n - n4; n9 < n; ++n9) {
                this.thin_point(n9, n2 + n5, 0.0f, this.fillColor);
            }
        }
    }

    private final void flat_ellipse_symmetry(int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            for (int i = n - n3 + 1; i < n + n3; ++i) {
                this.thin_point(i, n2 - n4, 0.0f, this.fillColor);
                this.thin_point(i, n2 + n4, 0.0f, this.fillColor);
            }
        } else {
            this.thin_point(n - n3, n2 + n4, 0.0f, this.strokeColor);
            this.thin_point(n + n3, n2 + n4, 0.0f, this.strokeColor);
            this.thin_point(n - n3, n2 - n4, 0.0f, this.strokeColor);
            this.thin_point(n + n3, n2 - n4, 0.0f, this.strokeColor);
        }
    }

    private void flat_ellipse_internal(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = n3 * n3;
        int n6 = n4 * n4;
        int n7 = 0;
        int n8 = n4;
        int n9 = n5 * (1 - 2 * n4) + 2 * n6;
        int n10 = n6 - 2 * n5 * (2 * n4 - 1);
        this.flat_ellipse_symmetry(n, n2, n7, n8, bl);
        do {
            if (n9 < 0) {
                n9 += 2 * n6 * (2 * n7 + 3);
                n10 += 4 * n6 * (n7 + 1);
                ++n7;
            } else if (n10 < 0) {
                n9 += 2 * n6 * (2 * n7 + 3) - 4 * n5 * (n8 - 1);
                n10 += 4 * n6 * (n7 + 1) - 2 * n5 * (2 * n8 - 3);
                ++n7;
                --n8;
            } else {
                n9 -= 4 * n5 * (n8 - 1);
                n10 -= 2 * n5 * (2 * n8 - 3);
                --n8;
            }
            this.flat_ellipse_symmetry(n, n2, n7, n8, bl);
        } while (n8 > 0);
    }

    private void flat_ellipse(int n, int n2, int n3, int n4) {
        if (this.unwarped()) {
            float f = this.m00 * (float)n + this.m01 * (float)n2 + this.m02;
            float f2 = this.m10 * (float)n + this.m11 * (float)n2 + this.m12;
            n = (int)f;
            n2 = (int)f2;
        }
        if (this.fill) {
            this.flat_ellipse_internal(n, n2, n3, n4, true);
        }
        if (this.stroke) {
            this.flat_ellipse_internal(n, n2, n3, n4, false);
        }
    }

    public void bezier(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.depthErrorXYZ("bezier");
    }

    public void curve(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.depthErrorXYZ("curve");
    }

    protected void imageImpl(PImage pImage, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4) {
        if (f3 - f == (float)pImage.width && f4 - f2 == (float)pImage.height && !this.tint && this.unwarped()) {
            this.flat_image(pImage, (int)(f + this.m02), (int)(f2 + this.m12), n, n2, n3, n4);
        } else {
            super.imageImpl(pImage, f, f2, f3, f4, n, n2, n3, n4);
        }
    }

    private void flat_image(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6) {
        block12: {
            int n7;
            int n8;
            int n9;
            int n10;
            block13: {
                block11: {
                    if (this.imageMode == 3) {
                        n -= pImage.width / 2;
                        n2 -= pImage.height / 2;
                    }
                    n10 = n + pImage.width;
                    n9 = n2 + pImage.height;
                    if (n > this.width1 || n10 < 0 || n2 > this.height1 || n9 < 0) {
                        return;
                    }
                    if (n < 0) {
                        n3 -= n;
                        n = 0;
                    }
                    if (n2 < 0) {
                        n4 -= n2;
                        n2 = 0;
                    }
                    if (n10 > this.width) {
                        n5 -= n10 - this.width;
                        n10 = this.width;
                    }
                    if (n9 > this.height) {
                        n6 -= n9 - this.height;
                        n9 = this.height;
                    }
                    n8 = n4 * pImage.width + n3;
                    n7 = n2 * this.width;
                    if (pImage.format != 2) break block11;
                    for (int i = n2; i < n9; ++i) {
                        int n11 = 0;
                        for (int j = n; j < n10; ++j) {
                            this.pixels[n7 + j] = PGraphics2D._blend(this.pixels[n7 + j], pImage.pixels[n8 + n11], pImage.pixels[n8 + n11++] >>> 24);
                        }
                        n8 += pImage.width;
                        n7 += this.width;
                    }
                    break block12;
                }
                if (pImage.format != 4) break block13;
                for (int i = n2; i < n9; ++i) {
                    int n12 = 0;
                    for (int j = n; j < n10; ++j) {
                        this.pixels[n7 + j] = PGraphics2D._blend(this.pixels[n7 + j], this.fillColor, pImage.pixels[n8 + n12++]);
                    }
                    n8 += pImage.width;
                    n7 += this.width;
                }
                break block12;
            }
            if (pImage.format != 1) break block12;
            n7 += n;
            int n13 = n10 - n;
            for (int i = n2; i < n9; ++i) {
                System.arraycopy(pImage.pixels, n8, this.pixels, n7, n13);
                n8 += pImage.width;
                n7 += this.width;
            }
        }
    }

    private void thin_pointAt(int n, int n2, float f, int n3) {
        int n4 = n2 * this.width + n;
        this.pixels[n4] = n3;
        this.zbuffer[n4] = f;
    }

    private void thin_pointAtIndex(int n, float f, int n2) {
        this.pixels[n] = n2;
        this.zbuffer[n] = f;
    }

    private void thick_point(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        this.spolygon.reset(4);
        this.spolygon.interpARGB = false;
        float f8 = this.strokeWeight / 2.0f;
        float[] fArray = this.spolygon.vertices[0];
        fArray[0] = f - f8;
        fArray[1] = f2 - f8;
        fArray[2] = f3;
        fArray[3] = f4;
        fArray[4] = f5;
        fArray[5] = f6;
        fArray[6] = f7;
        fArray = this.spolygon.vertices[1];
        fArray[0] = f + f8;
        fArray[1] = f2 - f8;
        fArray[2] = f3;
        fArray = this.spolygon.vertices[2];
        fArray[0] = f + f8;
        fArray[1] = f2 + f8;
        fArray[2] = f3;
        fArray = this.spolygon.vertices[3];
        fArray[0] = f - f8;
        fArray[1] = f2 + f8;
        fArray[2] = f3;
        this.spolygon.render();
    }

    private void thin_flat_line(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = this.thin_flat_lineClipCode(n, n2);
        if ((n11 & (n10 = this.thin_flat_lineClipCode(n3, n4))) != 0) {
            return;
        }
        int n12 = n11 | n10;
        if (n12 != 0) {
            float f = 0.0f;
            float f2 = 1.0f;
            float f3 = 0.0f;
            for (n9 = 0; n9 < 4; ++n9) {
                if ((n12 >> n9) % 2 != 1) continue;
                f3 = this.thin_flat_lineSlope(n, n2, n3, n4, n9 + 1);
                if ((n11 >> n9) % 2 == 1) {
                    f = Math.max(f3, f);
                    continue;
                }
                f2 = Math.min(f3, f2);
            }
            if (f > f2) {
                return;
            }
            n8 = (int)((float)n + f * (float)(n3 - n));
            n7 = (int)((float)n2 + f * (float)(n4 - n2));
            n6 = (int)((float)n + f2 * (float)(n3 - n));
            n5 = (int)((float)n2 + f2 * (float)(n4 - n2));
        } else {
            n8 = n;
            n6 = n3;
            n7 = n2;
            n5 = n4;
        }
        n12 = 0;
        int n13 = n5 - n7;
        int n14 = n6 - n8;
        if (Math.abs(n13) > Math.abs(n14)) {
            int n15 = n13;
            n13 = n14;
            n14 = n15;
            n12 = 1;
        }
        int n16 = n14 == 0 ? 0 : (n13 << 16) / n14;
        if (n8 == n6) {
            if (n7 > n5) {
                n9 = n7;
                n7 = n5;
                n5 = n9;
            }
            n9 = n7 * this.width + n8;
            for (int i = n7; i <= n5; ++i) {
                this.thin_pointAtIndex(n9, 0.0f, this.strokeColor);
                n9 += this.width;
            }
            return;
        }
        if (n7 == n5) {
            if (n8 > n6) {
                n9 = n8;
                n8 = n6;
                n6 = n9;
            }
            n9 = n7 * this.width + n8;
            for (int i = n8; i <= n6; ++i) {
                this.thin_pointAtIndex(n9++, 0.0f, this.strokeColor);
            }
            return;
        }
        if (n12 != 0) {
            if (n14 > 0) {
                n14 += n7;
                n9 = 32768 + (n8 << 16);
                while (n7 <= n14) {
                    this.thin_pointAt(n9 >> 16, n7, 0.0f, this.strokeColor);
                    n9 += n16;
                    ++n7;
                }
                return;
            }
            n14 += n7;
            n9 = 32768 + (n8 << 16);
            while (n7 >= n14) {
                this.thin_pointAt(n9 >> 16, n7, 0.0f, this.strokeColor);
                n9 -= n16;
                --n7;
            }
            return;
        }
        if (n14 > 0) {
            n14 += n8;
            n9 = 32768 + (n7 << 16);
            while (n8 <= n14) {
                this.thin_pointAt(n8, n9 >> 16, 0.0f, this.strokeColor);
                n9 += n16;
                ++n8;
            }
            return;
        }
        n14 += n8;
        n9 = 32768 + (n7 << 16);
        while (n8 >= n14) {
            this.thin_pointAt(n8, n9 >> 16, 0.0f, this.strokeColor);
            n9 -= n16;
            --n8;
        }
    }

    private int thin_flat_lineClipCode(float f, float f2) {
        return (f2 < 0.0f ? 8 : 0) | (f2 > (float)this.height1 ? 4 : 0) | (f < 0.0f ? 2 : 0) | (f > (float)this.width1 ? 1 : 0);
    }

    private float thin_flat_lineSlope(float f, float f2, float f3, float f4, int n) {
        switch (n) {
            case 4: {
                return -f2 / (f4 - f2);
            }
            case 3: {
                return ((float)this.height1 - f2) / (f4 - f2);
            }
            case 2: {
                return -f / (f3 - f);
            }
            case 1: {
                return ((float)this.width1 - f) / (f3 - f);
            }
        }
        return -1.0f;
    }

    private boolean flat_line_retribution(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        return false;
    }

    private void thick_flat_line(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.spolygon.interpARGB = f3 != f9 || f4 != f10 || f5 != f11 || f6 != f12;
        this.spolygon.interpZ = false;
        if (!this.spolygon.interpARGB && this.flat_line_retribution(f, f2, f7, f8, f3, f4, f5)) {
            return;
        }
        float f13 = f7 - f + 1.0E-4f;
        float f14 = f8 - f2 + 1.0E-4f;
        float f15 = PGraphics2D.sqrt(f13 * f13 + f14 * f14);
        float f16 = this.strokeWeight / f15;
        float f17 = f16 * f14;
        float f18 = f16 * f13;
        float f19 = f16 * f14;
        float f20 = f16 * f13;
        this.spolygon.reset(4);
        float[] fArray = this.spolygon.vertices[0];
        fArray[0] = f + f17;
        fArray[1] = f2 - f18;
        fArray[3] = f3;
        fArray[4] = f4;
        fArray[5] = f5;
        fArray[6] = f6;
        fArray = this.spolygon.vertices[1];
        fArray[0] = f - f17;
        fArray[1] = f2 + f18;
        fArray[3] = f3;
        fArray[4] = f4;
        fArray[5] = f5;
        fArray[6] = f6;
        fArray = this.spolygon.vertices[2];
        fArray[0] = f7 - f19;
        fArray[1] = f8 + f20;
        fArray[3] = f9;
        fArray[4] = f10;
        fArray[5] = f11;
        fArray[6] = f12;
        fArray = this.spolygon.vertices[3];
        fArray[0] = f7 + f19;
        fArray[1] = f8 - f20;
        fArray[3] = f9;
        fArray[4] = f10;
        fArray[5] = f11;
        fArray[6] = f12;
        this.spolygon.render();
    }

    private void draw_lines(float[][] fArray, int n, int n2, int n3, int n4) {
        if (this.strokeWeight < 2.0f) {
            for (int i = 0; i < n; i += n3) {
                if (n4 != 0 && (i + n2) % n4 == 0) continue;
                float[] fArray2 = fArray[i];
                float[] fArray3 = fArray[i + n2];
                if (this.line == null) {
                    this.line = new PLine(this);
                }
                this.line.reset();
                this.line.setIntensities(fArray2[12], fArray2[13], fArray2[14], fArray2[15], fArray3[12], fArray3[13], fArray3[14], fArray3[15]);
                this.line.setVertices(fArray2[0], fArray2[1], fArray2[2], fArray3[0], fArray3[1], fArray3[2]);
                this.line.draw();
            }
        } else if (this.strokeWeight < 2.0f && !this.strokeChanged) {
            for (int i = 0; i < n; i += n3) {
                if (n4 != 0 && (i + n2) % n4 == 0) continue;
                this.thin_flat_line((int)fArray[i][0], (int)fArray[i][1], (int)fArray[i + n2][0], (int)fArray[i + n2][1]);
            }
        } else {
            for (int i = 0; i < n; i += n3) {
                if (n4 != 0 && (i + n2) % n4 == 0) continue;
                float[] fArray4 = fArray[i];
                float[] fArray5 = fArray[i + n2];
                this.thick_flat_line(fArray4[0], fArray4[1], fArray4[12], fArray4[13], fArray4[14], fArray4[15], fArray5[0], fArray5[1], fArray5[12], fArray5[13], fArray5[14], fArray5[15]);
            }
        }
    }

    private void thin_point(int n, int n2, float f, int n3) {
        if (n < 0 || n > this.width1 || n2 < 0 || n2 > this.height1) {
            return;
        }
        int n4 = n2 * this.width + n;
        if ((n3 & 0xFF000000) == -16777216) {
            this.pixels[n4] = n3;
        } else {
            int n5 = n3 >> 24 & 0xFF;
            int n6 = n5 ^ 0xFF;
            int n7 = this.strokeColor;
            int n8 = this.pixels[n4];
            int n9 = n6 * (n8 >> 16 & 0xFF) + n5 * (n7 >> 16 & 0xFF) & 0xFF00;
            int n10 = n6 * (n8 >> 8 & 0xFF) + n5 * (n7 >> 8 & 0xFF) & 0xFF00;
            int n11 = n6 * (n8 & 0xFF) + n5 * (n7 & 0xFF) >> 8;
            this.pixels[n4] = 0xFF000000 | n9 << 8 | n10 | n11;
        }
        this.zbuffer[n4] = f;
    }

    protected void clear() {
        Arrays.fill(this.pixels, this.backgroundColor);
    }

    private boolean untransformed() {
        return this.m00 == 1.0f && this.m01 == 0.0f && this.m02 == 0.0f && this.m10 == 0.0f && this.m11 == 1.0f && this.m12 == 0.0f;
    }

    private boolean unwarped() {
        return this.m00 == 1.0f && this.m01 == 0.0f && this.m10 == 0.0f && this.m11 == 1.0f;
    }

    private void calc_lighting(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float[] fArray, int n) {
        fArray[n + 0] = f;
        fArray[n + 1] = f2;
        fArray[n + 2] = f3;
    }

    private static final int float_color(float f, float f2, float f3) {
        return 0xFF000000 | (int)(255.0f * f) << 16 | (int)(255.0f * f2) << 8 | (int)(255.0f * f3);
    }

    public static final int _blend(int n, int n2, int n3) {
        n3 = n3 * (n2 >>> 24) >> 8;
        int n4 = n3 ^ 0xFF;
        int n5 = n4 * (n >> 16 & 0xFF) + n3 * (n2 >> 16 & 0xFF) & 0xFF00;
        int n6 = n4 * (n >> 8 & 0xFF) + n3 * (n2 >> 8 & 0xFF) & 0xFF00;
        int n7 = n4 * (n & 0xFF) + n3 * (n2 & 0xFF) >> 8;
        return 0xFF000000 | n5 << 8 | n6 | n7;
    }
}

