/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.fd.runtime;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ApplicationPatch {
    @NonNull
    public final String path;
    @NonNull
    public final byte[] data;

    public ApplicationPatch(@NonNull String path, @NonNull byte[] data) {
        this.path = path;
        this.data = data;
    }

    public String toString() {
        return "ApplicationPatch{path='" + this.path + '\'' + ", data.length='" + this.data.length + '\'' + '}';
    }

    @Nullable
    public static List<ApplicationPatch> read(@NonNull DataInputStream input) throws IOException {
        int changeCount = input.readInt();
        if (Log.isLoggable((String)"fd", (int)4)) {
            Log.i((String)"fd", (String)("Receiving " + changeCount + " changes"));
        }
        ArrayList<ApplicationPatch> changes = new ArrayList<ApplicationPatch>(changeCount);
        for (int i = 0; i < changeCount; ++i) {
            String path = input.readUTF();
            int size = input.readInt();
            byte[] bytes = new byte[size];
            input.readFully(bytes);
            changes.add(new ApplicationPatch(path, bytes));
        }
        return changes;
    }

    @NonNull
    public String getPath() {
        return this.path;
    }

    @NonNull
    public byte[] getBytes() {
        return this.data;
    }
}

