/* ========================================
 *
 * Copyright YOUR COMPANY, THE YEAR
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * CONFIDENTIAL AND PROPRIETARY INFORMATION
 * WHICH IS THE PROPERTY OF your company.
 *
 * ========================================
*/
/*****************************************************************************
* Included headers
*****************************************************************************/

#include <BLE_Process.h>
#include "stdbool.h"
#include <project.h>
#include <MotorControl.h>
#include <main.h>


void StartFastAdvertising();


/*****************************************************************************
* Macros and constants
*****************************************************************************/
#define             REFRESH_INTERVAL                    (1000u)

/* Connection handle used for transmitting information over BLE */
//CYBLE_CONN_HANDLE_T                 connHandle;
CYBLE_CONN_HANDLE_T                 cyBle_connHandle;

/*****************************************************************************
* Static variables 
*****************************************************************************/

/* 'rgbHandle' stores RGB control data parameters */
CYBLE_GATT_HANDLE_VALUE_PAIR_T		RobotMoveHandle;
CYBLE_GATT_HANDLE_VALUE_PAIR_T		RobotACKHandle;
CYBLE_GATT_HANDLE_VALUE_PAIR_T		RobotGOHandle;
CYBLE_GATT_HANDLE_VALUE_PAIR_T      VersionHandle;

/* Connection Parameter update values. This values are used by the BLE component
* to update the connector parameter, including connection interval, to desired 
* value */
static CYBLE_GAP_CONN_UPDATE_PARAM_T ConnectionParam =
{
    CYBLE_GAPP_CONNECTION_INTERVAL_MIN,  		      
    CYBLE_GAPP_CONNECTION_INTERVAL_MAX,		       
    CYBLE_GAPP_CONNECTION_SLAVE_LATENCY,			    
    CYBLE_GAPP_CONNECTION_TIME_OUT 			         	
};

/* Status flag for the Stack Busy state. This flag is used to notify the application 
* whether there is stack buffer free to push more data or not */
volatile uint8 busyStatus = 0;

/* This flag is used by application to know whether a Central 
* device has been connected. This is updated in BLE event callback 
* function*/
uint8 deviceConnected = false;
uint8 Use_Notifications = false;
static uint8 isConnectionUpdateRequested = true;

MoveControl MC_Tempdata; 
uint8 ResetMoveData[3] = {0}; 

/*****************************************************************************
* Public variables 
*****************************************************************************/
bool enterHibernateFlag = false;
uint8 AcknowledgementFlag = false;

/*******************************************************************************
* Function Name: CustomEventHandler
********************************************************************************
* Summary:
* Call back event function to handle various events from BLE stack
*
* Parameters:
*  event:		event returned
*  eventParam:	link to value of the events returned
*
* Return:
*  void
*
*******************************************************************************/
void CustomEventHandler(uint32 event, void * eventParam)
{
    /* Local variable to strore the write request parameters */
	CYBLE_GATTS_WRITE_REQ_PARAM_T *wrReqParam;
    CYBLE_GATTC_READ_RSP_PARAM_T *rRegParam;
    CYBLE_GAP_AUTH_INFO_T *authInfo;
    CYBLE_GAP_SMP_KEY_DIST_T *KEY;
    CYBLE_GATT_ERR_CODE_T gattErr;

    uint8 Tempdata = 0;
 
    switch(event)
    {
        case CYBLE_EVT_STACK_ON:
        	/* Start Advertisement and enter Discoverable mode*/
            // CyBle_GappStartAdvertisement(CYBLE_ADVERTISING_FAST);
            StartFastAdvertising();
			break;
			
        case CYBLE_EVT_TIMEOUT:
            // printf("Time OUT\r\n");
            // UseDeepSleep = true;
        break;
           
        /**********************************************************
        *                       GAP Events
        ***********************************************************/
        case CYBLE_EVT_GAP_DEVICE_DISCONNECTED:
            StartFastAdvertising();
        break;
            
		case CYBLE_EVT_GAPP_ADVERTISEMENT_START_STOP:
			/* Set the BLE state variable to control LED status */
            if(CYBLE_STATE_DISCONNECTED == CyBle_GetState())
            {
                 StartFastAdvertising();
            }
			break;
			
        case CYBLE_EVT_GAP_DEVICE_CONNECTED:
            // printf("Device Connected\r\n");
            /*Req Client to Start Authentication process*/
#ifdef UseBonding    
            CyBle_GapAuthReq(cyBle_connHandle.bdHandle, &cyBle_authInfo); // 2
#endif            
            //CyBle_GappStartAdvertisement(CYBLE_ADVERTISING_FAST);
            break;
            
        case CYBLE_EVT_GAP_AUTH_REQ:
                /*Authentication Request recieved from Master */
//                authInfo=((CYBLE_GAP_AUTH_INFO_T *)eventParam);
                // Timer_SetPrescaler(Timer_PRESCALE_DIVBY2);
            break;
        
        case CYBLE_EVT_GAP_PASSKEY_ENTRY_REQUEST:
                /*Passkey Entry Request*/
            break;

        case CYBLE_EVT_GAP_PASSKEY_DISPLAY_REQUEST:
                /*Passkey Display Request*/
                // Main_DisplayKey(*(uint32 *)eventParam);
                
            break;
        
        case CYBLE_EVT_GAP_KEYINFO_EXCHNGE_CMPLT:
                /*Key Information exchange completed */
                // KEY = (CYBLE_GAP_SMP_KEY_DIST_T *)eventParam;
            break;

        
        case CYBLE_EVT_GAP_ENCRYPT_CHANGE:
                /*Encyrption Change event*/
            break;
        
        case CYBLE_EVT_GAP_AUTH_COMPLETE:
                /*Authentication Completed*/
//                authInfo = (CYBLE_GAP_AUTH_INFO_T *)eventParam;
//                StoreBondingInformation();
            break;

        case CYBLE_EVT_GAP_AUTH_FAILED:
                /*Authentication Failed.Display the error code */
            break;
                
		/**********************************************************
        *                       GATT Events
        ***********************************************************/
        case CYBLE_EVT_GATT_CONNECT_IND:
			/* This flag is used in application to check connection status */
			deviceConnected = true;     // as long as someone is connected we are not allowed to prolong the BLE-Handling intervall for energy saving
            cyBle_connHandle = *(CYBLE_CONN_HANDLE_T *)eventParam;    // 1
			Use_Notifications = true;  

            break;
        
        case CYBLE_EVT_GATT_DISCONNECT_IND:
            /* Update deviceConnected flag*/
			deviceConnected = false;
            /*Device disconnected*/
            cyBle_connHandle.bdHandle=0;
            StartFastAdvertising();
            
            Use_Notifications = false;  // Prevent Notifications if Device is disconnected

			/* Reset the isConnectionUpdateRequested flag to allow sending
			* connection parameter update request in next connection */
			isConnectionUpdateRequested = true;  
            
			break;
        
        case CYBLE_EVT_GATTS_WRITE_CMD_REQ:
                /*Received Writewithout Response command from the Client*/
                wrReqParam =(CYBLE_GATTS_WRITE_REQ_PARAM_T*) eventParam; 
                
                gattErr = CyBle_GattsWriteAttributeValue(&wrReqParam->handleValPair, 0u, 
                        &wrReqParam->connHandle, CYBLE_GATT_DB_PEER_INITIATED);             
            break;    
                
        case CYBLE_EVT_GATTC_READ_MULTI_RSP:
                rRegParam = (CYBLE_GATTC_READ_RSP_PARAM_T *) eventParam;
            break;
    
            
        case CYBLE_EVT_GATTS_WRITE_REQ: 							
            /* This event is received when Central device sends a Write command 
             * on an Attribute. 
             * We first get the attribute handle from the event parameter and 
             * then try to match that handle with an attribute in the database.
             */
            wrReqParam = (CYBLE_GATTS_WRITE_REQ_PARAM_T *) eventParam;
                       
            
            if(wrReqParam->handleValPair.attrHandle == cyBle_customs[ROBOT_SERVICE_INDEX].\
								                        customServiceInfo[RC_MOVECONTROL_INDEX].\
                                                        customServiceCharHandle)
            {
                MC_Tempdata.direction = wrReqParam->handleValPair.value.val[RC_MOVECONTROL_DIRECTION_INDEX];
                MC_Tempdata.distance =  wrReqParam->handleValPair.value.val[RC_MOVECONTROL_DISTANCE_INDEX];
                MC_Tempdata.ledcolor = wrReqParam->handleValPair.value.val[RC_MOVECONTROL_COLOR_INDEX];
                MC_Update_MoveControl_Data(&MC_Tempdata);
                
                RobotMoveHandle.attrHandle = RC_MOVECONTROL_HANDLE;
	            RobotMoveHandle.value.val = wrReqParam->handleValPair.value.val;
	            RobotMoveHandle.value.len = sizeof(MC_Tempdata);
	            RobotMoveHandle.value.actualLen = sizeof(MC_Tempdata);
            	/* Send updated Animation-Control handle as attribute for read by central device */
            	CyBle_GattsWriteAttributeValue(&RobotMoveHandle, false, &cyBle_connHandle, false);  
                
                // Change the notification-Characteristic.
                MC_SendNotification();                
            }
            
            
                      
            if(wrReqParam->handleValPair.attrHandle == cyBle_customs[ROBOT_SERVICE_INDEX].\
								                        customServiceInfo[RC_MOVEGO_INDEX].\
                                                        customServiceCharHandle)
            {
                Tempdata = wrReqParam->handleValPair.value.val[RC_MOVEGO_GO_INDEX];
                MC_Update_Govalue( Tempdata );
                
                RobotGOHandle.attrHandle = RC_MOVEGO_HANDLE;
	            RobotGOHandle.value.val = wrReqParam->handleValPair.value.val;
	            RobotGOHandle.value.len = sizeof(Tempdata);
	            RobotGOHandle.value.actualLen = sizeof(Tempdata);
            	/* Send updated Animation-Control handle as attribute for read by central device */
            	CyBle_GattsWriteAttributeValue(&RobotGOHandle, false, &cyBle_connHandle, false);  
                
                // Change the notification-Characteristic.
                MC_SendNotification();         
            }                    
           
            
			/* Send the response to the write request received. */
			CyBle_GattsWriteRsp(cyBle_connHandle);
			
			break;

        case CYBLE_EVT_L2CAP_CONN_PARAM_UPDATE_RSP:
				/* If L2CAP connection parameter update response received, reset application flag */
            	isConnectionUpdateRequested = false;
            break;
			
		case CYBLE_EVT_STACK_BUSY_STATUS:
			/* This event is generated when the internal stack buffer is full and no more
			* data can be accepted or the stack has buffer available and can accept data.
			* This event is used by application to prevent pushing lot of data to stack. */
			
			/* Extract the present stack status */
            busyStatus = * (uint8*)eventParam;
            break;    
            
        default:

       	 	break;
    }
}


// Restore the high Interrupt for Connection or advertising.
void StartFastAdvertising()
{
    CyBle_GappStartAdvertisement(CYBLE_ADVERTISING_FAST);
}

void BLE_ResetGoCharacteristic()
{
    RobotGOHandle.attrHandle = RC_MOVEGO_HANDLE;
    RobotGOHandle.value.val = 0;
    RobotGOHandle.value.len = sizeof(uint8);
    RobotGOHandle.value.actualLen = sizeof(uint8);
	/* Send updated Animation-Control handle as attribute for read by central device */
	CyBle_GattsWriteAttributeValue(&RobotGOHandle, false, &cyBle_connHandle, false);     
       
    RobotMoveHandle.attrHandle = RC_MOVECONTROL_HANDLE;
    RobotMoveHandle.value.val = (uint8 *)ResetMoveData;
    RobotMoveHandle.value.len = sizeof(ResetMoveData);
    RobotMoveHandle.value.actualLen = sizeof(ResetMoveData);
    /* Send updated Animation-Control handle as attribute for read by central device */
    CyBle_GattsWriteAttributeValue(&RobotMoveHandle, false, &cyBle_connHandle, false);     
}

void BLE_WriteMovementReceivedNotification(volatile uint8 *FlagValue)
{
    /* If stack is not busy, then send the notification */
    // busyStatus = CyBle_GattGetBusyStatus();
    // StackStatus = CyBle_GetState();
    
    if( (CYBLE_STACK_STATE_FREE == CyBle_GattGetBusyStatus() ) & (CYBLE_STATE_CONNECTED == CyBle_GetState() ) )
	{        
        RobotACKHandle.attrHandle = RC_MOVEACK_HANDLE;
        RobotACKHandle.value.val = (uint8 *)(FlagValue);
        RobotACKHandle.value.len  = sizeof(uint8);
        RobotACKHandle.value.actualLen = sizeof(uint8);
        
        // Write the value to the stack.
        CyBle_GattsWriteAttributeValue(&RobotACKHandle, false, &cyBle_connHandle, false);  
        
        // Trigger the notification to the client.
        CyBle_GattsNotification(cyBle_connHandle,(CYBLE_GATTS_HANDLE_VALUE_NTF_T*)&RobotACKHandle);        
    }
}



/*******************************************************************************
* Function Name: UpdateConnectionParam
********************************************************************************
* Summary:
*        Send the Connection Update Request to Client device after connection 
* and modify theconnection interval for low power operation.
*
* Parameters:
*	void
*
* Return:
*  void
*
*******************************************************************************/
void UpdateConnectionParam(void)
{
	/* If device is connected and Update connection parameter not updated yet,
	* then send the Connection Parameter Update request to Client. */
    if(deviceConnected && isConnectionUpdateRequested)
	{
		/* Reset the flag to indicate that connection Update request has been sent */
		isConnectionUpdateRequested = false;
		
		/* Send Connection Update request with set Parameter */
		CyBle_L2capLeConnectionParamUpdateRequest(cyBle_connHandle.bdHandle, &ConnectionParam);
	}
}


/*******************************************************************************
* Function Name: 
********************************************************************************
* Summary:
*
*
* Parameters:
*  void
*
* Return:
*  void
*
*******************************************************************************/
void BLE_SetVersionData()
{
    uint8 versionstring[] = {"Version: " __DATE__ " " __TIME__ "\n"};
    VersionHandle.attrHandle = CYBLE_SW_VERSION_VERSION_STRING_CHAR_HANDLE;
    VersionHandle.value.val = versionstring;
    VersionHandle.value.len = sizeof(versionstring);
    VersionHandle.value.actualLen = sizeof(versionstring);
    CyBle_GattsWriteAttributeValue(&VersionHandle, false, &cyBle_connHandle, false);
}

/* [] END OF FILE */
