/* ========================================
 *
 * Copyright YOUR COMPANY, THE YEAR
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * CONFIDENTIAL AND PROPRIETARY INFORMATION
 * WHICH IS THE PROPERTY OF your company.
 *
 * ========================================
*/

/* ========================================
 *  Includes
 * ======================================== */
#include <project.h>
#include <MotorControl.h>
#include <BLE_Process.h>
#include "stdbool.h"
#include <main.h>


/* ========================================
 * Local Function Prototypes
 * ======================================== */
void mc_ClearMovementArray();
void mc_Start_Movement();
void mc_Stop_Movement();
void mc_Perform_Movement();
void mc_Test_FillMovementTable();
void mc_Activate_LED();
void mv_Clear_LED();

void mc_Forward();
void mc_Backward();
void mc_Turn_Left();
void mc_Turn_Right();
void mc_Stop();

/* ========================================
 *  global variables and defines
 * ======================================== */
#define MC_Right_Forward()      A1_Write(1)
#define MC_Right_Backward()     A2_Write(1)
#define MC_Right_Stop()         { A1_Write(0); A2_Write(0); }

#define MC_Left_Forward()       B2_Write(1) 
#define MC_Left_Backward()      B1_Write(1)
#define MC_Left_Stop()          { B1_Write(0); B2_Write(0); }

#define MOVEMENTARRAYMAX        200
#define UmschaltungsTotzeit     100


MoveControl MoveDataArray[MOVEMENTARRAYMAX+1] = { {0xff,0xff,0} };
volatile uint8 MoveDataArray_WritePointer = 0;
volatile uint8 MoveDataArray_ReadPointer = 0;
volatile uint8 DistanceCounter = 0;
uint8 MoveDataArray_Max_Animation_Pointer = 0;

volatile bool Move = false;

volatile bool SendNotification = false; 
volatile bool NewMovement = true; 

uint8 NotificationFlag = false;


/* ========================================
 * Public Functions 
 * ======================================== */
void MC_Reply_Notification() 
{
    if(SendNotification == true)
    {
        SendNotification = false;
        BLE_WriteMovementReceivedNotification(&MoveDataArray_WritePointer);           
    }
}


void MC_Update_MoveControl_Data( MoveControl *NextMovement )
{
    if(Move == false)
    {
        // Save the NextMovement into the local array
        MoveDataArray[MoveDataArray_WritePointer].direction = NextMovement->direction;
        MoveDataArray[MoveDataArray_WritePointer].distance = NextMovement->distance;
        MoveDataArray[MoveDataArray_WritePointer].ledcolor = NextMovement->ledcolor;
        MoveDataArray_WritePointer++;
    }
    else
    {
        // While we are moving, we don't accept new orders  
    }
}

void MC_Update_Govalue( uint8 GoValue)
{
    if(GoValue == true)
    {
        mc_Start_Movement();
    }
    else
    {
        mv_Clear_LED();
        mc_Stop_Movement();
    }   
}


void MC_Perform_Movement()
{
    if(Move == true)
    {
        mc_Perform_Movement();        
    }
    else
    {        
        // while the Movement is not enabled, do nothing.
        // mc_Stop();
    }
}

void MC_ClearMovement_Array()
{
    mc_ClearMovementArray();
    mc_Stop();
}

void MC_SendNotification()
{
    SendNotification = true;
}



void mc_Perform_Movement()
{
    if(NewMovement) 
    {
        // We are really switching to another movement
        mc_Stop();
        
        CyDelay(UmschaltungsTotzeit); // Dead-Time um kurzschlüsse zu vermeiden.  Reicht offenbar aber nicht aus...
        NewMovement = false;
        mc_Activate_LED();
        // to cope for the cyDelay(UmschaltTotzeit)
        switch(MoveDataArray[MoveDataArray_ReadPointer].direction)
        {
            case forward:
                mc_Forward();
            break;
            
            case left:
                mc_Turn_Left();
            break;
            
            case backward:
                mc_Backward();
            break;
            
            case right:
                mc_Turn_Right();
            break;
                
            case standstill:
                mc_Stop();
            break;    
            
            case stop:
                // We reached the end of the programmed movement.
                mc_Stop_Movement();   
                return;
                // Blue_Write(0);
            break;
                
            default:
                mc_Stop();
            break;
        }    
    }
   
    // we are keeping the Movement, just increment the counter.
    DistanceCounter++;
    
    if(DistanceCounter >= MoveDataArray[MoveDataArray_ReadPointer].distance)
    {
        DistanceCounter = 0;
        MoveDataArray_ReadPointer++;  
        NewMovement = true;
    }
}


void mc_Forward()
{
    MC_Left_Forward();    
    CyDelay(10);
    MC_Right_Forward();
    
}

void mc_Backward()
{
    MC_Right_Backward();
    CyDelay(10);
    MC_Left_Backward();
}

void mc_Turn_Left()
{
    MC_Left_Backward();
    CyDelay(10);
    MC_Right_Forward();
}

void mc_Turn_Right()
{
    MC_Left_Forward();
    CyDelay(10);
    MC_Right_Backward();
}

void mc_Stop()
{
    MC_Left_Stop();
    CyDelay(10);
    MC_Right_Stop();
}


/* ========================================
 *  Local Functions
 * ======================================== */

void mc_Activate_LED()
{
    mv_Clear_LED();
    if(MoveDataArray[MoveDataArray_ReadPointer].ledcolor & redledflag) Red_Write(0);
    if(MoveDataArray[MoveDataArray_ReadPointer].ledcolor & greenledflag) Green_Write(0);
    if(MoveDataArray[MoveDataArray_ReadPointer].ledcolor & blueledflag) Blue_Write(0);
}

void mv_Clear_LED()
{
    Red_Write(1);
    Green_Write(1);
    Blue_Write(1);
}

void mc_Start_Movement() 
{
    if(MoveDataArray_WritePointer > 0)
    {
        MoveDataArray_Max_Animation_Pointer = MoveDataArray_WritePointer;
        MoveDataArray_WritePointer = 0;
        MoveDataArray_ReadPointer = 0;
        Move = true;
    }
    else
    {
        // Kein Movement gespeichert
        // Red_Write(0);
    }   
}

void mc_Stop_Movement() 
{
    mc_Stop();
    mv_Clear_LED();
    MoveDataArray_ReadPointer = 0;
    Move = false;
    NewMovement = true;
    mc_ClearMovementArray();
    BLE_ResetGoCharacteristic();
    // Green_Write(1);
}



void mc_ClearMovementArray()
{
    uint8 i = 0;
    for(i=0;i<MOVEMENTARRAYMAX; i++ )
    {
        MoveDataArray[i].direction = stop;
        MoveDataArray[i].distance = 0;
        MoveDataArray[i].ledcolor = 0;
    }    
}

/* [] END OF FILE */