/* ========================================
 *
 * Copyright YOUR COMPANY, THE YEAR
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * CONFIDENTIAL AND PROPRIETARY INFORMATION
 * WHICH IS THE PROPERTY OF your company.
 *
 * ========================================
*/
#include <project.h>
#include <MotorControl.h>
#include <BLE_Process.h>
#include <main.h>

void INIT();
void InitWatchdog();
CY_ISR_PROTO(isr_WDT);
void blink();
void GotoLowPowerMode(uint8 lpmSel);

/*  Defines   */
#define ACTIVE      (0u)
#define SLEEP       (1u)
#define DEEPSLEEP   (2u)

/*  Local Variables  */ 
volatile uint8 WatchdogCounter = 0;

uint16 VoltA = 0;
uint16 VoltB = 0;

bool ChargeActive = false;
volatile bool MakeAMove = false;

int main()
{   
    CyGlobalIntEnable; /* Enable global interrupts. */

    /* Place your initialization/startup code here (e.g. MyInst_Start()) */
    INIT();
    
        // this is the normal usage mode: Just perform the movement.
        for(;;)
        {
            WatchdogCounter = 0;
            if(MakeAMove) {
                MakeAMove = false;
                MC_Perform_Movement();                
            }
            CyBle_ProcessEvents();
            MC_Reply_Notification();
            GotoLowPowerMode(DEEPSLEEP);
        }
}


void INIT()
{
    blink();

    CyGlobalIntEnable; // enable global interrupts
    
    // Initialize the movement-Array to 0xff
    MC_ClearMovement_Array();
    
    /* initialize watchdog */
    InitWatchdog();
    
    /* connect ISR routine to Watchdog interrupt */
    ISR_WDT_StartEx(isr_WDT);
    
      
	/* Start BLE component and register the CustomEventHandler function. This 
	 * function exposes the events from BLE component for application use */
    CyBle_Start(CustomEventHandler);	    
    CyDelay(10);
    
    BLE_SetVersionData();  
}

CY_ISR(isr_WDT)
{
    uint32 InterruptSource = CySysWdtGetInterruptSource();
    
    /* clear interrupt flag to enable next interrupt */
    CySysWdtClearInterrupt(InterruptSource);     
    
    switch(InterruptSource)
    {
        case CY_SYS_WDT_COUNTER0_INT:   // 50ms
            // This one is to wake up for Handle BLE Events  
            break;
           
        case CY_SYS_WDT_COUNTER1_INT:   // 1s
            MakeAMove = true;
            WatchdogCounter++;
            if(WatchdogCounter>5) {
                CySoftwareReset();
            }
            break;
            
        default:
            break;
    }
}

void blink()
{
    uint8 i =0;
    for(i=0;i<4;i++)
    {
        Red_Write(0);
        CyDelay(50);
        Red_Write(1);
        CyDelay(50);
    }    
}

// Just set the Clear on Match to both Watchdog-Counters
void InitWatchdog()
{
    // basic function is defined in clock-tab of cydwr
  
	CySysWdtWriteClearOnMatch(CY_SYS_WDT_COUNTER0, 1u);
    CySysWdtWriteClearOnMatch(CY_SYS_WDT_COUNTER1, 1u);
    CyDelay(3); // Just to make sure the settings come in effect
}

void GotoLowPowerMode(uint8 lpmSel)
{
        /* Local variable to store the status of BLESS Hardware block */
		CYBLE_LP_MODE_T sleepMode;
		CYBLE_BLESS_STATE_T blessState;

        if (lpmSel == DEEPSLEEP)
        { 
            // DeepSleepWakeUpISR_Enable();
            /* Leave chip in Deep Sleep mode */
    		/* Put BLESS into Deep Sleep and check the return status */
    		sleepMode = CyBle_EnterLPM(CYBLE_BLESS_DEEPSLEEP);
    		
            /* Disable global interrupt to prevent changes from any other interrupt ISR */
            CyGlobalIntDisable;
            
    		/* Check the Status of BLESS */
    		blessState = CyBle_GetBleSsState();
            
            
    		if(sleepMode == CYBLE_BLESS_DEEPSLEEP)
    		{
    		    /* If the ECO has started or the BLESS can go to Deep Sleep, then place CPU 
    			* to Deep Sleep */
    			if(blessState == CYBLE_BLESS_STATE_ECO_ON || blessState == CYBLE_BLESS_STATE_DEEPSLEEP)
    		    {
    				/* Place CPU to Deep sleep */
                    CySysPmDeepSleep();
    		 	}
    		}      
            /* Re-enable global interrupt mask after wakeup */
    		CyGlobalIntEnable; 
        }        
        else if (lpmSel == SLEEP)
        {
            /* Leave chip in Sleep mode */
            /* Leave chip in Deep Sleep mode */
    		/* Put BLESS into Deep Sleep and check the return status */
    		sleepMode = CyBle_EnterLPM(CYBLE_BLESS_SLEEP);
    		
    		/* Disable global interrupt to prevent changes from any other interrupt ISR */
    		CyGlobalIntDisable;
    	
    		/* Check the Status of BLESS */
    		blessState = CyBle_GetBleSsState();

    		if(sleepMode == CYBLE_BLESS_SLEEP)
    		{
    		    if(blessState != CYBLE_BLESS_STATE_EVENT_CLOSE)
    		    {
    				/* If BLE Event has not 
    				* closed yet, then place CPU to Sleep */
                    // I2C_Sleep();
                        
                        CySysPmSleep();
                    
                    // I2C_Wakeup();
    		    }
    		}
    		
    		/* Re-enable global interrupt mask after wakeup */
    		CyGlobalIntEnable;        
        }
        else if (lpmSel == ACTIVE)
        {
            // stay active
        }	
}
/* [] END OF FILE */
