﻿/*=========================================================================
   This file is part of the Cardboard Robot SDK.
   
   Copyright (C) 2012 Ken Ihara.
  
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
=========================================================================*/

namespace CBRobot {
    
    /** Enumerates the supported coordinate systems.  Currently, DOF is the
     *  only coordinate system supported by the Cardboard Robot SDK.
     */
    public enum CoordinateSystem {

        /** Unknown coordinate system */
        Unknown = 0,

        /** The DOF (Degree of freedom) coordinate system.  In this coordinate
         *  system, vectors are specified using the rotation of each motor.
         */
        Dof,

        // (Cartesian, etc. not yet supported)
    }
}
