;************************************************************************
;*												*
;*	Crazy looper by Brian McNamara						*
;*	V 1.0  13/11/2009 First release Beta					*
;*	V 1.1	 13/02/2010 Add tempo control and comment				*
;*	V 1.21 18/06/2010	Change tempo control for better control		*
'************************************************************************	



;------- Constants -------

;------- Switches --------
symbol Sw_Write	=	pin3	;write switch

;------- Variables -------
symbol Tempo	=	b0 
symbol ADCFreq	=	b2
symbol i		=	b3
symbol DelayLoop	=	b4
symbol MemPos	=	b5 
symbol DrumType	=	b6
symbol MemFreq	=	b7

Setup:
	setfreq m8
 
;------------------------------- Main ----------------------------------------------------
Main:
							
readadc 2,Tempo					;read tempo contol
tempo = tempo /6					;don't want to go too slow do we

low 4							;LED on

for MemPos = 80 to 127				; free memory spots for the picaxe 08m

    
	if SW_Write = 0 then 			;check to see if the write switch has been pressed
		readadc 1,ADCFreq				;read the freq pot value 0 to 255
		poke MemPos,ADCFreq		;write freq pot value if it has
	endif
	      
	peek MemPos,MemFreq			;read the freq from memory
	sound 0,(MemFreq,1); Make a sound
 	sound 0,(MemFreq,1); Make a sound
	sound 0,(MemFreq,1); Make a sound
	 
	for i = 1 to Tempo			;delay loop			
	next i
	
	
next MemPos	
high 4						;tempo LED off
	
goto Main
;-----------------------------------------------------------------------------------------

 
 


