#include <AFMotor.h>

#include "WProgram.h"
void setup();
void loop();
void readInteruptors();
void runMotors();
void stateChange();
int pinLDR = 5;
int pinLDRpwr=26;
int digitalLDRpin=18;
int sensorPin=7;
int limitSwitch1[2];
int limitSwitch2[2];
int limitSwitch1PwrPIN=28;
int limitSwitch2PwrPIN=30;
int incomingByte[128];
int numBytes = 0;
int motorSpeed=0;

AF_DCMotor motorGrabber(1);
AF_DCMotor motorX(3);
AF_DCMotor motorY(4);


volatile int state = LOW;

void setup() {
  attachInterrupt(pinLDR, stateChange, FALLING);

  int i = 0;

  limitSwitch1[0] = 36;
  limitSwitch1[1] = 38;
  limitSwitch2[0] = 40;
  limitSwitch2[1] = 42;
  //Set pin modes
  for (i = 0; i < 2; i++){
    pinMode(limitSwitch1[i], INPUT);
    pinMode(limitSwitch2[i], INPUT);
  }
  pinMode(limitSwitch1PwrPIN,OUTPUT);
  digitalWrite(limitSwitch1PwrPIN,HIGH);
  pinMode(limitSwitch2PwrPIN,OUTPUT);
  digitalWrite(limitSwitch2PwrPIN,HIGH);

  for (i = 0; i < 3; i++){
    incomingByte[i]=6;
  }

  motorGrabber.setSpeed(255);
  motorGrabber.run(RELEASE);
  motorX.setSpeed(255);
  motorX.run(RELEASE);
  motorY.setSpeed(255);
  motorY.run(RELEASE);

  Serial.begin(9600);
} 




void loop() {
  int i = 0;
  byte inByte = 255;
  
  while(inByte != 0) {
    inByte = Serial.read();
    readInteruptors();
  }
  
  if (inByte == 0){
    while(Serial.available() < 3) {
      ;
    }
    //Read all the data in the buffer
    for(i = 0; i < 3; i++){
      incomingByte[i] = Serial.read();
    }
    //Serial.print(" incomingByte[1]=");  
    //Serial.print(incomingByte[1]);    
    Serial.flush();
  }
  runMotors();
  //delay(50);  
}

void readInteruptors()
{
  if((incomingByte[0]<6 && digitalRead(limitSwitch1[0])==LOW) || (incomingByte[0]>6 && digitalRead(limitSwitch1[1])==LOW)){
    incomingByte[0]=6;
    motorX.run(RELEASE);
  }

  if((incomingByte[1]<6 && digitalRead(limitSwitch2[0])==LOW) || (incomingByte[1]>6 && digitalRead(limitSwitch2[1])==LOW)){
    incomingByte[1]=6;
    motorY.run(RELEASE);
  }

}

void runMotors()
{
  /*
  Serial.print("Limit switch 1[0]: "); 
   Serial.println(digitalRead(limitSwitch1[0]));
   Serial.print("Limit switch 1[1]: "); 
   Serial.println(digitalRead(limitSwitch1[1]));
   Serial.print("Limit switch 2[0]: "); 
   Serial.println(digitalRead(limitSwitch2[0]));
   Serial.print("Limit switch 2[1]: "); 
   Serial.println(digitalRead(limitSwitch2[1]));
   Serial.println("==========================");
   */
  if(incomingByte[0]<6 && digitalRead(limitSwitch1[0])==HIGH){
    motorSpeed = map(incomingByte[0], 5, 1, 0, 255);
    motorX.run(BACKWARD);
    motorX.setSpeed(motorSpeed);
  }
  else if(incomingByte[0]>6 && digitalRead(limitSwitch1[1])==HIGH){
    motorSpeed = map(incomingByte[0], 7, 12, 0, 255);
    motorX.run(FORWARD);
    motorX.setSpeed(motorSpeed);
  }
  else{
    incomingByte[0]=6;
    motorX.run(RELEASE);
  }

  if(incomingByte[1]<6 && digitalRead(limitSwitch2[0])==HIGH){
    motorSpeed = map(incomingByte[1], 5, 1, 0, 255);
    motorY.run(BACKWARD);
    motorY.setSpeed(motorSpeed);
  }
  else if(incomingByte[1]>6 && digitalRead(limitSwitch2[1])==HIGH){
    motorSpeed = map(incomingByte[1], 7, 12, 0, 255);
    motorY.run(FORWARD);
    motorY.setSpeed(motorSpeed);
  }
  else{
    incomingByte[1]=6;
    motorY.run(RELEASE);
  }
  
  if(incomingByte[2]<6){
   motorSpeed = map(incomingByte[2], 5, 1, 0, 255);
   motorGrabber.run(BACKWARD);
   motorGrabber.setSpeed(motorSpeed);
   }
   else if(incomingByte[2]>6){
   motorSpeed = map(incomingByte[2], 7, 12, 0, 255);
   motorGrabber.run(FORWARD);
   motorGrabber.setSpeed(motorSpeed);
   }
   else{
   incomingByte[2]=6;
   motorGrabber.run(RELEASE);
   }
}



void stateChange()
{
  Serial.println("WIN");
  Serial.flush();
}








int main(void)
{
	init();

	setup();
    
	for (;;)
		loop();
        
	return 0;
}

