#ifndef cm_bitmaps_h
#define cm_bitmaps_h

#include "Arduino.h"

#define PIN_FONA_RX       0
#define PIN_FONA_TX       1 
#define PIN_FONA_RST      2
#define PIN_FONA_RING     3 
//#define PIN_FONA_POWER_STATUS    
//#define PIN_FONA_KEY      
//#define PIN_FONA_NETWORK_STATUS
#define PIN_OLED_RST      8 
#define PIN_OLED_DC       9
#define PIN_OLED_CS       10
#define PIN_ENCODER_B     14
#define PIN_ENCODER_A     15
//#define PIN_SD_CD         16
//#define PIN_SD_CS         17
#define PIN_ENCODER_BUTTON 20
#define PIN_BUTTON_RED     21
#define PIN_BUTTON_BLUE    22
// SCL pin  19 // harware SPI pins dont need to be defined
// SDA pin  18
// SCK pin  13
// MISO pin 12
// MOSI pin 11
// CS pin   10
#define MODE_DISPLAY_LOCK 0 
#define MODE_DISPLAY_SELECT_MODE 1
#define MODE_SELECT_TIME_SETTING 2
#define MODE_SET_TIME_MODE 3
#define MODE_SET_TIME_HOUR 4
#define MODE_SET_TIME_MINUTE 5
#define MODE_SET_TIME_MONTH 6
#define MODE_SET_TIME_DAY 7 
#define MODE_SET_TIME_YEAR 8
#define MODE_COM_DIAL 9
#define MODE_COM_INCOMING 10
#define MODE_COM_OUTGOING 11
#define MODE_COM_ACTIVE 12
#define MODE_COM_ENDED 13
#define MODE_SELECT_SYS_SETTING 14
#define MODE_SET_SYS_VIBE 15
#define MODE_SET_SYS_CHIME 16
#define MODE_SET_SYS_VOLUME 17
#define MODE_SET_SYS_UI_COLOR 18
#define BUFFPIXEL 60
#define BLACK           0x0000
#define BLUE            0x001F
#define RED             0xF800
#define GREEN           0x07E0
#define CYAN            0x07FF
#define MAGENTA         0xF81F
#define YELLOW          0xFFE0  
#define WHITE           0xFFFF

#define SYS_ADDRESS_UI_COLOR      0
#define SYS_ADDRESS_VIBE_SETTING  1
#define SYS_ADDRESS_SOUND_SETTING 2
#define SYS_ADDRESS_VOLUME_LEVEL  3
#define SYS_ADDRESS_CLOCK_MODE    4

#define COM_STATUS_READY   0
#define COM_STATUS_ERROR   1
#define COM_STATUS_UNKNOWN 2
#define COM_STATUS_RINGING 3
#define COM_STATUS_ACTIVE  4

#define SYS_READ  0
#define SYS_WRITE 1
#define SYS_ON    1
#define SYS_OFF   0

// RINGTONES
// max val is 19; // 1 is default quick chime// 2 is medieval  horn low // 3 is upbeat//  4 is down chime // 5 is constant beep pulse// 6 is error
// 7 is error // 8 is upbeat mysterious tone!! 9 is melody sad horn// 10 is upbeat 80's ish chimes //11 is quiet neutral long melody// 12 is low beepy kids melody
//13 is flute pattern // 14 is repeat happier flute tone// 15 is digital arab flute pattern // 16 is bad things happenin pattern// 17 is happy birthday// 18 is rising fallling digital horns
//19 is longer chime melody pattern

const unsigned char cmbat1 [] = {
0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xF8, 0x7F, 0xFF, 0xFF, 0xF8, 0x60, 0x00, 0x00, 0x18,
0x6F, 0x3C, 0xF3, 0xD8, 0x6F, 0x3C, 0xF3, 0xDE, 0x6F, 0x3C, 0xF3, 0xCE, 0x6F, 0x3C, 0xF3, 0xCE,
0x6F, 0x3C, 0xF3, 0xCE, 0x6F, 0x3C, 0xF3, 0xCE, 0x6F, 0x3C, 0xF3, 0xDE, 0x6F, 0x3C, 0xF3, 0xD8,
0x60, 0x00, 0x00, 0x18, 0x7F, 0xFF, 0xFF, 0xF8, 0x7F, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00
};

const unsigned char cmbat2 [] = {
0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xF8, 0x7F, 0xFF, 0xFF, 0xF8, 0x60, 0x00, 0x00, 0x18,
0x6F, 0x3C, 0xF0, 0x18, 0x6F, 0x3C, 0xF0, 0x1E, 0x6F, 0x3C, 0xF0, 0x0E, 0x6F, 0x3C, 0xF0, 0x0E,
0x6F, 0x3C, 0xF0, 0x0E, 0x6F, 0x3C, 0xF0, 0x0E, 0x6F, 0x3C, 0xF0, 0x1E, 0x6F, 0x3C, 0xF0, 0x18,
0x60, 0x00, 0x00, 0x18, 0x7F, 0xFF, 0xFF, 0xF8, 0x7F, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00
};

const unsigned char cmbat3 [] = {
0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xF8, 0x7F, 0xFF, 0xFF, 0xF8, 0x60, 0x00, 0x00, 0x18,
0x6F, 0x3C, 0x00, 0x18, 0x6F, 0x3C, 0x00, 0x1E, 0x6F, 0x3C, 0x00, 0x0E, 0x6F, 0x3C, 0x00, 0x0E,
0x6F, 0x3C, 0x00, 0x0E, 0x6F, 0x3C, 0x00, 0x0E, 0x6F, 0x3C, 0x00, 0x1E, 0x6F, 0x3C, 0x00, 0x18,
0x60, 0x00, 0x00, 0x18, 0x7F, 0xFF, 0xFF, 0xF8, 0x7F, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00
};

const unsigned char cmbat4 [] = {
0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xF8, 0x7F, 0xFF, 0xFF, 0xF8, 0x60, 0x00, 0x00, 0x18,
0x6F, 0x00, 0x00, 0x18, 0x6F, 0x00, 0x00, 0x1E, 0x6F, 0x00, 0x00, 0x0E, 0x6F, 0x00, 0x00, 0x0E,
0x6F, 0x00, 0x00, 0x0E, 0x6F, 0x00, 0x00, 0x0E, 0x6F, 0x00, 0x00, 0x1E, 0x6F, 0x00, 0x00, 0x18,
0x60, 0x00, 0x00, 0x18, 0x7F, 0xFF, 0xFF, 0xF8, 0x7F, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00
};

const unsigned char cmbat5 [] = {
0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xF8, 0x7F, 0xFF, 0xFF, 0xF8, 0x60, 0x00, 0x00, 0x18,
0x60, 0x00, 0x00, 0x18, 0x60, 0x00, 0x00, 0x1E, 0x60, 0x00, 0x00, 0x0E, 0x60, 0x00, 0x00, 0x0E,
0x60, 0x00, 0x00, 0x0E, 0x60, 0x00, 0x00, 0x0E, 0x60, 0x00, 0x00, 0x1E, 0x60, 0x00, 0x00, 0x18,
0x60, 0x00, 0x00, 0x18, 0x7F, 0xFF, 0xFF, 0xF8, 0x7F, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00
};

const unsigned char cmsigsym [] = {
0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x7F, 0xFE, 0x7F, 0xFE, 0x19, 0x98, 0x19, 0x98, 0x07, 0xE0, 0x07, 0xE0, 0x01, 0x80,
0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x00, 0x00
};

const unsigned char cmsig1 [] = {
0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66,
0x06, 0x66, 0x06, 0x66, 0x06, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00
};

const unsigned char cmsig2 [] = {
0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60,
0x06, 0x60, 0x06, 0x60, 0x06, 0x60, 0x66, 0x60, 0x66, 0x60, 0x66, 0x60, 0x66, 0x60, 0x00, 0x00
};
const unsigned char cmsig3 [] = {
0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x00, 0x00
};

const unsigned char cmsig4 [] = {
0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0x00, 0x00
};

const unsigned char cmsig5 [] = {
0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const unsigned char cmlogo [] = {
0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x03, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x07, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00,
0x1E, 0x33, 0xC1, 0xDC, 0xE1, 0xDC, 0xE3, 0x9C, 0x3B, 0x8E, 0x1F, 0x0E, 0xE7, 0xE3, 0xC1, 0xD0,
0x1E, 0x06, 0x71, 0xFF, 0xE1, 0xFF, 0xE3, 0x9C, 0x3F, 0x8E, 0x73, 0x3D, 0xE3, 0x8E, 0x71, 0xF8,
0x1C, 0x0E, 0x73, 0x9C, 0xE3, 0x9C, 0xE7, 0x38, 0x73, 0x9C, 0x73, 0x39, 0xC7, 0x0E, 0x73, 0x90,
0x3C, 0x1C, 0xF3, 0x9C, 0xE3, 0x9C, 0xE7, 0x38, 0x73, 0x9C, 0xE0, 0x79, 0xC7, 0x1C, 0xF3, 0x80,
0x1C, 0x0C, 0xE7, 0x39, 0xC7, 0x39, 0xCE, 0x70, 0xE7, 0x38, 0x60, 0x33, 0x8E, 0x0C, 0xE7, 0x00,
0x1F, 0xC7, 0x87, 0x39, 0xE7, 0x39, 0xE7, 0x78, 0xE7, 0x9E, 0x7E, 0x39, 0xE7, 0xC7, 0x87, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};


#endif
