// Works with Arduino 1.6.5. Generic 115200. To enter program mode connect gpio0 to gnd and press reset to gnd shortly.
#include <ESP8266WiFi.h>
#include <OneWire.h>
#include <EEPROM.h>

String apiKey = "AO8NKC3VIIAX83YF";
const char* ssid = "LU_ASI";//"LU_ASI"; "LMT-89B0"
const char* password = "photoplethysmography";// "photoplethysmography"; "331M372E70J"
const char* server = "api.thingspeak.com"; //"api.thingspeak.com";

WiFiClient client;

OneWire  ds(2);  // on pin gpio2 (a 4.7K pullup resistor is necessary to read DS18B20)

/* -------------- Setup ------------------ */
void setup() {
  
  Serial.begin(115200);
  delay(2000);
  Serial.println();
  Serial.println();  
  ESP8266_Init();
  EEPROM.begin(512);
}

/* ------------- Loop -------------------- */
uint32_t last_time = 0;
void loop() {

  if((millis() - last_time) >= 20000) {
    float val = ReadTemperature();
    if (val==0) return;
    last_time = millis();
    Send_Temperature(val);
    Serial.println(" °\r\nWaiting...");
    int addr = 0;
    //int valu = 99;
//EEPROM.write(addr, valu);
//EEPROM.commit();
//int valu=EEPROM.read(addr);
//Serial.print("EEPROM value: ");    
//Serial.print(valu);    
   
  }
}

/* --------------- Functions -------------------- */

void ESP8266_Init(){
  Serial.println("Putting WiFi into station mode...\r\n");
  WiFi.mode(WIFI_STA);
  
  Serial.print("Connecting to: \"");
  Serial.print(ssid);
  Serial.print("\",\"");
  Serial.print(password);
  Serial.println("\"...");
  
  WiFi.begin(ssid, password);
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println();
  Serial.println("  WiFi connected!");  
  Serial.print("  IP address: ");
  Serial.println(WiFi.localIP());
  Serial.println();
  }


void Send_Temperature(float t)
{
  if (client.connect(server, 80)) {  //   "184.106.153.149" or api.thingspeak.com
    String postStr = apiKey;
           postStr +="&field1=";
           postStr += String(t);
           postStr += "\r\n\r\n";
 
     client.print("POST /update HTTP/1.1\n"); 
     client.print("Host: api.thingspeak.com\n"); 
     client.print("Connection: close\n"); 
     client.print("X-THINGSPEAKAPIKEY: "+apiKey+"\n"); 
     client.print("Content-Type: application/x-www-form-urlencoded\n"); 
     client.print("Content-Length: "); 
     client.print(postStr.length()); 
     client.print("\n\n"); 
     client.print(postStr);
  }
  delay(1000);
  // Read all the lines of the reply from server and print them to Serial
  while(client.available()){
    String line = client.readStringUntil('\r');
    Serial.print(line);
  }
  client.stop();
}



float ReadTemperature(void)
{
  byte i, present = 0, type_s, data[12], addr[8];
  float celsius;
  
  if ( !ds.search(addr)) {
    Serial.println("No more addresses.");
    Serial.println();
    ds.reset_search();
    delay(250);
    return(0.00);
  }
  
  Serial.print("ROM =");
  for( i = 0; i < 8; i++) {
    Serial.write(' ');
    Serial.print(addr[i], HEX);
  }

  if (OneWire::crc8(addr, 7) != addr[7]) {
      Serial.println("CRC is not valid!");
      return(0.00);
  }
  Serial.println();
 
  // the first ROM byte indicates which chip
  switch (addr[0]) {
    case 0x10:
      Serial.println("  Chip = DS18S20");  // or old DS1820
      type_s = 1;
      break;
    case 0x28:
      Serial.println("  Chip = DS18B20");
      type_s = 0;
      break;
    case 0x22:
      Serial.println("  Chip = DS1822");
      type_s = 0;
      break;
    default:
      Serial.println("Device is not a DS18x20 family device.");
      return(0.00);
  } 
  ds.reset();
  ds.select(addr);
  ds.write(0x44, 1);        // start conversion, with parasite power on at the end
  delay(1000);     // maybe 750ms is enough, maybe not
  
  present = ds.reset();
  ds.select(addr);    
  ds.write(0xBE);         // Read Scratchpad

  Serial.print("  Data = ");
  Serial.print(present, HEX);
  Serial.print(" ");
  for ( i = 0; i < 9; i++) {           // we need 9 bytes
    data[i] = ds.read();
    Serial.print(data[i], HEX);
    Serial.print(" ");
  }
  
  int16_t raw = (data[1] << 8) | data[0];
  if (type_s) {
    raw = raw << 3; // 9 bit resolution default
    if (data[7] == 0x10) {
      // "count remain" gives full 12 bit resolution
      raw = (raw & 0xFFF0) + 12 - data[6];
    }
  } else {
    byte cfg = (data[4] & 0x60);
    // at lower res, the low bits are undefined, so let's zero them
    if (cfg == 0x00) raw = raw & ~7;  // 9 bit resolution, 93.75 ms
    else if (cfg == 0x20) raw = raw & ~3; // 10 bit res, 187.5 ms
    else if (cfg == 0x40) raw = raw & ~1; // 11 bit res, 375 ms
  }
  celsius = (float)raw / 16.0;
  Serial.print("  Temperature = ");
  Serial.println(celsius);
  return (celsius);
}


