// ESP8266 uploads temperature from DS18B20 to Xively and sleeps.
// Batterry operated. 30 uA measured current in sleep mode, 75 mA when running
// Works with Arduino IDE 1.6.5. Generic ESP8266, 115200. To enter program mode connect gpio0 to gnd and press reset to gnd shortly.
// On ESP-01 board CH_PD is soldered to 3.3V. To wake from deepsleep the chip pin nr 8 is soldered to Reset.


#include <ESP8266WiFi.h>
#include <OneWire.h>
OneWire  ds(2);  // on pin gpio2 (a 4.7K resistor is necessary)

const char* ssid = "LMT-89B0";//"LU_ASI";
const char* password = "331M372E70J";// "photoplethysmography";
const char* server = "api.xively.com"; //"api.thingspeak.com";
String apiKey = "qpLG77lHBQVhhJlJ5yAhOAin_CggAaW5tnTVnyGj09k";
long sleepTime =10000000;  // 300000000 Sleep for 300 seconds (time is in microseconds) 
WiFiClient client;

/* -------------- Setup ------------------ */
void setup() {
  Serial.begin(115200);
  Serial.println();
  float val = ReadTemperature();
  ESP8266_Init();
  Send_Temperature(val);
  Serial.println(" \r\n Sleeping...");
  ESP.deepSleep(sleepTime, WAKE_RF_DEFAULT);
  delay(1000); //do nothing untill fall in sleep
}

/* ------------- Loop -------------------- */
void loop() {
}



/* --------------- Functions -------------------- */
void ESP8266_Init(){   //Serial.println("Putting WiFi into station mode...\r\n");
  WiFi.mode(WIFI_STA);
  Serial.print("Connecting to: \"");
  Serial.print(ssid);  Serial.print("\",\""); Serial.print(password); Serial.println("\"");
  WiFi.begin(ssid, password);
  //while (WiFi.status() != WL_CONNECTED) {delay(200);Serial.print(".");}
  
  int c = 0;
  while ( c < 20 ) {  // 10 seconds try to connect
    if (WiFi.status() == WL_CONNECTED)  break; 
    delay(500); Serial.print(".");    
    c++;
  }
  if (WiFi.status() == WL_CONNECTED){
  Serial.print("  \r\n WiFi connected IP address: ");
  Serial.println(WiFi.localIP()); Serial.println();
  }

  if (WiFi.status() != WL_CONNECTED){
  Serial.print(" \r\n Could not connect. Sleeping... \r\n");
  ESP.deepSleep(sleepTime, WAKE_RF_DEFAULT);
  delay(1000); //do nothing untill fall in sleep
  }
 }




void Send_Temperature(float t)
{
  if (client.connect(server, 80)) {  // Xively, or Thingsspeak  "184.106.153.149" or api.thingspeak.com
    String postStr = "{\"version\":\"1.0.0\", \"datastreams\": [{\"id\": \"ESP8266ThermometerDeepSleep\", \"current_value\": \"";
           postStr += String(t);
           postStr += "\"}]}\n";
    Serial.print("Post string: "); Serial.println(postStr);
    Serial.print("String length: "); Serial.println(postStr.length()); 
      
     client.print("PUT /v2/feeds/2023977927 HTTP/1.1\r\n"); 
     client.print("Host: api.xively.com\r\n"); 
     client.print("Content-Type: application/json\r\n"); 
     client.print("Content-Length: "); 
     client.print(postStr.length()); 
     client.print("\r\n");
     client.print("X-ApiKey: "+apiKey+"\r\n"); 
     client.print("\r\n"); 
     client.print(postStr);
  }
delay(500);
    while(client.available()){ // Read all the lines of the reply from server and print them to Serial
    String line = client.readStringUntil('\r');
    Serial.print(line);
  }
  client.stop();
}


float ReadTemperature(void)
{
  byte i, present = 0, type_s, data[12], addr[8];
  float celsius;
   ds.reset_search();
   ds.search(addr);
    
  if (OneWire::crc8(addr, 7) != addr[7]) {
      Serial.println("CRC is not valid!");
      return(0.00);
   }
  
  switch (addr[0]) {   // the first ROM byte indicates which chip
    case 0x10: Serial.println("  Chip = DS18S20");  type_s = 1; break;
    case 0x28: Serial.println("  Chip = DS18B20"); type_s = 0; break;
    case 0x22: Serial.println("  Chip = DS1822");  type_s = 0; break;
    default: Serial.println("Device is not a DS18x20 family device."); return(0.00);
  } 
  ds.reset(); ds.select(addr); ds.write(0x44, 1);   // start conversion, with parasite power
  delay(750);     // maybe 750ms is enough
 
  present = ds.reset(); ds.select(addr); ds.write(0xBE);   // Read Scratchpad

  Serial.print("  Data = ");
  Serial.print(present, HEX);
  Serial.print(" ");
  for ( i = 0; i < 9; i++) {           // we need 9 bytes
    data[i] = ds.read();
    Serial.print(data[i], HEX); Serial.print(" ");
  }
  
  int16_t raw = (data[1] << 8) | data[0];
  if (type_s) {
    raw = raw << 3; // 9 bit resolution default
    if (data[7] == 0x10) {
      // "count remain" gives full 12 bit resolution
      raw = (raw & 0xFFF0) + 12 - data[6];
    }
  } else {
    byte cfg = (data[4] & 0x60);
    // at lower res, the low bits are undefined, so let's zero them
    if (cfg == 0x00) raw = raw & ~7;  // 9 bit resolution, 93.75 ms
    else if (cfg == 0x20) raw = raw & ~3; // 10 bit res, 187.5 ms
    else if (cfg == 0x40) raw = raw & ~1; // 11 bit res, 375 ms
  }
  celsius = (float)raw / 16.0;
  Serial.print("  Temperature = "); Serial.println(celsius);
  return (celsius);
}
