// Create a WiFi access point and provide a web server on it.
// Go to http://192.168.4.1 in a web browser connected to this access point to see it.
// Control NeoPixel stripe connected to  GPIO2

#include <ESP8266WiFi.h>
#include <WiFiClient.h> 
#include <ESP8266WebServer.h>
#include <ESP8266mDNS.h>

#include <Adafruit_NeoPixel.h>
#define PIXEL_PIN    2    // Digital IO pin connected to the NeoPixels. ESP GPIO2
#define PIXEL_COUNT 32   // Nnumber of pixels in strip

// Parameter 1 = number of pixels in strip,  neopixel stick has 8
// Parameter 2 = pin number (most are valid)
// Parameter 3 = pixel type flags, add together as needed:
//   NEO_RGB     Pixels are wired for RGB bitstream
//   NEO_GRB     Pixels are wired for GRB bitstream, correct for neopixel stick
//   NEO_KHZ400  400 KHz bitstream (e.g. FLORA pixels)
//   NEO_KHZ800  800 KHz bitstream (e.g. High Density LED strip), correct for neopixel stick
Adafruit_NeoPixel strip = Adafruit_NeoPixel(PIXEL_COUNT, PIXEL_PIN, NEO_GRB + NEO_KHZ800);
int showType = 0;



// Set these to your desired AP credentials.
const char *ssid = "ESP8266";
//const char *password = "thereisnospoon";

ESP8266WebServer server(80);

void setup() {


  strip.begin();
//  strip.show(); // Initialize all pixels to 'off'
    startShow(8);

	delay(1000);
	Serial.begin(115200);
	Serial.println();
	Serial.print("Configuring access point...");
	WiFi.softAP(ssid); // Remove password parameter if you want the AP to be open

	IPAddress myIP = WiFi.softAPIP();
	Serial.print("AP IP address: ");
	Serial.println(myIP);


server.on("/", [](){  // if you add this subdirectory to your webserver call, you get text below :)
    String webString="";     // String to display
    webString="<html><body> \
    <FONT SIZE=+2> ESP8266 Wi-Fi webserver<BR> NeoPixels at GPIO2 control<HR><BR><B> \
    <A href=0> 0 </A> &nbsp; \
    <A href=1> 1 </A> &nbsp;  \
    <A href=2> 2 </A> &nbsp; \
    <A href=3> 3 </A> &nbsp;  \
    <A href=4> 4 </A> &nbsp;  \
    <A href=5> 5 </A> &nbsp;  \
    <A href=6> 6 </A> &nbsp;  \
    <A href=7> 7 </A> &nbsp;  \
    <A href=8> 8 </A> &nbsp;  \
    <A href=9> 9 </A> <BR><br><HR>";
    
    server.send(200, "text/html", webString);            // send to someones browser when asked
    startShow(showType);
  });

  
  server.on("/0", [](){  // if you add this subdirectory to your webserver call, you get text below :)
    String webString="";     // String to display
    webString="<head><meta http-equiv=\"refresh\" content=\"0; url=http://192.168.4.1\"/></head> <body><H1> Iesledzu</H1>";  
    server.send(200, "text/html", webString);            // send to someones browser when asked
      showType = 0;
  });


  server.on("/1", [](){  // if you add this subdirectory to your webserver call, you get text below :)
    String webString="";     // String to display
    webString="<head><meta http-equiv=\"refresh\" content=\"0; url=http://192.168.4.1\"/></head> <body><H1> Iesledzu</H1>";  
    server.send(200, "text/html", webString);            // send to someones browser when asked
      showType = 1;
  });

  server.on("/2", [](){  // if you add this subdirectory to your webserver call, you get text below :)
    String webString="";     // String to display
    webString="<head><meta http-equiv=\"refresh\" content=\"0; url=http://192.168.4.1\"/></head> <body><H1> Iesledzu</H1>";  
    server.send(200, "text/html", webString);            // send to someones browser when asked
      showType = 2;
  });

  server.on("/3", [](){  // if you add this subdirectory to your webserver call, you get text below :)
    String webString="";     // String to display
    webString="<head><meta http-equiv=\"refresh\" content=\"0; url=http://192.168.4.1\"/></head> <body><H1> Iesledzu</H1>";  
    server.send(200, "text/html", webString);            // send to someones browser when asked
      showType = 3;
  });

  server.on("/4", [](){  // if you add this subdirectory to your webserver call, you get text below :)
    String webString="";     // String to display
    webString="<head><meta http-equiv=\"refresh\" content=\"0; url=http://192.168.4.1\"/></head> <body><H1> Iesledzu</H1>";  
    server.send(200, "text/html", webString);            // send to someones browser when asked
      showType = 4;
  });

  server.on("/5", [](){  // if you add this subdirectory to your webserver call, you get text below :)
    String webString="";     // String to display
    webString="<head><meta http-equiv=\"refresh\" content=\"0; url=http://192.168.4.1\"/></head> <body><H1> Iesledzu</H1>";  
    server.send(200, "text/html", webString);            // send to someones browser when asked
      showType = 5;
  });

server.on("/6", [](){  // if you add this subdirectory to your webserver call, you get text below :)
    String webString="";     // String to display
    webString="<head><meta http-equiv=\"refresh\" content=\"0; url=http://192.168.4.1\"/></head> <body><H1> Iesledzu</H1>";  
    server.send(200, "text/html", webString);            // send to someones browser when asked
      showType = 6;
  });

  server.on("/7", [](){  // if you add this subdirectory to your webserver call, you get text below :)
    String webString="";     // String to display
    webString="<head><meta http-equiv=\"refresh\" content=\"0; url=http://192.168.4.1\"/></head> <body><H1> Iesledzu</H1>";  
    server.send(200, "text/html", webString);            // send to someones browser when asked
    showType = 7;
  });

server.on("/8", [](){  // if you add this subdirectory to your webserver call, you get text below :)
    String webString="";     // String to display
    webString="<head><meta http-equiv=\"refresh\" content=\"0; url=http://192.168.4.1\"/></head> <body><H1> Iesledzu</H1>";  
    server.send(200, "text/html", webString);            // send to someones browser when asked
    showType = 8;
  });

  server.on("/9", [](){  // if you add this subdirectory to your webserver call, you get text below :)
    String webString="";     // String to display
    webString="<head><meta http-equiv=\"refresh\" content=\"0; url=http://192.168.4.1\"/></head> <body><H1> Iesledzu</H1>";  
    server.send(200, "text/html", webString);            // send to someones browser when asked
      showType = 9;
  });

  
	server.begin();

	
	Serial.println("HTTP server started");
}

void loop() {
	server.handleClient();
  
}













void startShow(int i) {
  switch(i){
    case 0: colorWipe(strip.Color(0, 0, 0), 50);    // Black/off
            break;
    case 1: colorWipe(strip.Color(255, 0, 0), 50);  // Red
            break;
    case 2: colorWipe(strip.Color(0, 255, 0), 50);  // Green
            break;
    case 3: colorWipe(strip.Color(0, 0, 255), 50);  // Blue
            break;
    case 4: theaterChase(strip.Color(127, 127, 127), 50); // White
            break;
    case 5: theaterChase(strip.Color(127,   0,   0), 50); // Red
            break;
    case 6: theaterChase(strip.Color(  0,   0, 127), 50); // Blue
            break;
    case 7: rainbow(20);
            break;
    case 8: rainbowCycle(20);
            break;
    case 9: theaterChaseRainbow(50);
            break;  
  }
  
}

// Fill the dots one after the other with a color
void colorWipe(uint32_t c, uint8_t wait) {
  for(uint16_t i=0; i<strip.numPixels(); i++) {
    strip.setPixelColor(i, c);
    strip.show();
    delay(wait);
  }
}

void rainbow(uint8_t wait) {
  uint16_t i, j;

  for(j=0; j<256; j++) {
    for(i=0; i<strip.numPixels(); i++) {
      strip.setPixelColor(i, Wheel((i+j) & 255));
    }
    strip.show();
    delay(wait);
  }
}

// Slightly different, this makes the rainbow equally distributed throughout
void rainbowCycle(uint8_t wait) {
  uint16_t i, j;

  for(j=0; j<256*1; j++) { // 5 cycles of all colors on wheel
    for(i=0; i< strip.numPixels(); i++) {
      strip.setPixelColor(i, Wheel(((i * 256 / strip.numPixels()) + j) & 255));
    }
    strip.show();
    delay(wait);
  }
}

//Theatre-style crawling lights.
void theaterChase(uint32_t c, uint8_t wait) {
  for (int j=0; j<10; j++) {  //do 10 cycles of chasing
    for (int q=0; q < 3; q++) {
      for (int i=0; i < strip.numPixels(); i=i+3) {
        strip.setPixelColor(i+q, c);    //turn every third pixel on
      }
      strip.show();

      delay(wait);

      for (int i=0; i < strip.numPixels(); i=i+3) {
        strip.setPixelColor(i+q, 0);        //turn every third pixel off
      }
    }
  }
}

//Theatre-style crawling lights with rainbow effect
void theaterChaseRainbow(uint8_t wait) {
  for (int j=0; j < 256; j++) {     // cycle all 256 colors in the wheel
    for (int q=0; q < 3; q++) {
      for (int i=0; i < strip.numPixels(); i=i+3) {
        strip.setPixelColor(i+q, Wheel( (i+j) % 255));    //turn every third pixel on
      }
      strip.show();

      delay(wait);

      for (int i=0; i < strip.numPixels(); i=i+3) {
        strip.setPixelColor(i+q, 0);        //turn every third pixel off
      }
    }
  }
}

// Input a value 0 to 255 to get a color value.
// The colours are a transition r - g - b - back to r.
uint32_t Wheel(byte WheelPos) {
  WheelPos = 255 - WheelPos;
  if(WheelPos < 85) {
    return strip.Color(255 - WheelPos * 3, 0, WheelPos * 3);
  }
  if(WheelPos < 170) {
    WheelPos -= 85;
    return strip.Color(0, WheelPos * 3, 255 - WheelPos * 3);
  }
  WheelPos -= 170;
  return strip.Color(WheelPos * 3, 255 - WheelPos * 3, 0);
}
