/*
 * Decompiled with CFR 0.152.
 */
package processing.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import processing.xml.XMLElement;

public class XMLWriter {
    static final int INDENT = 2;
    static final String HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private PrintWriter writer;

    public XMLWriter(Writer writer) {
        this.writer = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public XMLWriter(OutputStream stream) {
        this.writer = new PrintWriter(stream);
    }

    protected void finalize() throws Throwable {
        this.writer = null;
        super.finalize();
    }

    public void write(XMLElement xml) throws IOException {
        this.write(xml, false, 0, 2, true);
    }

    public void write(XMLElement xml, boolean prettyPrint) throws IOException {
        this.write(xml, prettyPrint, 0, 2, true);
    }

    public void write(XMLElement xml, boolean prettyPrint, int initialIndent) throws IOException {
        this.write(xml, prettyPrint, initialIndent, 2, true);
    }

    public void write(XMLElement xml, boolean prettyPrint, int initialIndent, int eachIndent, boolean collapseEmptyElements) throws IOException {
        if (prettyPrint) {
            int i = 0;
            while (i < initialIndent) {
                this.writer.print(' ');
                ++i;
            }
        }
        if (xml.getLocalName() == null) {
            if (xml.getContent() != null) {
                if (prettyPrint) {
                    this.writeEncoded(xml.getContent().trim());
                    this.writer.println();
                } else {
                    this.writeEncoded(xml.getContent());
                }
            }
        } else {
            this.writer.print('<');
            this.writer.print(xml.getName());
            String[] stringArray = xml.listAttributes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                String value = xml.getString(key, null);
                this.writer.print(" " + key + "=\"");
                this.writeEncoded(value);
                this.writer.print('\"');
                ++n2;
            }
            if (xml.getContent() != null && xml.getContent().length() > 0) {
                this.writer.print('>');
                this.writeEncoded(xml.getContent());
                this.writer.print("</" + xml.getName() + '>');
                if (prettyPrint) {
                    this.writer.println();
                }
            } else if (xml.hasChildren() || !collapseEmptyElements) {
                this.writer.print('>');
                if (prettyPrint) {
                    this.writer.println();
                }
                int count = xml.getChildCount();
                int i = 0;
                while (i < count) {
                    XMLElement child = xml.getChild(i);
                    this.write(child, prettyPrint, initialIndent + eachIndent, eachIndent, collapseEmptyElements);
                    ++i;
                }
                if (prettyPrint) {
                    i = 0;
                    while (i < initialIndent) {
                        this.writer.print(' ');
                        ++i;
                    }
                }
                this.writer.print("</" + xml.getName() + ">");
                if (prettyPrint) {
                    this.writer.println();
                }
            } else {
                this.writer.print("/>");
                if (prettyPrint) {
                    this.writer.println();
                }
            }
        }
        this.writer.flush();
    }

    private void writeEncoded(String str) {
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            switch (c) {
                case '\n': {
                    this.writer.print(c);
                    break;
                }
                case '<': {
                    this.writer.print("&lt;");
                    break;
                }
                case '>': {
                    this.writer.print("&gt;");
                    break;
                }
                case '&': {
                    this.writer.print("&amp;");
                    break;
                }
                case '\'': {
                    this.writer.print("&apos;");
                    break;
                }
                case '\"': {
                    this.writer.print("&quot;");
                    break;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        this.writer.print("&#x");
                        this.writer.print(Integer.toString(c, 16));
                        this.writer.print(';');
                        break;
                    }
                    this.writer.print(c);
                }
            }
            ++i;
        }
    }
}

