#ifndef RGB_LED_H
#define RGB_LED_H

#include "Arduino.h"
#include "LED.h"

class RGB_LED {
 public:
    typedef enum {
        MANUAL,
        RAINBOW,
        FADE_OFF,
    } Mode;

    RGB_LED( uint8_t redPin, uint8_t greenPin, uint8_t bluePin, bool isOnWhenHigh);

    // h is in [0,360]
    // s and v are [0,1]
    void SetHSV( float h, float s, float v);

    void SetMode( Mode newMode);

    // Wait this many ticks when changing intensity during smooth on, off, and trob.
    // Bigger numbers mean slower fades. Default is 2.
    void SetSmoothDelay( uint8_t delay);

    // reg, green and blue are in {0..255}
    void SetRGB( uint8_t red, uint8_t green, uint8_t blue);

    void Update();

 private:
    long int ticks;
    float hue;
    Mode mode;
    LED red;
    LED green;
    LED blue;
};
#endif
