//
//  LightingViewController.m
//  EntertainmentCenter
//
//  Created by Tony DeRose on 9/2/13.
//  Copyright (c) 2013 Tony DeRose. All rights reserved.
//

#import "LightingViewController.h"

#import "EntertainmentCenterController.h"

@interface LightingViewController ()

@end

@implementation LightingViewController
- (IBAction) buttonPressed: (id) sender
{
    EcCommand cmd = [sender tag];
    [[EntertainmentCenterController mainController] sendCommand: cmd];
}

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
        _red = _green = _blue = 128;
    }
    return self;
}

- (void) updateColor
{
    EntertainmentCenterController *mainController = [EntertainmentCenterController mainController];
    NSString *cmdString = [NSString stringWithFormat: @"rgb_%d_%d_%d", _red, _green, _blue];

    [mainController sendCommandString: [cmdString UTF8String]];
}

- (IBAction) setRed: (UISlider *) sender
{
    _red = (int) sender.value;
    [self updateColor];
}

- (IBAction) setGreen: (UISlider *) sender
{
    _green = (int) sender.value;
    [self updateColor];
}

- (IBAction) setBlue: (UISlider *) sender
{
    _blue = (int) sender.value;
    [self updateColor];
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    // Do any additional setup after loading the view from its nib.
    self.title = @"Lighting";
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

@end
