// Fishfeeder
// Thomas Van den Dries 
// ThomasVDD on instructables

#include <Wire.h>
#include "RTClib.h"
#include <Servo.h>
#include "LowPower.h"

RTC_DS3231 rtc;
Servo myservo;

// Feed specifications
const int feedStartMonth = 3;   // Month in which the feeding can start
const int feedEndMonth = 10;    // Month in which the feeding must stop
const int feedHour = 13;        // Hour at which to feed
const int feedMinute = 00;      // Minute at which to feed
const int feedAmount = 3;       // Amount of turns for a daily feed
const int treatAmount = 1;      // Amount of turns for a treat (button press)

// Pin numbers
const int buttonPin = 3;
const int servoDataPin = 9;
const int servoPowerPin = 6;
const int ledPin = 13;
const int RTCPin = A0;

// Variables
boolean fishFed = 0;
const int servoSpeed = 10; //the higher the slower
volatile boolean buttonPressed = 0;

void setup () {
  pinMode(servoPowerPin, OUTPUT);
  digitalWrite(servoPowerPin, LOW);
  pinMode(RTCPin, OUTPUT);
  digitalWrite(RTCPin, HIGH);
  pinMode(ledPin, OUTPUT);
  digitalWrite(ledPin, LOW);
  pinMode(buttonPin, INPUT);
  digitalWrite(buttonPin, HIGH);
  attachInterrupt(digitalPinToInterrupt(buttonPin), ISRtreat, FALLING);
  buttonPressed = 0;

  //signal powerup (since we removed the powerled)
  digitalWrite(ledPin, HIGH);
  delay(3000);
  digitalWrite(ledPin, LOW);

  myservo.attach(servoDataPin);

  Serial.begin(9600);

  if (! rtc.begin()) {
    Serial.println("Couldn't find RTC");
    while (1);
  }

  if (rtc.lostPower()) {
    Serial.println("RTC lost power, lets set the time!");
    // following line sets the RTC to the date & time this sketch was compiled
    rtc.adjust(DateTime(F(__DATE__), F(__TIME__)));
  }
}

void loop () {
  // Enable RTC
  digitalWrite(RTCPin, HIGH);
  // Get the clock value
  DateTime now = rtc.now();
  // Disable RTC
  digitalWrite(RTCPin, LOW);

  // Print the time
  Serial.print(now.hour(), DEC);
  Serial.print(':');
  Serial.print(now.minute(), DEC);
  Serial.print(':');
  Serial.print(now.second(), DEC);
  Serial.println();

  // Check the period of the year
  if ((now.month() >= feedStartMonth) && (now.month() <= feedEndMonth)) {
    // Check the time
    if ((now.hour() == feedHour) && (now.minute() == feedMinute)) {
      // Check if the fish already had food this minute
      if (!fishFed) {
        for (int i = 0; i < feedAmount; i++) {
          turnServo(servoSpeed);
        }
        fishFed = 1;
        Serial.println("Your fish are now happy!");
      }
    }
    else {
      fishFed = 0;
    }
  }

  // check the button
  if (buttonPressed) {
    digitalWrite(ledPin, HIGH);
    for (int i = 0; i < treatAmount; i++) {
      turnServo(servoSpeed);
    }
    digitalWrite(ledPin, LOW);
    Serial.println("Your fish are now happy!");
    buttonPressed = 0;
  }

  // wait for serial print to complete
  delay(100);

  // Enter low power mode to save current
  LowPower.powerDown(SLEEP_8S, ADC_OFF, BOD_OFF);
}

void turnServo(int servoSpeed) {
  digitalWrite(servoPowerPin, HIGH);
  delay(200);
  int pos = 180;
  for (pos = 180; pos >= 40; pos -= 1) {  // goes from 180 degrees to 40 degrees
    myservo.write(pos);                   // tell servo to go to position in variable 'pos'
    delay(servoSpeed);                    // waits 15ms for the servo to reach the position
  }
  for (pos = 40; pos <= 180; pos += 1) {  // goes from 40 degrees to 180 degrees
    myservo.write(pos);                   // tell servo to go to position in variable 'pos'
    delay(servoSpeed);                    // waits 15ms for the servo to reach the position
  }
  delay(100);
  digitalWrite(servoPowerPin, LOW);
}

// ISR for button
void ISRtreat() {
  Serial.println("Button Pressed");
  buttonPressed = 1;
}
