﻿package com.SocketsConnection{
	import flash.events.Event;
	import flash.events.IEventDispatcher;
	import flash.events.EventDispatcher;
	import flash.events.ProgressEvent;
	import flash.events.DataEvent;
	import flash.errors.*;
	import flash.net.Socket;
	import flash.utils.ByteArray;

	public class SocketModel extends SocketsModel {
		private var socket:Socket;
		private var _hostName:String;
		private var _port:uint;
		private var _appID:String;

		public static const ARDUINO_SOCKET_INCOMING_DATA:String="arduinoSocketIncomingData";

		public function SocketModel(hostName:String,port:uint,appId:String) {
			trace("XMLSocketConnection");
			_hostName=hostName;
			_port=port;
			appID=appId;
			connectSocket();
		}

		override protected function connectSocket():void {
			socket=new Socket();
			configureListeners(socket);
			socket.addEventListener(ProgressEvent.SOCKET_DATA, dataHandler);

			if (_hostName&&_port) {
				socket.connect(_hostName, _port);
			}
		}

		override public function sendMessage(msg:String):void {
			try {
				socket.writeUTFBytes(msg);
				socket.flush();
			} catch (e:IOError) {
				dispatchEvent(new Event(SocketsModel.SOCKET_IO_ERROR));
			}
		}
		
		public function sendCommand(bytes:Array):void {
			var bytesArray:ByteArray = new ByteArray();
			bytesArray.writeByte(0);
			for(var i=0;i<bytes.length;i++){
				bytesArray.writeByte(bytes[i]);
			}
			try {
				socket.writeBytes(bytesArray);
				socket.flush();
			} catch (e:IOError) {
				dispatchEvent(new Event(SocketsModel.SOCKET_IO_ERROR));
			}
		}

		public function set appID(appId:String):void {
			_appID=appId;
		}

		public function get appID():* {
			return _appID;
		}

		//////////////////////
		//THE LISTENERS//
		//////////////////////
		private function dataHandler(e:ProgressEvent):void {
			data=socket.readUTFBytes(socket.bytesAvailable);
			dispatchEvent(new Event(SocketModel.ARDUINO_SOCKET_INCOMING_DATA));
		}
	}
}