/*
 * CalHaunts PIR, Relays, and Fog Machine controller, for Make & Take workshop, July 2013
 * Based on AdaFruit example code
 * To be used with Evil Mad Science's Diavolino [but is compatible with any Arduino], a PIR, a dual relay board, and custom-made fog machine add-on.
 * 7/14/2013 by Jeff Haas
 */
// Allows an Arduino to act as a 3-Stage Timer and control two relays, one specifically set up for a fog machine, with optional delay between relays.
// Includes blinking LED for PIR warmup, and easy to change Prop Timing variables.
//
// After uploading sketch, hit CTRL + SHIFT + M to see debug info on Serial Monitor.
// 
/////////////////////////////
//VARIABLES 
int pirPin = 6;                 // input pin for PIR sensor
int relay1 = 2;                 // digital pin connected to relay1
int relay2 = 3;                 // digital pin connected to relay2
int fog = 4;                    // digital pin connected to fog machine relay
int ledPin = 13;                // pin for the built-in LED

int pirState = LOW;             // we start, assuming no motion detected
int PirVal = 0;                 // variable for reading the pin status
int TIMER = 0;                  // For tracking PIR debounce

//Prop Timing variables
int calibrationTime = 60;       // Set PIR calibration time.  Should be 60 seconds for good warmup.  Time in seconds.
int PropWait = 2;               // Pause before props go off after motion is detected.  Time in seconds.
int Rly1Run = 1;                // How long Relay1 runs.  Time in seconds.
int PropGap = 2;                // Time between first relay going off and second relay going off.  Time in seconds.
int Rly2Run = 1;                // How long Relay2 runs.  Time in seconds.
int PropGap2 = 1;               // Time between second relay going off and fog machine going off.  Time in seconds.
int FogRun = 2;                 // How long fog machine is turned on.  Time in seconds.
int ResetTime = 20;             // Run time of prop + PIR cool down + desired wait time for next trigger.  Time in seconds.

/////////////////////////////
//SETUP 
void setup() {
  pinMode(pirPin, INPUT);       // declare PIR sensor as input
  pinMode(relay1, OUTPUT);      // declare relay1 as output
  pinMode(relay2, OUTPUT);      // declare relay2 as output
  pinMode(fog, OUTPUT);         // declare fog as output
  pinMode(ledPin, OUTPUT);      // declare LED as output
 
  Serial.begin(9600);           // Use Serial Monitor to debug


//Give the PIR sensor some time to calibrate
  Serial.print("Calibrating sensor");  
    for(int i = 0; i < calibrationTime; i++){
      Serial.print(".");
        digitalWrite(ledPin, HIGH);  // Blink LED while PIR is calibrating
        delay (500);
        digitalWrite(ledPin, LOW);
        delay (500);
      }
    Serial.println("done.");
    Serial.println("SENSOR ACTIVE");
    delay(50); 
}

////////////////////////////
//LOOP 
void loop(){

  PirVal = digitalRead(pirPin);       // Read input value
  TIMER = TIMER + 5 * PirVal;         // PIR debounce code
//  Serial.println(TIMER);            // Show value of TIMER for setting sensitivity of debounce
  if (TIMER > 100) {                 // Wait for 0.1 sec input
  
  Serial.println("Motion detected");   
    if (pirState == LOW) {          // The PIR has just turned on, but the variable for the PIR's state is LOW...
      pirState = HIGH;              // ...so change the value to HIGH.  Print only on the output change, not state.
    }

// Now turn everything on to trigger the props!

    for(int j = 0; j < PropWait; j++){    // Delay before the first relay is triggered  
      Serial.print(".");
      delay(1000);
      }
    Serial.println("Relay 1!");
    
    digitalWrite(ledPin, HIGH);           // Turn LED ON for a visual indicator
    digitalWrite(relay1, HIGH);           // Turn relay1 ON

    for(int j = 0; j < Rly1Run; j++){   // Time Relay1 runs
    Serial.print(".");
    delay(1000);
      }
    
    digitalWrite(relay1, LOW);            // Turn relay1 OFF

    for(int j = 0; j < PropGap; j++){  // Delay between triggering Relay1 and Relay2
    Serial.print(".");
    delay(1000);
      }

    Serial.println("Relay 2!");       

    digitalWrite(relay2, HIGH);           // Turn relay2 ON

    for(int j = 0; j < Rly2Run; j++){   // Time Relay2 runs
    Serial.print(".");
    delay(1000);
      }

    digitalWrite(ledPin, LOW);      // Turn LED OFF
    digitalWrite(relay2, LOW);      // Turn relay2 OFF
    
    for(int j = 0; j < PropGap2; j++){  // Delay between triggering Relay2 and fog machine
    Serial.print(".");
    delay(1000);
      }

    Serial.println("Fog machine!");       

    digitalWrite(fog, HIGH);           // Turn fog machine ON

    for(int j = 0; j < FogRun; j++){   // Time fog machine runs
    Serial.print(".");
    delay(1000);
      }
      
    digitalWrite(fog, LOW);      // Turn fog machine OFF

    TIMER = 0;                      // Reset TIMER byte
    
    Serial.print("Reset");          // Prop reset time.
             
    for(int j = 0; j < ResetTime; j++){  
      Serial.print(".");
      delay(1000);
      }
    
  } else {
    if (pirState == HIGH){     // We have just turned off, so pirState is HIGH
      Serial.println("Ready"); // We only want to print on the output change, not state
      pirState = LOW;          // Reset variable that tracks the PIR's state.
    }
  }
  delay(5);        // Brief pause on the checking loop.  Acts as debounce delay.
}
