//sine wave freq detection with 38.5kHz sampling rate and interrupts
//by Amanda Ghassaei
//http://www.instructables.com/id/Arduino-Frequency-Detection/
//July 2012

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
*/

//clipping indicator variables
//boolean clipping = 0;

//data storage variables
byte newData = 0;
byte prevData = 0;

//freq variables
unsigned int timer = 0;//counts period of wave
unsigned int period;
int frequency;

void setup(){
  
  Serial.begin(9600);
  
  pinMode(13,OUTPUT);//led indicator pin
  pinMode(12,OUTPUT);//output pin
  pinMode(11,OUTPUT);
  pinMode(10,OUTPUT);
  pinMode(9,OUTPUT);
  pinMode(8,OUTPUT);
  
  cli();//disable interrupts
  
  //set up continuous sampling of analog pin 0
  
  //clear ADCSRA and ADCSRB registers
  ADCSRA = 0;
  ADCSRB = 0;
  
  ADMUX |= (1 << REFS0); //set reference voltage
  ADMUX |= (1 << ADLAR); //left align the ADC value- so we can read highest 8 bits from ADCH register only
  
  ADCSRA |= (1 << ADPS2) | (1 << ADPS0); //set ADC clock with 32 prescaler- 16mHz/32=500kHz
  ADCSRA |= (1 << ADATE); //enabble auto trigger
  ADCSRA |= (1 << ADIE); //enable interrupts when measurement complete
  ADCSRA |= (1 << ADEN); //enable ADC
  ADCSRA |= (1 << ADSC); //start ADC measurements
  
  sei();//enable interrupts
}

ISR(ADC_vect) {//when new ADC value ready

  prevData = newData;//store previous value
  newData = ADCH;//get value from A0
  if (prevData < 127 && newData >=127){//if increasing and crossing midpoint
    period = timer;//get period
    timer = 0;//reset timer
    frequency = 38462/period;
    delay(10);
  }
  
  
  /*if (newData == 0 || newData == 1023){//if clipping
    PORTB |= B00100000;//set pin 13 high- turn on clipping indicator led
    clipping = 1;//currently clipping
  }*/
  
  timer++;//increment timer at rate of 38.5kHz
}

void loop(){
  /*if (clipping){//if currently clipping
    PORTB &= B11011111;//turn off clippng indicator led
    clipping = 0;
  }*/

  //frequency = 38462/period;//timer rate/period
  //print results
  if(frequency>=1 and frequency<=399){
    PORTB |= B00010000;
    delay(190);
    PORTB &= B11101111;
  }
  if(frequency>=201 and frequency<=850.99){
    PORTB |= B00001000;
    delay(190);
    PORTB &= B11110111;
    }
  if(frequency>=800 and frequency<=1500){
     PORTB |= B00000100;
    delay(190);
    PORTB &= B11111011;
  }
   if(frequency>=1000 and frequency<=3000){
    PORTB |= B00000010;
    delay(190);
    PORTB &= B11111101;
  }
   if(frequency>=1800 and frequency<=20000){
     PORTB |= B00000001;
    delay(190);
    PORTB &= B11111110;
  }
  Serial.print(frequency);
  Serial.println(" hz");
  
  delay(100);
}
