#include <Adafruit_NeoPixel.h>
#ifdef __AVR__
#include <avr/power.h>
#endif

#define PIN 9
#define POT A0
#define BUTTON1 A1
#define BUTTON2 A2

// Parameter 1 = number of pixels in strip
// Parameter 2 = Arduino pin number (most are valid)
// Parameter 3 = pixel type flags, add together as needed:
//   NEO_KHZ800  800 KHz bitstream (most NeoPixel products w/WS2812 LEDs)
//   NEO_KHZ400  400 KHz (classic 'v1' (not v2) FLORA pixels, WS2811 drivers)
//   NEO_GRB     Pixels are wired for GRB bitstream (most NeoPixel products)
//   NEO_RGB     Pixels are wired for RGB bitstream (v1 FLORA pixels, not v2)
//   NEO_RGBW    Pixels are wired for RGBW bitstream (NeoPixel RGBW products)
Adafruit_NeoPixel halo = Adafruit_NeoPixel(12, PIN, NEO_GRB + NEO_KHZ800);

// And now, a safety message from our friends at Adafruit:

// IMPORTANT: To reduce NeoPixel burnout risk, add 1000 uF capacitor across
// pixel power leads, add 300 - 500 Ohm resistor on first pixel's data input
// and minimize distance between Arduino and first pixel.  Avoid connecting
// on a live circuit...if you must, connect GND first.


// Variables 
int buttonState1; 
int buttonState2;             // the current reading from the input pin
int lastButtonState1 = LOW;   // the previous reading from the input pin
int lastButtonState2 = LOW;
int mode;                   //the mode of our lights, can be one of 16 settings (0 through 15)
int brightVal = 0;            // the brightness/ speed, as set by the potentiometer

// the following variables are long's because the time, measured in miliseconds,
// will quickly become a bigger number than can be stored in an int.
long lastDebounceTime = 0;  // the last time the output pin was toggled
long debounceDelay = 50;    // the debounce time; increase if the output flickers


void debounce (){
  // read the state of the switch into a local variable:
  int reading1 = digitalRead(BUTTON1);
  int reading2 = digitalRead(BUTTON2);
  // If either of the buttons changed, due to noise or pressing:
  if (reading1 != lastButtonState1 || reading2 != lastButtonState2) {
    // reset the debouncing timer
    lastDebounceTime = millis();
  } 
  if ((millis() - lastDebounceTime) > debounceDelay) {
    // if the button state has definitely changed due to pressing/releasing:
    if (reading1 != buttonState1) {
      buttonState1 = reading1;     //set it as the reading if it's changed
      if (buttonState1 == LOW) { //these are set as active low switches
        mode ++;
        if (mode == 16){
          mode = 0;
        }
      }
    }
      if (reading2 != buttonState2){
        buttonState2 = reading2;
        if (buttonState2 == LOW){
          mode = mode - 1;
          if (mode == -1){
            mode = 15;
          }
        }
      }
    }
    // save the reading for the next time through the loop
    lastButtonState1 = reading1;
    lastButtonState2 = reading2;
  }



void getBright(){  //our code to read the potentiometer, utputs a value between 0 and 255. Used to set brightness in some modes and speed in others.
  int potVal = analogRead(POT);
  brightVal = map(potVal, 0, 1023, 0, 255);
}

//Here are our color modes. Some of these are derived from the strandtest example, others are original.

// Fill the dots one after the other with a color
void colorWipe(uint32_t c, uint8_t wait) {
  for(uint16_t i=0; i<halo.numPixels(); i++) {
    halo.setPixelColor(i, c);
    halo.show();
    delay(wait);
  }
}

void rainbow(uint8_t wait) {
  uint16_t i, j;

  for(j=0; j<256; j++) {
    for(i=0; i<halo.numPixels(); i++) {
      halo.setPixelColor(i, Wheel((i+j) & 255));
    }
    halo.show();
    delay(wait);
  }
}

// Slightly different, this makes the rainbow equally distributed throughout
void rainbowCycle(uint8_t wait) {
  uint16_t i, j;

  for(j=0; j<256*5; j++) { // 5 cycles of all colors on wheel
    for(i=0; i< halo.numPixels(); i++) {
      halo.setPixelColor(i, Wheel(((i * 256 / halo.numPixels()) + j) & 255));
    }
    halo.show();
    delay(wait);
  }
}

// Input a value 0 to 255 to get a color value.
// The colours are a transition r - g - b - back to r.
uint32_t Wheel(byte WheelPos) {
  WheelPos = 255 - WheelPos;
  if(WheelPos < 85) {
    return halo.Color(255 - WheelPos * 3, 0, WheelPos * 3);
  }
  if(WheelPos < 170) {
    WheelPos -= 85;
    return halo.Color(0, WheelPos * 3, 255 - WheelPos * 3);
  }
  WheelPos -= 170;
  return halo.Color(WheelPos * 3, 255 - WheelPos * 3, 0);
}



void setup() {
  // This is for Trinket 5V 16MHz, you can remove these three lines if you are not using a Trinket
#if defined (__AVR_ATtiny85__)
  if (F_CPU == 16000000) clock_prescale_set(clock_div_1);
#endif
  // End of trinket special code
  
  pinMode(POT, INPUT);
  pinMode(BUTTON1, INPUT_PULLUP);
  pinMode(BUTTON2, INPUT_PULLUP);
  pinMode(PIN, OUTPUT);
  Serial.begin(9600);  //debugging stuff
  halo.begin();
  halo.show(); // Initialize all pixels to 'off'
}

void loop() {

  debounce();
 
  Serial.println(mode);                     //more debugging
  Serial.println(lastButtonState1);
  Serial.println(lastButtonState2);

  if (mode == 0){
    getBright();
    for (int i = 0; i < halo.numPixels(); i++){
      halo.setPixelColor(i, halo.Color(brightVal, brightVal, brightVal));   //set all pixels to white
    }
    halo.show();
  };
  if (mode == 1){
    getBright();
    for (int i = 0; i < halo.numPixels(); i++){
      halo.setPixelColor(i, halo.Color(brightVal, 0, 0));  // set all pixels to red
    }
    halo.show();
  };
  if (mode == 2){
    getBright();
    for (int i = 0; i < halo.numPixels(); i++){
      halo.setPixelColor(i, halo.Color(0, brightVal, 0));  // set all pixels to green
    }
    halo.show();
  };
  if (mode == 3){
    getBright();
    for (int i = 0; i < halo.numPixels(); i++){
      halo.setPixelColor(i, halo.Color(0, 0, brightVal));  // set all pixels to blue
    }
    halo.show();
  };
  if (mode == 4){
    getBright();
    for (int i = 0; i < halo.numPixels(); i++){
      halo.setPixelColor(i, halo.Color(0, brightVal, brightVal));  // set all pixels to cyan
    }
    halo.show();
  };
  if (mode == 5){
    getBright();
    for (int i = 0; i < halo.numPixels(); i++){
      halo.setPixelColor(i, halo.Color(brightVal, 0, brightVal));  // set all pixels to purple/magenta
    }
    halo.show();
  };
  if (mode == 6){
    getBright();
    for (int i = 0; i < halo.numPixels(); i++){
      halo.setPixelColor(i, halo.Color(brightVal, brightVal, 0));  // set all pixels to orange/yellow
    }
    halo.show();
  };
  if (mode == 7){ //now the dynamic modes
    getBright();
    colorWipe(halo.Color(brightVal, 0, 0), 50); // Red
  };
  if (mode == 8){
    getBright();
    colorWipe(halo.Color(0, brightVal, 0), 50); // Green
  };
  if (mode == 9){
    getBright();
    colorWipe(halo.Color(0, 0, brightVal), 50); // Blue
  };
  if (mode == 10){
    getBright();
    colorWipe(halo.Color(brightVal, brightVal, brightVal), 50); // white
  };
  if (mode == 11){
    getBright();
    colorWipe(halo.Color(brightVal, brightVal, 0), 50); // orange/yellow
  };
  if (mode == 12){
    getBright();
    colorWipe(halo.Color(0, brightVal, brightVal), 50); // cyan
  };
  if (mode == 13){
    getBright();
    colorWipe(halo.Color(brightVal, 0, brightVal), 50); // purple/magenta
  };
  if (mode == 14){  // the last two are speed control, because the brightness is dynamic
    getBright();
    rainbow(brightVal);
  };
  if (mode == 15){
    getBright();
    rainbowCycle(brightVal);
  };
  delay(10);   //allow the processor a little rest
}

