// Autonmous Blimp by DJ Harrigan

#include <Wire.h>
#include <LIDARLite.h>
#include <Servo.h>

#define PIN_SERVO_RIGHT 9
#define PIN_SERVO_LEFT  6
#define PIN_SERVO_UP    3
#define PIN_SENSOR_IR   5
#define TOO_LOW 1

Servo thrusterRight;
Servo thrusterLeft;
Servo thrusterUp;
LIDARLite lidarSensor;

boolean irSensorState = false;
int currentDistance = 0;
int distanceThreshold = 10;
int currentState = 0;

unsigned long currentTime = 0;
unsigned long lastTime = 1;
unsigned long sensorReadingInterval = 5;

void setup() {

lidarSensor.begin();
thrusterRight.attach(PIN_SERVO_RIGHT);
thrusterLeft.attach(PIN_SERVO_LEFT);
thrusterUp.attach(PIN_SERVO_UP);
pinMode(PIN_SENSOR_IR, INPUT); // there's a hardware pullup on the physical board

thrustersOff();
delay(3000); // allow time to trim the servo pots so that they are neutral at start up
goForward;
}

void loop() {

  currentTime = millis();
  
  if (currentTime - lastTime > sensorReadingInterval){
    lastTime = currentTime;
    getInput(); // only query every 5 milliseconds
  }
  
  switch (currentState){
    case 0: // moving forward
      if (irSensorState == TOO_LOW){
        currentState = 1;
        break;
      }
      if (currentDistance < distanceThreshold){
        currentState = 2; // turning
      }
    break;
    case 1: // rising
      goUp();
      delay(2500);
      thrusterUp.write(90); // stop rising
      goForward();
      currentState = 0;
    break;
    case 2: // turning
      int tempChance = int(random(1, 100));
      if (tempChance > 50){
        goLeft();
      } else {
        goRight();
      }
      delay(2500);
      goForward();
      currentState = 0;
    break;
  }
  
}

void getInput(){
  currentDistance = lidarSensor.distance();
  irSensorState = digitalRead(PIN_SENSOR_IR);
}

void goForward(){
  thrusterRight.write(160);
  thrusterLeft.write(0);
}

void goLeft(){
  thrusterRight.write(0);
  thrusterLeft.write(0);
}

void goRight(){
  thrusterRight.write(160);
  thrusterLeft.write(160);
}
void goUp(){
  thrusterUp.write(160);
}

void thrustersOff(){
  thrusterUp.write(90);
  thrusterLeft.write(90);
  thrusterRight.write(90);
}

