// Intel Edison Mini Thermal Camera by DJ Harrigan for Instructables

#include <Adafruit_DotStar.h>
#include <SPI.h>
#include <Arduino.h>
#include <Wire.h>
#include "MLX90621.h"  

#define NUM_PIXELS 64
#define PIN_DATA   4
#define PIN_CLOCK  5
#define THERMAL_ARRAY_COLUMNS 16
#define THERMAL_ARRAY_ROWS    4


Adafruit_DotStar strip = Adafruit_DotStar(NUM_PIXELS, PIN_DATA, PIN_CLOCK, DOTSTAR_BRG);
MLX90621 sensor; // create an instance of the Sensor class

uint32_t someColor = 0x000000; //GRB

int minTemp = 0;
int maxTemp = 0;

float thermalArray[THERMAL_ARRAY_ROWS][THERMAL_ARRAY_COLUMNS] = { //[Y][X]
  {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
  {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
  {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
  {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 100.0},
};

uint32_t mappedPixelColors[THERMAL_ARRAY_ROWS][THERMAL_ARRAY_COLUMNS]{
    {0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000},
    {0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000},
    {0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000},
    {0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000, 0x000000}
};

void setup() {

  //Serial.begin(9600);
  strip.begin(); // Initialize pins for output
  strip.show();  // Turn all LEDs off ASAP
  sensor.initialise (4);
  
}

void loop() {
  // put your main code here, to run repeatedly:
  getThermalData();
  mapThermalToFalseColor();
  drawNewImage();
  delay(10);

}

void getThermalData(){ // read info from MLX90621 into thermalArray

  minTemp = int(sensor.getMinTemp());
  maxTemp = int(sensor.getMaxTemp());
  sensor.measure(true); //get new readings from the sensor
  for (int rr = 0; rr < THERMAL_ARRAY_ROWS; rr++){
    for (int cc = 0; cc < THERMAL_ARRAY_COLUMNS; cc++){
      thermalArray[rr][cc] = sensor.getTemperature(rr+cc*4);
    }
  }
  
}

void mapThermalToFalseColor(){

uint32_t redComponent = 0;
uint32_t blueComponent = 0;
uint32_t falsePixelColor = 0;

  for (int rr = 0; rr < THERMAL_ARRAY_ROWS; rr++){
    for (int cc = 0; cc < THERMAL_ARRAY_COLUMNS; cc++){
      int pixelTemp = int(thermalArray[rr][cc]);
      pixelTemp = constrain(pixelTemp, 0, 100);
      redComponent = map(pixelTemp, minTemp, maxTemp, 0, 8);
      blueComponent = map(pixelTemp, minTemp, maxTemp, 8, 0);
      falsePixelColor = redComponent << 8;
      falsePixelColor |= blueComponent;
      mappedPixelColors[rr][cc] = falsePixelColor;
    }
  }

  
}

void drawNewImage(){
  int x = 0;
  for (int ii = 0; ii < 16; ii++){ // row one
    strip.setPixelColor(ii, mappedPixelColors[0][ii]);
  }
  for (int ii = 31; ii > 15; ii--){ // row two    
    strip.setPixelColor(ii, mappedPixelColors[1][x]);
    //Serial.print("drawing line ");Serial.print(ii); Serial.print(" x = ");Serial.println(x);
    x++;
  }
  for (int ii = 32; ii < 48; ii++){ // row three
    strip.setPixelColor(ii, mappedPixelColors[2][ii - 32]);
  }
  x = 0;
  for (int ii = 63; ii > 47; ii--){ // row four   
    strip.setPixelColor(ii, mappedPixelColors[3][x]);
    x++;
  }
  strip.show();
}

