//INTEL Autonomous Sentry Turret by DJ Harrigan

#include <Wire.h>
#include <LIDARLite.h>
#include <Adafruit_PWMServoDriver.h>

Adafruit_PWMServoDriver pwm = Adafruit_PWMServoDriver();
LIDARLite lidarSensor;

#define PIN_LED_GREEN  2
#define PIN_LED_RED    3
#define PIN_SENSOR_PIR 4
#define PIN_RADIO_A    5
#define PIN_RADIO_B    6
#define PIN_RADIO_C    7
#define PIN_RADIO_D    8
#define PIN_TURRET     9
#define PIN_LASER      10
#define SERVO_INDEX   0
#define SERVO_PULSE_MIN 250
#define SERVO_PULSE_MAX 500
#define MAX_SHOTS     3

const int STATUS_ARMED = 0;
const int STATUS_DISARMED = 1;
const int STATUS_FIRING = 2;
const int STATUS_ASLEEP = 3;

boolean pirSensorState = false;
boolean radioAState = false;
boolean radioBState = false;
boolean radioCState = false;
boolean radioDState = false;

int shotCount = 0;
int turretPos = 250;
int turretDir = 1;
int distanceIndex = 0;
int knownDistances[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
int currentDistance = 0;
int deltaDistanceThreshold = 20;

int systemStatus = STATUS_ASLEEP;
int lastSystemStatus = 0;

unsigned long currentTime = 0;
unsigned long lastFiringTime = 0;
unsigned long lastMovementTime = 0;
unsigned long FIRING_TIME = 5000;
unsigned long MOVEMENT_TIME = 30;

void setup() {
  
  Serial.begin(9600);
  lidarSensor.begin();
  Serial.println("Intel AutoTurret");
  pwm.begin();
  pwm.setPWMFreq(60);
  pinMode(PIN_LED_GREEN, OUTPUT);
  pinMode(PIN_LED_RED, OUTPUT);
  pinMode(PIN_SENSOR_PIR, INPUT);
  pinMode(PIN_RADIO_A, INPUT);
  pinMode(PIN_RADIO_B, INPUT);
  pinMode(PIN_RADIO_C, INPUT);
  pinMode(PIN_RADIO_D, INPUT);
  pinMode(PIN_TURRET, OUTPUT);
  pinMode(PIN_LASER, OUTPUT);
  digitalWrite(13, HIGH);
  digitalWrite(PIN_TURRET, LOW);
  digitalWrite(PIN_LED_GREEN, LOW);
  digitalWrite(PIN_LED_RED, LOW);
  digitalWrite(PIN_LASER, LOW);
  pwm.setPWM(SERVO_INDEX, 0, turretPos);
  delay(1000);
  
}

void loop() {

    getInput();
    setSystemStatus();
    currentTime = millis();
    /*
    Serial.print("A ");Serial.println(radioAState);
    Serial.print("B ");Serial.println(radioBState);
    Serial.print("C ");Serial.println(radioCState);
    Serial.print("D ");Serial.println(radioDState);
    Serial.print("systemStatus ");Serial.println(systemStatus);
    Serial.print("lastSystemStatus ");Serial.println(lastSystemStatus);Serial.println();
    */
    switch (systemStatus){
      case STATUS_ARMED: // record sensor data a set intervals, check against known distances
      if (currentTime - lastMovementTime > MOVEMENT_TIME){
        lastMovementTime = currentTime;
        turretPos += turretDir;
        pwm.setPWM(SERVO_INDEX, 0, turretPos);
        if ((turretPos - 250) % 25 == 0){
          distanceIndex = map(turretPos, 250, 500, 0, 9);
          currentDistance = lidarSensor.distance();
          if (abs(currentDistance - knownDistances[distanceIndex]) > deltaDistanceThreshold){ // something has moved. shoot it
            lastSystemStatus = systemStatus;
            lastFiringTime = currentTime;
            systemStatus = STATUS_FIRING;
            Serial.println("mode FIRING");
            digitalWrite(PIN_TURRET, HIGH);
            break;
          }
          knownDistances[distanceIndex] = currentDistance;
          delay(300);
        }
        if (turretPos >= 500){
            turretPos = 500;
            turretDir *= -1;
         }
         if (turretPos < 250){
           turretPos = 250;
           turretDir *= -1;
         }
      }
      break;
      case STATUS_DISARMED: // record sensor data, but no firing
      if (currentTime - lastMovementTime > MOVEMENT_TIME){
         lastMovementTime = currentTime;
         turretPos += turretDir;
         pwm.setPWM(SERVO_INDEX, 0, turretPos);
        //Serial.print("turretPos: "); Serial.println(turretPos);
        if ((turretPos - 250) % 25 == 0){         
          distanceIndex = map(turretPos, 250, 500, 0, 9);
          //Serial.print("Distance Index: "); Serial.println(distanceIndex);
          //.print("knownDistances[distanceIndex]: "); Serial.println(knownDistances[distanceIndex]);
          currentDistance = lidarSensor.distance();
          knownDistances[distanceIndex] = currentDistance;
          delay(1000);
        }
        if (turretPos >= 500){
            turretPos = 500;
            turretDir *= -1;
         }
         if (turretPos < 250){
           turretPos = 250;
           turretDir *= -1;
         }
      } 
      break;
      case STATUS_FIRING:
        if (currentTime - lastFiringTime > FIRING_TIME){ // fire for a few seconds
          digitalWrite(PIN_TURRET, LOW);          
          //Serial.print("shot count "); Serial.println(shotCount);          
          digitalWrite(PIN_LED_GREEN, LOW);
          digitalWrite(PIN_LED_RED, LOW);
          digitalWrite(PIN_LASER, LOW);         
          Serial.print("currentTime-last: "); Serial.println(currentTime - lastFiringTime);
          lastFiringTime = currentTime;
          lastSystemStatus = systemStatus;
          systemStatus = STATUS_ASLEEP;
          Serial.println("mode ASLEEP");
          shotCount = 0;
          delay(3000);
        }
      break;
      case STATUS_ASLEEP:
        //Serial.println("mode ASLEEP");
        if (pirSensorState == true){
          lastSystemStatus = systemStatus;
          systemStatus = STATUS_DISARMED;
          Serial.println("mode DISARMED");
          digitalWrite(PIN_LED_GREEN, HIGH);
          digitalWrite(PIN_LED_RED, LOW);
          digitalWrite(PIN_LASER, HIGH);
          digitalWrite(PIN_TURRET, LOW);
        }
      break;
    }
    
}



void setSystemStatus(){

  if (radioAState == true && lastSystemStatus != systemStatus){
    lastSystemStatus = systemStatus;
    systemStatus = STATUS_ARMED;   
    Serial.println("mode ARMED");
    digitalWrite(PIN_LED_GREEN, LOW);
    digitalWrite(PIN_LED_RED, HIGH);
    digitalWrite(PIN_LASER, HIGH);
    delay(750);
  }
  if (radioBState == true && lastSystemStatus != systemStatus){
    lastSystemStatus = systemStatus;
    systemStatus = STATUS_DISARMED;
    Serial.println("mode DISARMED");
    digitalWrite(PIN_LED_GREEN, HIGH);
    digitalWrite(PIN_LED_RED, LOW);
    digitalWrite(PIN_LASER, HIGH);
    delay(750);
  }
  if (radioCState == true && lastSystemStatus != systemStatus){
    lastSystemStatus = systemStatus;
    lastFiringTime = currentTime;
    systemStatus = STATUS_FIRING;
    Serial.println("mode FIRING");
    digitalWrite(PIN_LED_GREEN, LOW);
    digitalWrite(PIN_LED_RED, HIGH);
    digitalWrite(PIN_TURRET, HIGH);
    digitalWrite(PIN_LASER, HIGH);
    delay(750); 
  }
  if (radioDState == true && lastSystemStatus != systemStatus){
    lastSystemStatus = systemStatus;
    systemStatus = STATUS_ASLEEP;
    Serial.println("mode ASLEEP");
    digitalWrite(PIN_LED_GREEN, LOW);
    digitalWrite(PIN_LED_RED, LOW);
    digitalWrite(PIN_LASER, LOW);
    delay(3000);
  }
}

void getInput(){

  pirSensorState = digitalRead(PIN_SENSOR_PIR);
  radioAState = digitalRead(PIN_RADIO_A);
  radioBState = digitalRead(PIN_RADIO_B);
  radioCState = digitalRead(PIN_RADIO_C);
  radioDState = digitalRead(PIN_RADIO_D);

}
