/* J Sensor
Developed from:
   http://www.arduino.cc/en/Tutorial/Knock

SD Audio and idea adapted from Kidu Drumkit
http://www.instructables.com/id/ELECTRONIC-DRUMnot-a-MIDI-sampler-aka-KIDU/

Midi code adapted from Midi Teensy usbMidi library

Button code adapted from http://www.arduino.cc/en/Tutorial/Button

Vastly modified into drum kit March 2015
by Rowan Cant 

For my nephew Jayden.

SD card Arduino connection
cs is 10 (ss pin on your arduino)
sck is 13
Mosi is 11 
Miso is 12

Mono Audio out on 9 @ Normal-Arduinos

Piezo pins are A0 to A7 each has a 1000k resister between the positive and negative
(ideally, this would be a 1mega ohm resistor, but this was the best I had.)
I board I am using is Arduino Pro Mini 5v 16MHz

MIDI out is connected to PWM pin 3

Buttons are on 7 & 8

Hat Pedal is in digital pin 5
*/

#include <SimpleSDAudio.h>
//#include <MIDI.h>

// introducing all the controls for the two buttons.
int Button1 = 8; int Button2 = 7; int B1State = 0; int B2State = 0; int lastB1State = 0; int lastB2State = 0;

int Mode = 0;

//introducing all the analog inputs.
int Snare = A0; int SnareHit = 0;

int Hhat = A1; int HhatHit = 0;

int HatPedal = 5; int HPState = 0; int prevHPState = 0;

int Tom1 = A2; int Tom1Hit = 0;

int Tom2 = A3; int Tom2Hit = 0;

int Crash = A6; int CrashHit = 0;

int Kick = A7; int KickHit = 0;

int Extra = A5; int ExtraHit = 0;

int Extra2 = A4; int Extra2Hit =0;

// This sets the arduino input level that the piezo's need to recieve.
int Threshold = 70;

void setup()

{ SdPlay.setSDCSPin(10); // Enable if your SD card CS-Pin is not at Pin 4... 
 SdPlay.init(SSDA_MODE_FULLRATE | SSDA_MODE_MONO | SSDA_MODE_AUTOWORKER);
 // MIDI.begin(3);//Sets Midi pin at pin 3
  pinMode(Button1, INPUT); pinMode(Button2, INPUT); pinMode(HatPedal, INPUT); //sets all buttons as input
}

void loop(void) {
//This is a debounce code for reading changes to buttons, it saves a lot of craziness!
prevHPState = digitalRead(HatPedal); lastB1State = digitalRead(Button1); lastB2State = digitalRead(Button2);

delay(5);

HPState = digitalRead(HatPedal); B1State = digitalRead(Button1); B2State = digitalRead(Button2);

//This sets the mode from the button presses, I have one button to go down a mode and one to go up a mode
if (lastB1State == LOW && B1State == HIGH){
Mode++;
}
if (lastB2State == LOW && B2State == HIGH){
Mode--;
}
//This makes sure the button presses don't go out of the range of modes that I am using.
Mode = constrain (Mode,1,6);

  SnareHit=analogRead(Snare);
  HhatHit=analogRead(Hhat);
  Tom1Hit=analogRead(Tom1);
  Tom2Hit=analogRead(Tom2);
  CrashHit=analogRead(Crash);
  KickHit=analogRead(Kick);
  HPState=digitalRead(HatPedal);
  

//—————————————————------------Mode 1 —————————————————------

if (Mode == 1)
{
  
  if (SnareHit>70)
  { SdPlay.setFile("1_snare.raw");  SdPlay.play();delay (5); }
  
  if (HhatHit>70 && HPState==HIGH)
  { SdPlay.setFile("1_chh.raw"); SdPlay.play(); delay (5);}
  
  if (HhatHit>70 && HPState==LOW)
  { SdPlay.setFile("1_ohh.raw"); SdPlay.play(); delay (5);}
  
  if (Tom1Hit>70)
  { SdPlay.setFile("1_tom1.raw"); SdPlay.play(); delay (5);}
  
  if (Tom2Hit>70)
  { SdPlay.setFile("1_tom2.raw"); SdPlay.play(); delay (5);}
  
  if (CrashHit>70)
  { SdPlay.setFile("1_cy.raw"); SdPlay.play(); delay (5);}
  
  if (KickHit>70)
  { SdPlay.setFile("1_kick.raw"); SdPlay.play(); delay (5);}
  
  if (ExtraHit>70)
  { SdPlay.setFile("1_xt.raw"); SdPlay.play(); delay (5);}
 
  if (Extra2Hit>70)
  { SdPlay.setFile("1_xt2.raw"); SdPlay.play(); delay (5);}
}

//—————————————————----      Mode 2           —————————————————

if (Mode == 2)
{
  
  if (SnareHit>100)
  { SdPlay.setFile("2_snare.raw"); SdPlay.play(); delay (5);}
  
  if (HhatHit>100 && HPState==HIGH)
  { SdPlay.setFile("2_chh.raw"); SdPlay.play(); delay (5);}
  
  if (HhatHit>100 && HPState==LOW)
  { SdPlay.setFile("2_ohh.raw"); SdPlay.play(); delay (5);}
  
  if (Tom1Hit>100)
  { SdPlay.setFile("2_tom1.raw"); SdPlay.play(); delay (5);}
  
  if (Tom2Hit>100)
  { SdPlay.setFile("2_tom2.raw"); SdPlay.play(); delay (5);}
  
  if (CrashHit>100)
  { SdPlay.setFile("2_cy.raw"); SdPlay.play(); delay (5);}
  
  if (KickHit>70)
  { SdPlay.setFile("2_kick.raw"); SdPlay.play(); delay (5);}
  
  if (ExtraHit>70)
  { SdPlay.setFile("2_xt.raw"); SdPlay.play(); delay (5);}
 
  if (Extra2Hit>70)
  { SdPlay.setFile("2_xt2.raw"); SdPlay.play(); delay (5);}
  
}


//—————————————————          Mode 3            —————————————————

if (Mode == 3)
{
  
  if (SnareHit>100)
  { SdPlay.setFile("3_snare.raw"); SdPlay.play();  delay (5);}
  
  if (HhatHit>100 && HPState==HIGH)
  { SdPlay.setFile("3_chh.raw"); SdPlay.play(); delay (5);}
  
  if (HhatHit>100 && HPState==LOW)
  { SdPlay.setFile("3_ohh.raw");  SdPlay.play(); delay (5);}
  
  if (Tom1Hit>100)
  { SdPlay.setFile("3_tom1.raw"); SdPlay.play();  delay (5);}
  
  if (Tom2Hit>100)
  { SdPlay.setFile("3_tom2.raw"); SdPlay.play();  delay (5);}
  
  if (CrashHit>100)
  { SdPlay.setFile("3_cy.raw"); SdPlay.play();  delay (5);}
  
  if (KickHit>70)
  { SdPlay.setFile("3_kick.raw"); SdPlay.play(); delay (5);}
  
  if (ExtraHit>70)
  { SdPlay.setFile("3_xt.raw"); SdPlay.play(); delay (5);}
 
  if (Extra2Hit>70)
  { SdPlay.setFile("3_xt2.raw"); SdPlay.play(); delay (5);}
}


//—————————————————Mode 4 —————————————————

if (Mode == 4)
{
  
  if (SnareHit>100)
  { SdPlay.setFile("4_snare.raw"); SdPlay.play(); delay (5);}
  
  if (HhatHit>100 && HPState==HIGH)
  { SdPlay.setFile("4_chh.raw"); SdPlay.play(); delay (5);}
  
  if (HhatHit>100 && HPState==LOW)
  { SdPlay.setFile("4_ohh.raw"); SdPlay.play(); delay (5);}
  
  if (Tom1Hit>100)
  { SdPlay.setFile("4_tom1.raw"); SdPlay.play(); delay (5);}
  
  if (Tom2Hit>100)
  { SdPlay.setFile("4_tom2.raw"); SdPlay.play(); delay (5);}
  
  if (CrashHit>100)
  { SdPlay.setFile("4_cy.raw"); SdPlay.play(); delay (5);}
  
  if (KickHit>70)
  { SdPlay.setFile("4_kick.raw"); SdPlay.play(); delay (5);}
  
  if (ExtraHit>70)
  { SdPlay.setFile("4_xt.raw"); SdPlay.play(); delay (5);}
 
  if (Extra2Hit>70)
  { SdPlay.setFile("4_xt2.raw"); SdPlay.play(); delay (5);}
}

//—————————————————Mode 5 —————————————————

if (Mode == 5)
{
  
  if (SnareHit>100)
  { SdPlay.setFile("5_snare.raw"); SdPlay.play();  delay (5);}
  
  if (HhatHit>100 && HPState==HIGH)
  { SdPlay.setFile("5_chh.raw");  SdPlay.play(); delay (5);}
  
  if (HhatHit>100 && HPState==LOW)
  { SdPlay.setFile("5_chh.raw"); SdPlay.play(); delay (5);}
  
  if (Tom1Hit>100)
  { SdPlay.setFile("5_tom1.raw"); SdPlay.play(); delay (5);}
  
  if (Tom2Hit>100)
  { SdPlay.setFile("5_tom2.raw");  SdPlay.play();  delay (5);}
  
  if (CrashHit>100)
  { SdPlay.setFile("5_cy.raw"); SdPlay.play(); delay (5);}
  
  if (KickHit>70)
  { SdPlay.setFile("5_kick.raw"); SdPlay.play(); delay (5);}
  
  if (ExtraHit>70)
  { SdPlay.setFile("5_xt.raw"); SdPlay.play(); delay (5);}
 
  if (Extra2Hit>70)
  { SdPlay.setFile("5_xt2.raw"); SdPlay.play(); delay (5);}
  
}

/*
//—————————————————Mode 6 MIDI SIGNALS—————————————————
//Midi had to be a seperate mode as it slows down the 

if (Mode == 6)
{ if (KickHit >= 100) { int tempAnalogInMap = map(KickHit,0,1023,0,127);  
MIDI.sendNoteOn(36, tempAnalogInMap, 1);  //(note, velocity, channel) 36 is kick 
delay (tempAnalogInMap); MIDI.sendNoteOff(36, 0, 1);}
  

  //------------------------------------Floor Tom---------------------------------------------
  // if the sensor reading is greater than the threshold:
 if (Tom2Hit >= 100) { int tempAnalogInMap2 = map(Tom2Hit,0,1023,0,127);  
 MIDI.sendNoteOn(43, tempAnalogInMap2, 1);  //(note, velocity, channel) 36 is kick 
delay (tempAnalogInMap2); MIDI.sendNoteOff(43, 0, 1);  }
  
 //---------------------------------------Tom------------------------------------------
  // if the sensor reading is greater than the threshold:
 if (Tom1Hit >= 100) { int tempAnalogInMap3 = map(Tom1Hit,0,1023,0,127);  
 MIDI.sendNoteOn(47, tempAnalogInMap3, 1);  //(note, velocity, channel) 36 is kick 
delay (tempAnalogInMap3); MIDI.sendNoteOff(47, 0, 1); }  
  
   //---------------------------------------Hi Hat------------------------------------------
   //This one is a tricky one, because we want the pedal to make a sound and the sounds to change based on the pedal.
  // if the sensor reading is greater than the threshold:
 if (HhatHit >= 100) { int tempAnalogInMap4 = map(HhatHit,0,1023,0,127); 
//CLOSED
if (HPState==HIGH);{ MIDI.sendNoteOn(42, tempAnalogInMap4, 1);  //(note, velocity, channel) 36 is kick 
delay (tempAnalogInMap4); MIDI.sendNoteOff(42, 0, 1);  }
//--OPEN
if (HPState==LOW);{ MIDI.sendNoteOn(46, tempAnalogInMap4, 1);  //(note, velocity, channel) 36 is kick 
delay (tempAnalogInMap4); MIDI.sendNoteOff(46, 0, 1);  } }  
//PEDAL GOES DOWN 
  if (HPState==HIGH && prevHPState==LOW);{MIDI.sendNoteOn(44, 70, 1);  //(note, velocity, channel) 36 is kick 
delay (80); MIDI.sendNoteOff(44, 0, 1);  }

  
     //--------------------------------------Crash------------------------------------------
  // if the sensor reading is greater than the threshold:
if (CrashHit >= 100) { int tempAnalogInMap5 = map(CrashHit,0,1023,0,127);  
MIDI.sendNoteOn(49, tempAnalogInMap5, 1);  //(note, velocity, channel) 36 is kick 
delay (tempAnalogInMap5); MIDI.sendNoteOff(49, 0, 1);  }
  
    //---------------------------------------Snare------------------------------------------
  // if the sensor reading is greater than the threshold:
if (SnareHit >= 100) { int tempAnalogInMap6 = map(SnareHit,0,1023,0,127);  
MIDI.sendNoteOn(40, tempAnalogInMap6, 1);  //(note, velocity, channel) 36 is kick 
delay (tempAnalogInMap6); MIDI.sendNoteOff(40, 0, 1);  }  

       //---------------------------------------Extra------------------------------------------
  // if the sensor reading is greater than the threshold:
if (ExtraHit >= 100) { int tempAnalogInMap7 = map(ExtraHit,0,1023,0,127);  
MIDI.sendNoteOn(37, tempAnalogInMap7, 1);  //(note, velocity, channel) 36 is kick 
delay (tempAnalogInMap7); MIDI.sendNoteOff(37, 0, 1);  }  
 
        //---------------------------------------Extra2------------------------------------------
  // if the sensor reading is greater than the threshold:
if (ExtraHit >= 100) { int tempAnalogInMap8 = map(ExtraHit,0,1023,0,127);  
MIDI.sendNoteOn(51, tempAnalogInMap8, 1);  //(note, velocity, channel) 36 is kick 
delay (tempAnalogInMap8);MIDI.sendNoteOff(51, 0, 1);   }

}
*/
}

