/* o-o o-o o-o o-o o-o o-o o-o o-o o-o o-o o-o o-o o-o o-o o-o o-o o-o o-o o-o                                                              

o  o o-O-o   o-o o  o o      O  o   o o--o      o   o  o-o    0   
| /    |    /    | /  |     / \ |\ /| |   |     |   | o  /o  /|   
OO     |   O     OO   |    o---o| O | O--o      o   o | / | o |   
| \    |    \    | \  |    |   ||   | |          \ /  o/  o   |   
o  o o-O-o   o-o o  o O---oo   oo   o o           o    o-o  o-o-o 
                                                                  
BY ARNAUD ATCHIMON // WWW.NEOFUTURISM.NET
o-o o-o o-o o-o o-o o-o o-o o-o o-o o-o o-o o-o o-o o-o o-o o-o o-o o-o o-o */


#include <Adafruit_NeoPixel.h>
#include <elapsedMillis.h>

//NEOPIXELS
#define PIN 5  // NEOPIXEL INPUT
#define PIXEL 12  //NUMBER OF PIXELS
#define BRIGHTNESS 200 // SET BRIGHTNESS 
Adafruit_NeoPixel strip = Adafruit_NeoPixel(PIXEL, PIN, NEO_GRB + NEO_KHZ800);

//RADAR PIN
int  detectPin = 8;
bool detect    = false;

//CONTROL LED USE THIS IF YOU DON'T HAVE NEOPIXELS
int  led       = 13;
bool lightOn = false;

//TIMING
elapsedMillis timeElapsed; //DECLARE IT
unsigned int interval = 17000; // 1000ms = 1SEC INPUT YOUR DELAY HERE


//CHOOSE A COLOR YOU LIKE
uint8_t i = 0;
uint32_t white = strip.Color(255, 255, 255);
uint32_t white_light = strip.Color(127, 127, 127);
uint32_t red = strip.Color(255, 0, 0);
uint32_t red_half = strip.Color(127, 0, 0);
uint32_t green = strip.Color(0, 255, 0);
uint32_t green_light = strip.Color(50, 255, 50);
uint32_t green_half = strip.Color(0, 100, 0);
uint32_t blue = strip.Color(0, 0, 255);
uint32_t blue_light = strip.Color(0, 0, 150);
uint32_t red_orange = strip.Color(255, 50, 0);
uint32_t orange = strip.Color(255, 125, 0);
uint32_t orange_light = strip.Color(127, 75, 0);
uint32_t yellow = strip.Color(255, 255, 0);
uint32_t yellow_light = strip.Color(127, 127, 0);
uint32_t yellow_green = strip.Color(125, 255, 0);
uint32_t turquoise = strip.Color(0, 255, 100);
uint32_t cyan = strip.Color(0, 255, 255);
uint32_t cyan_light = strip.Color(0, 127, 127);
uint32_t cyan_blue = strip.Color(0, 100, 255);
uint32_t violet = strip.Color(100, 0, 255);
uint32_t pinky = strip.Color(252, 128, 128);
uint32_t magenta = strip.Color(255, 0, 255);
uint32_t raspberry = strip.Color(255, 0, 100);


//TEST YOUR NEOPIXELS
void ledDemo() { // USE THIS TO TEST YOUR NEOPIXELS
  simplewave_backward(i, 45);
  simplewave_backward(red, 45);
  simplewave_backward(green, 45);
  simplewave_backward(blue, 45);
  simplewave_forward(red, 45);
  simplewave_forward(green, 45);
  simplewave_forward(blue, 45);
  simplewave_forward(i, 45);
  strip.show();
}

void setup() {
  Serial.begin(115200);
  Serial.println(" KICKLAMP V01");
  //RADAR
  pinMode (detectPin, INPUT);
  //CONTROL LED
  pinMode (led, OUTPUT);
  //NEOPIXEL
  strip.setBrightness(BRIGHTNESS);
  strip.begin();
  strip.show(); // Initialize all pixels to 'off'
  //ledDemo();

}//END SETUP
 

void loop() {
  detect = digitalRead(detectPin);
  //Serial.println(timeElapsed); // PRINT TIMING // COMMENT IT IF NOT NEEDED

  if (detect == true) {
    digitalWrite(led, HIGH);
    lightOn = true;
    Serial.println(" bloop "); //GETTING A BLOOP WHEN YOU'RE DETECTED
  }
  if (lightOn == true) {
    simplewave_forward(white, 25);
  }


  if (detect == false) {
    digitalWrite(led, LOW);
    Serial.println("  ");// CLEAN SERIAL // COMMENT IT IF NOT NEEDED
    lightOn = false;
  }
  if (lightOn == false) {
    if (timeElapsed > interval)
    {
      simplewave_backward(i, 15);
      timeElapsed = 0;  // RESET COUNTER
    }
  }

  delay(100);
}//END LOOP


//BACKWARD AND FORWARD NEOPIXEL PROGRESSION 
void simplewave_forward(uint32_t pixelColor, int wait)
{
  uint8_t r = (uint8_t)(pixelColor >> 16);
  uint8_t g = (uint8_t)(pixelColor >> 8);
  uint8_t b = (uint8_t)pixelColor;

  for (uint16_t i = 0; i < strip.numPixels(); i++)
  {
    strip.setPixelColor(i, r, g, b);
    strip.show();
    delay(wait);
  }
}//SIMPLE FORWARD LOOP


void simplewave_backward(uint32_t pixelColor, int wait)
{
  uint8_t r = (uint8_t)(pixelColor >> 16);
  uint8_t g = (uint8_t)(pixelColor >> 8);
  uint8_t b = (uint8_t)pixelColor;
  uint16_t i = strip.numPixels();

  for (i; i > 0; i--)
  {
    strip.setPixelColor(i - 1, r, g, b);
    strip.show();
    delay(wait);
  }
}//SIMPLE BACKWARD LOOP

 
