/* Dual scrolling 'terminal' LCD displays */
/* Using I2C adaptors. These are either at address 0x3F or 0x27. For the ones at 3F, just below the pot are three links A0, A1 and A2. Solder a bridge across A0 and this changes the address from 3F to 3E */
/* To use two boards on the same I2C bus, either build a 'double adaptor', or on some boards there are two pins that are SCL and two that are SDA. */


/*
Demonstration sketch for PCF8574T I2C LCD Backpack
 need to recheck these links from time to time, the correct one is a .rar file not a .zip file

http://tronixlabs.com/display/lcd/serial-i2c-backpack-for-hd44780-compatible-lcd-modules/
Uses library from https://bitbucket.org/fmalpartida/new-liquidcrystal/downloads
GNU General Public License, version 3 (GPL-3.0)
altsoftserial is here https://www.pjrc.com/teensy/td_libs_AltSoftSerial.html
unzip and put both folders in the c:\programfiles(x86)\arduino\libraries folder
*/

#include <Wire.h>
#include <LiquidCrystal_I2C.h> // I2C driver, only uses two pins

LiquidCrystal_I2C lcd1(0x3F,20,4);  // NB  ** IMPORTANT ** set the LCD address to 0x27 BUT some i2c board are at address 3F not 27. Early boards 27, later are 3F. There is a scanner here https://forum.arduino.cc/index.php?topic=128635.0
LiquidCrystal_I2C lcd2(0x3E,20,4);  // NB  ** IMPORTANT ** set the LCD address to 0x27 BUT some i2c board are at address 3F not 27. Early boards 27, later are 3F. There is a scanner here https://forum.arduino.cc/index.php?topic=128635.0

char screen1[80]; // screen buffer
int col1 = 0;     // 0 to 19 column number for screen 1
char screen2[80]; 
int col2 = 0; 


void setup()
{
  lcd1.init();
  lcd1.backlight();
  lcd2.init();
  lcd2.backlight();
  cls(1); // clear screen
  cls(2);
  printLnString(F("Hello World!"),1);
  printLnString(F("Screen One"),1);
  printLnString(F("Hello World!"),2);
  printLnString(F("Screen Two"),2);
}

void loop()
{

}


void cls(byte d)
{
  int i;
  for (i=0;i<4;i++) {
    printLnString("",d);
  }
}

void printChar(char c, byte d)
{
  if (d == 1) {
    if ((c>31) && (c<127))
    {
      screen1[col1+60] = c;
      lcd1.print(c);
      col1 = col1+1;
    }  
    if (col1 > 19) // end of the line
    {
      linefeed(1); // scroll up a line if got to the end of the line
      refreshScreen(1);
      col1 = 0;
    }
    if (c == 10)
    {
      linefeed(1); // scroll up a line if got to the end of the line
      refreshScreen(1); // but col1 stays the same
    }
    if (c==13)
    {
      col1=0; // carriage return, but don't scroll
      lcd1.setCursor(0,3); // back to beginning of 4th line  
    }  
  }else{ // same routines, for second screen
    if ((c>31) && (c<127))
    {
      screen2[col2+60] = c;
      lcd2.print(c);
      col2 = col2+1;
    }  
    if (col2 > 19) // end of the line
    {
      linefeed(2); // scroll up a line if got to the end of the line
      refreshScreen(2);
      col2 = 0;
    }
    if (c == 10)
    {
      linefeed(2); // scroll up a line if got to the end of the line
      refreshScreen(2); // 
    }
    if (c==13)
    {
      col2=0; // carriage return, but don't scroll
      lcd2.setCursor(0,3); // back to beginning of 4th line  
    }  
  }  
  
}  

void printString(String s, byte d)
{
  int i;
  int j;
  j = s.length();
  for (i=0;i<j;i++)
  {
    printChar(s.charAt(i),d);
  }  
}  

void printStringLn(String s,byte d)
{
  printString(s,d);
  printChar(13,d);
  printChar(10,d); 
}  

void printLnString(String s,byte d) // reverse of above, print crlf, then print the line, means has 4 lines visible on a 20x4 display at all times
{
  printChar(13,d);
  printChar(10,d); 
  printString(s,d);
}  

void linefeed(byte d) // scroll up a line
{
  int i;
  if (d == 1) {
    for(i=0;i<20;i++) // scroll up a line
      {
        screen1[i]    = screen1[i+20]; // move up a line
        screen1[i+20] = screen1[i+40]; // move up a line
        screen1[i+40] = screen1[i+60]; // move up a line
        screen1[i+60] = 32; // make bottom line all blank
      }  
      col1 = 0; // reset column to zero
  }else{
     for(i=0;i<20;i++) // scroll up a line
      {
        screen2[i]    = screen2[i+20]; // move up a line
        screen2[i+20] = screen2[i+40]; // move up a line
        screen2[i+40] = screen2[i+60]; // move up a line
        screen2[i+60] = 32; // make bottom line all blank
      }  
      col2 = 0; // reset column to zero
  }
}    

void refreshScreen(byte d) // d = 1 or 2 for each screen
{
  int i;
  int j;
  int k;
  if (d == 1) {
    for (j=0;j<4;j++) {
      lcd1.setCursor (0,j);        // go to start of line
      k = j * 20;
      for(i=0;i<20;i++)
      {
        lcd1.print(screen1[i+k]);
      }
    }
    lcd1.setCursor(0,3); // back to beginning of 4th line 
  }else{
    for (j=0;j<4;j++) {
      lcd2.setCursor (0,j);        // go to start of line
      k = j * 20;
      for(i=0;i<20;i++)
      {
        lcd2.print(screen2[i+k]);
      }
    }
    lcd2.setCursor(0,3); // back to beginning of 4th line  
  }
}

 // ****************** end LCD routines *******************
 
