/* pong using 7x5 led matrix
 * --------------
 *
 *Plays pong or displays one of 2 messages depending on the input
 * for more go to http://www.instructables.com/id/EWTZ7SGFC2BTTMS/
 *
 * by: Jonathan Hodgins
 * copyleft 2008
 */

//game variables 
byte p1X=0,p2X=6;//the player 1 & 2 x locations
double p1Y,p2Y;//y locations, note the type
double ballX=3, ballY=2,startBallY=2;//the position of the ball
double ballVX=0.5, ballVY = 0.5, startBallVY=0.5;//velocity of the ball
bool numPlayers=1;//number of players (the inital value dosn't matter)
byte score1,score2;//the scores
const int paddleTime=250;//the length the paddle is up after a button push
long tempClock;//used to store when the paddles were first shown, to calculate when to turn them off
long moveDelay=500, startingMoveDelay=500;//how fast (or slow) the code executes
double p2Speed=0.8;//how fast the AI moves

//display variables(not mutual with pong)
int displayTime=650;//how long between switching letters

//output variables
int pinx[7]={
  5,6,7,8,10,11,12};//the coulumns
int piny[5]={
  0,1,2,3,4};//the rows
const byte maxX=6,maxY=4;//the max values for each dimension (starting at 0)
bool ledState[maxX+1][maxY+1];//an array to store the output
long clock;//use to time the output

//input variables
int pushedValue = 512;//the trigger value for the analog inputs, because some are used as digital
bool sw1=false,sw2=false,sw3=false;//the switch values
bool oldSw1=false,oldSw2=false,oldSw3=false;//the old switch values(for comparison purposes)
byte sw1Pin=5,sw2Pin=4,sw3Pin=3;//the switch pins
byte pot1=0,pot2=0, potPin1=2, potPin2=1;//potentiometer variables

//sound variables
byte speakerPin=9;
byte p1Hit=260, p2Hit=290, wallHit=330;//these number are the frequency in Hz
byte current=0;//current sound playing,  0 is off

void setup(){
  for (int i=0;i<=maxX;i++)//set the pin states
    pinMode(pinx[i], OUTPUT);
  for (int i=0;i<=maxY;i++)
    pinMode(piny[i], OUTPUT);
  pinMode(speakerPin, OUTPUT);
  tempClock=millis();
}


void loop()
{
  getInput();

  if(sw1==false)
  {
    cls();
    msg1();
  }
  else
  {
    cls();
    pong();
  }

  if(sw3)//changes the diaplay speed
    display(50);
  else
    display(100);

}

/*msg1 sets the output to display 2 letters at a time, if you
wish to change this call the letteryouwant(the x position on the screen);
in the appropriate spot. by the way, ERTW means Engineers Rule The World*/
void msg1()
{
  current=0;//reset the sound
  if(sw1!=oldSw1)//signals it just started
  {
    tempClock=millis();//reset the sequence
  }
  if(sw2)
    if(millis()-tempClock<=displayTime*2)
    {
      u(0);
      o(4);
    }
    else if(millis()-tempClock>=displayTime*2 && millis()-tempClock<=displayTime*4)
    {
      i(0);
      t(4);
    }
    else if(millis()-tempClock>=displayTime*5)//reset the sequence
    {
      tempClock=millis();
    }
    else
    {
    }
  else
    if(millis()-tempClock<=displayTime*2)
    {
      e(0);
      r(4);
    }
    else if(millis()-tempClock>=displayTime*2 && millis()-tempClock<=displayTime*4)
    {
      t(0);
      w(4);
    }
    else if(millis()-tempClock>=displayTime*5)//reset
    {
      tempClock=millis();
    }
}


/*
Pong does as you might expect, plays pong based on the pot inputs
It should also be noted that the ball values and player Y values
are analog vaues(well, at least decimal values)
this is because the display is too small to make an accurate game
of pong with whole numbers
*/
void pong()
{
  if(sw1!=oldSw1)//signals it just started and to reset the values
  {
    score1=0;
    score2=0;
    ballX=1;
    ballVX=abs(ballVX);
    ballVY=startBallVY;
    moveDelay=startingMoveDelay;
    tempClock=millis();
    if(sw2==true)//change the number of players
      numPlayers=0;//actually 1 player
    else
      numPlayers=1;//actually 2 players
  }
  if(sw2!=oldSw2)//signals it just switched number of players and to reset
  {
    cls();
    current=0;//reset the sound
    if(sw2==true)//change the number of players
    {
      one(0);
      p(4);
      numPlayers=0;//actually 1 player
    }
    else
    {
      two(0);
      p(4);
      numPlayers=1;//actually 2 players
    }
    score1=0;
    score2=0;
    display(900);
  }
  else//the main program
  {
    cls();
    current=0;//reset the sound
    p1Y=3-(analogRead(potPin1)/256);
    if(numPlayers==1)
      p2Y=3-(analogRead(potPin2)/256);

    if(millis()-tempClock>=moveDelay)//move
    {
      if(numPlayers==0)//controls the computer player
      {
        if(ballY>doubleToByte(p2Y+1))
          p2Y+=p2Speed;
        if(ballY<doubleToByte(p2Y))
          p2Y-=p2Speed;
      }

      if(doubleToByte(ballX+0.5)==p1X+1 && (doubleToByte(ballY)==p1Y||doubleToByte(ballY)==p1Y+1))// bounce the ball
      {
        current=p1Hit;//play a bounce sound
        if(doubleToByte(ballY)==p1Y)//deflect the ball
          ballVY-=0.2;
        else if(doubleToByte(ballY)==p1Y+1)//deflect it the other way
          ballVY+=0.2;

        ballVX=abs(ballVX);
        if (moveDelay>10)
          moveDelay-=10;
      }
      if(doubleToByte(ballX-0.5)==p2X-1 && (doubleToByte(ballY)==p2Y||doubleToByte(ballY)==p2Y+1))// bounce the ball
      {
        current=p2Hit;
        if(doubleToByte(ballY)==p2Y)
          ballVY-=0.2;
        else if(doubleToByte(ballY)==p2Y+1)
          ballVY+=0.2;
        ballVX=-abs(ballVX);// bounce the ball
        if (moveDelay>10)
          moveDelay-=10;
      }

      ballX+=ballVX;//move the ball
      ballY+=ballVY;

      if(ballY<0||ballY-0.5>maxY)//bounce it off the wall
      {
        current=wallHit;
        ballVY=-ballVY;
        ballY+=ballVY;
      }

      if(ballX<1 || ballX>=maxX)//if someone scored
      {
        cls();
        current=0;//reset the sound
        if(ballX>=maxX)//if it was player 1
        {
          score1++;
          ballX=1;
          ballVX=abs(ballVX);
          ballVY=startBallVY;
          ballY=startBallY;
          moveDelay=startingMoveDelay;
        }
        else if(ballX<1)//or player 2
        {
          score2++;
          ballX=5;
          ballVX=-abs(ballVX);
          ballVY=startBallVY;
          moveDelay=startingMoveDelay;
        }
        cls();//display the current score
        numSet(score1,0);
        numSet(score2,4);
        display(2000);
        if(score1>=9 || score2>=9)// if someone won
        {
          cls();
          p(0);
          if(score1>=9)
            one(4-2);
          if(score2>=9)
            two(4);
          display(2000);
          cls();
          w(0);
          ledState[3][1]=HIGH;
          ledState[3][2]=HIGH;
          ledState[3][3]=HIGH;
          ledState[3][4]=HIGH;
          n(4);
          display(3000);
          cls();
          score1=0;
          score2=0;
        }
        cls();
        display(600);
      }

      if(moveDelay>=8)
        moveDelay-=8;

    }

    //generate the output
    ledState[p1X][doubleToByte(p1Y)]=HIGH;
    ledState[p1X][doubleToByte(p1Y+1)]=HIGH;

    ledState[p2X][doubleToByte(p2Y)]=HIGH;
    ledState[p2X][doubleToByte(p2Y+1)]=HIGH;

    ledState[doubleToByte(ballX)][doubleToByte(ballY)]=HIGH;//display the ball
  }
}

//converts a double type to byte type
byte doubleToByte(double num)
{
  return num;
}

//retrives the input from the switches and pots
void getInput()
{
  oldSw1=sw1;
  oldSw2=sw2;
  oldSw3=sw3;
  if (analogRead(sw1Pin)>pushedValue)
    sw1=HIGH;
  else
    sw1=LOW;
  if (analogRead(sw2Pin)>pushedValue)
    sw2=HIGH;
  else
    sw2=LOW;
  if (analogRead(sw3Pin)>pushedValue)
    sw3=HIGH;
  else
    sw3=LOW;

  pot1=analogRead(potPin1);
  pot2=analogRead(potPin2);
}

//clear the output array, not to be confused wit hthe actual keyword cls in some languages
void cls()
{
  for (int i=0;i<=maxX;i++)
    for (int j=0;j<=maxY;j++)
      ledState[i][j]=LOW; 
}

//displays the output on the screen for delay_ms
void display(int delay_ms)
{
  clock = millis();
  while (millis()-clock < delay_ms)
  {
    for (int y=0;y<5;y++)
    {
      for (int x=0;x<7;x++)
        digitalWrite(pinx[x], ledState[x][y]);
      digitalWrite(piny[y],LOW);
      delayMicroseconds(200);
      //generate the sound
      if(current>0)
        if(millis()%(1000/current)<=1)
          digitalWrite(speakerPin,HIGH);
        else
          digitalWrite(speakerPin,LOW);
      digitalWrite(piny[y],HIGH);
    }
  }
  digitalWrite(speakerPin,LOW);
  current=0;
}

// an easier way to set the numbers on the clock
//@num the number to display
//@ x the location to display num
void numSet(int num,int x)
{
  if(num==0)
    zero(x);
  else if(num==1)
    one(x);
  else if(num==2)
    two(x);
  else if(num==3)
    three(x);
  else if(num==4)
    four(x);
  else if(num==5)
    five(x);
  else if(num==6)
    six(x);
  else if(num==7)
    seven(x);
  else if(num==8)
    eight(x);
  else if(num==9)
    nine(x);
  else
    ledState[2][x+1]=HIGH;
}

//from here on it is just code to draw numbers and letters at any given x location
void one(int x)
{
  ledState[x+2][0]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x+2][4]=HIGH;
}
void two(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+1][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void three(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+1][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void four(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x+2][4]=HIGH;
}
void five(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+1][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void six(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+1][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void seven(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x+2][4]=HIGH;
}
void eight(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+1][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void nine(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x+2][4]=HIGH;
}
void zero(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+1][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void a(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void b(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+1][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void c(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+1][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void d(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+1][4]=HIGH;
}
void e(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+1][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void f(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x][4]=HIGH;
}
void g(int x)
{
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x+1][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void h(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void i(int x)
{
  ledState[x+1][0]=HIGH;
  ledState[x+1][1]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+1][3]=HIGH;
  ledState[x+1][4]=HIGH;
}
void j(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x+1][1]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+1][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+1][4]=HIGH;
}
void k(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void l(int x)
{
  ledState[x][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+1][4]=HIGH;
}
void m(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+1][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void n(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+1][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void o(int x)
{
  ledState[x+1][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x+1][4]=HIGH;
}
void p(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x][4]=HIGH;
}
void q(int x)
{
  ledState[x+1][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x+1][3]=HIGH;
  ledState[x+2][4]=HIGH;
}
void r(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void s(int x)
{
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+1][4]=HIGH;
}
void t(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x+1][1]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+1][3]=HIGH;
  ledState[x+1][4]=HIGH;
}
void u(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+1][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void v(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x+1][3]=HIGH;
  ledState[x+1][4]=HIGH;
}
void w(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x][2]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+2][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+1][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x+1][4]=HIGH;
}
void x(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x+2][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
void y(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x][1]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x+1][3]=HIGH;
  ledState[x+1][4]=HIGH;
}
void z(int x)
{
  ledState[x][0]=HIGH;
  ledState[x+1][0]=HIGH;
  ledState[x+2][0]=HIGH;
  ledState[x+2][1]=HIGH;
  ledState[x+1][2]=HIGH;
  ledState[x][3]=HIGH;
  ledState[x][4]=HIGH;
  ledState[x+1][4]=HIGH;
  ledState[x+2][4]=HIGH;
}
