// This is the Relay sketch to decode 2 more signals and drive external circuitry
// provides a pwm signal to the lights for variable brightness using a re-wired channel on the transmitter (used a pitch knob connected to an unused left/right stick)
// the relay pin drives a 60 amp relay which the power to the motor-controller runs through. the relay should be normally-open, so when power or signal is lost, it disconnects the power to the motor-controller.
// JDW 2010
// 

int relay_Pin = 6; // relay ouput pin
int lights_Pin = 9; // lights pwm output pin

int update = 100; // time to wait between updating with pulseIn. 100milliseconds yields about 10 updates per second resolution (not really adequate for motor-control) - use other code from main processor for motor control.

int ledPin1 = 12; // led indicator lights
int ledPin2 = 13;

int ppm1 = 4;  // input pins
int ppm2 = 2; 

unsigned int ppm1_val;
unsigned int ppm2_val;

unsigned int relay_val;
unsigned int lights_val;
int lights_pwm;

void setup() {

  Serial.begin(9600);

  //motor1 pins
  pinMode(relay_Pin, OUTPUT);
  pinMode(lights_Pin, OUTPUT);

  //led's
  pinMode(ledPin1, OUTPUT);
  pinMode(ledPin2, OUTPUT);

  //PPM inputs from RC receiver
  pinMode(ppm1, INPUT); 
  pinMode(ppm2, INPUT);	

  digitalWrite(relay_Pin, LOW);
  digitalWrite(lights_Pin, LOW);

}

void pulse() {

  relay_val = pulseIn(ppm1, HIGH, 20000);
  lights_val = pulseIn(ppm2, HIGH, 20000);
}

void loop() {

  pulse();

  // check relay value and turn relay on or off
  if (relay_val < 1800 || relay_val > 2000) {
    digitalWrite(relay_Pin, LOW); 
    digitalWrite(ledPin1, HIGH);
  }
  else {
    digitalWrite(relay_Pin, HIGH);
    digitalWrite(ledPin1, LOW);
  }
  
  lights_pwm = map(constrain(lights_val, 600, 2400), 1100, 1875, 0, 255); 
  constrain(lights_pwm, 0, 255);  
  
  if (lights_pwm < 0) {
    lights_pwm = 0; 
  }
  if (lights_pwm > 255) {
    lights_pwm = 255; 
  }

  // check lights value and turn lights on or off 
  if (lights_pwm < 30) {
    digitalWrite(lights_Pin, LOW); 
    digitalWrite(ledPin2, HIGH);
  }
  else {
    analogWrite(lights_Pin, lights_pwm);
    digitalWrite(ledPin2, LOW);
  }


  Serial.print(" Relay:  ");
  Serial.print(relay_val);
  Serial.print("  ");
  Serial.print(" Lights:  ");
  Serial.print(lights_val);
  Serial.print("  ");
  Serial.print(" Lights_pwm:  ");
  Serial.print(lights_pwm);
  Serial.println("  ");
  
  delay(update);

}
