package com.example.germt.autojoystick;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Message;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import java.io.*;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;

/**
 * Created by germt on 17.02.2018.
 */

public class TCPClient {

    public static final String HNDLKEY = "SRV_MSG";//Key, which identifies the message from toy car
    public static final String SKT_ERR = "skt_error";//error creating a socket
    public static final String SKT_RD_ERR = "skt_read_error";//error reading data from the socket
    public static final String NOCONNTOMYWIFI = "no_conn_mywifi";//no connection to the required WiFi network

    //connection point
    private String MYWIFISSID;
    private String SRVIP;
    private int SRVPRT;
    //message line from the server
    private String mSrvMsg;
    //connection flag
    private boolean mRun=false;
    //send buffer to server
    private PrintWriter mBufOut;
    //receive buffer from server
    private BufferedReader mBufIn;

    //class constructor
    public TCPClient(String ip, int port, String wf_ssid){
        SRVIP = ip;
        SRVPRT = port;
        MYWIFISSID = wf_ssid;
    }
    public boolean testConnection(){
        return mRun;
    }

    //disconnect and free up resources
    public void stopClient(){
        mRun=false;
        if (mBufOut!=null){
            mBufOut.flush();
            mBufOut.close();
        }
        mBufOut=null;
        mBufIn=null;
        mSrvMsg=null;
    }

    //function of sending a message to the server, takes as a parameter the message string
    public int SendMessage(String msg){
        if (mBufOut!=null && !mBufOut.checkError()){
            mBufOut.println(msg);
            //mBufOut.write(msg);
            //mBufOut.flush();
            return 0;
        }else {
            if (mBufOut==null){
                return 1;//error 1 - mBufOut is null
            } else {
                return 2;//error 2 - some mistake of mBufOut
            }
        }
    }

    //connection to the server
    public void runClient(Handler hndlr, Context context){
        Message message;
        Bundle bundle = new Bundle();

        //check the name of the connected WiFi network
        if (!getwifiName(context).equalsIgnoreCase(MYWIFISSID)){
            //send an error message to UIThread via android.os.Handler
            message = hndlr.obtainMessage();//сообщение
            bundle.putString(HNDLKEY, NOCONNTOMYWIFI);
            message.setData(bundle);
            hndlr.sendMessage(message);
            return;
        }

        mRun=true;
        try{
            InetAddress srvAddr=InetAddress.getByName(SRVIP);
            //Log.e("TCP Client", "Connecting...");
            //create a connection
            Socket sckt = new Socket(srvAddr, SRVPRT);
            try {
                //connect send buffer
                mBufOut = new PrintWriter(new BufferedWriter(new OutputStreamWriter(sckt.getOutputStream())), true);
                //connect receive buffer
                mBufIn = new BufferedReader(new InputStreamReader(sckt.getInputStream()));

                //until the connection is, listen to incoming messages from server
                while (mRun){
                    mSrvMsg = mBufIn.readLine();
                    if (!mSrvMsg.isEmpty()){
                        //send a message to UIThread via android.os.Handler
                        message = hndlr.obtainMessage();
                        bundle.putString(HNDLKEY, mSrvMsg);
                        message.setData(bundle);
                        hndlr.sendMessage(message);
                    }
                }
                //Log.e("MESSAGE FROM SERVER", "Message received: '" + mSrvMsg + "'");
            } catch (Exception e){
                Log.e("TCP", "Error", e);
                //send an error message to UIThread via android.os.Handler
                message = hndlr.obtainMessage();
                bundle.putString(HNDLKEY, SKT_RD_ERR);
                message.setData(bundle);
                hndlr.sendMessage(message);
            } finally {
                //the socket must be closed, you can not connect
                sckt.close();
            }
        } catch (Exception e){
            Log.e("TCP", "Error", e);
            //send an error message to UIThread via android.os.Handler
            message = hndlr.obtainMessage();//сообщение
            bundle.putString(HNDLKEY, SKT_ERR);
            message.setData(bundle);
            hndlr.sendMessage(message);
        }
    }
    public String getwifiName(Context context){
        //check if you have a connection to the desired WiFi network
        String wf_ssid = "---";
        WifiManager manager = (WifiManager) context.getSystemService(Context.WIFI_SERVICE);
        if (manager.isWifiEnabled()) {
            WifiInfo wifiInfo = manager.getConnectionInfo();
            if (wifiInfo != null) {
                NetworkInfo.DetailedState state = WifiInfo.getDetailedStateOf(wifiInfo.getSupplicantState());
                if (state == NetworkInfo.DetailedState.CONNECTED || state == NetworkInfo.DetailedState.OBTAINING_IPADDR) {
                    wf_ssid = wifiInfo.getSSID();
                    wf_ssid = wf_ssid.replace("\"", "");
                }
            }
        }
        return wf_ssid;
    }

}