'*******************************************************************************
$regfile = "m8def.dat"                                      'ATMEGA8L
$crystal = 8000000                                          '8 MHz internal
$baud = 9600
$lib "single.lbx"
'************************** PORT CONFIGURATIONS --******************************
Config Lcd = 16 * 2
Config Lcdbus = 4
Config Lcdmode = Port
Config Lcdpin = Pin , Db4 = Portd.4 , Db5 = Portd.5 , Db6 = Portd.6 , Db7 = Portd.7 , E = Portd.3 , Rs = Portd.2
'*******************************************************************************
Config Com1 = Dummy , Synchrone = 0 , Parity = None , Stopbits = 1 , Databits = 8 , Clockpol = 0
Enable Urxc                                                 'serial receive complete interrupt
On Urxc Serialget                                           'serial receive complete ISR label config

Config Adc = Single , Prescaler = Auto , Reference = Internal
Declare Function Mavgcurrent(byval Z As Single)as Single    'declare function for moving avg window for current
Declare Function Mavgvoltage(byval Zv As Single)as Single   'declare function for moving avg window for voltage
'*******************************************************************************
Config Portb.0 = Output                                     'piezzo buzzer
Config Portc.2 = Output                                     'red LED(active high)[LOAD status]
Reset Portc.2

Config Portb.2 = Output                                     'LOAD RELAY (active high)
Reset Portb.2

Config Portb.1 = Output                                     'LCD Backlight (active high)
Reset Portb.1

Config Pinc.4 = Input                                       'MODE button
Config Pinc.5 = Input                                       'SERIAL button
Config Pinc.3 = Input                                       'LOAD button
Set Portc.5
Set Portc.4
Set Portc.3


Config Pinc.0 = Input                                       'current sense input
Config Pinc.1 = Input                                       'voltage sense input
'*******************************************************************************
Dim W As Word , M As Word                                   'for adc 10bit number
Dim X As Single , Y As Single , I As Single , P As Single , Q As Single , V As Single , Pow As Single
Dim K As String * 6 , L As String * 6 , T As String * 6
Dim Xc As Byte

Dim F(15)as Single                                          'array for moving current averages
Dim Sum As Single                                           'sum for current
Dim Fv(15) As Single                                        'array for moving voltage averages
Dim Sumv As Single                                          'sum for voltage
Dim R As Byte                                               'for calculating average of moving average window variables

Dim C As Bit                                                'used in selecting display mode
C = 0
Dim S As Bit                                                'used in enabling serial transmission
S = 0
Dim Up As Byte                                              'used in updating display
Up = 0

Dim Abuff As Byte
'*************************** WELCOME MESSAGE ***********************************
Cursor Off

Startprog:
Set Portb.1                                                 'turn on LCD backlight
Cls
Lcd "LOADING"
For Xc = 1 To 16 Step 1
  Locate 2 , Xc
  Lcd ">"
  Waitms 70
Next Xc
Waitms 70
Cls
Lcd "    ABHISHEK"
Lowerline
Lcd " SMART DEVICES!"
Sound Portb.0 , 1000 , 250
Wait 1
Cls
Lcd "  DIGITAL POWER"
Lowerline
Lcd "   SUPPLY v2.0"
Sound Portb.0 , 1000 , 250
Wait 1

'Tell user that LOAD os OFF and he need to switch ot ON using the LOAD button
Cls
Lcd "    LOAD OFF"
Lowerline
Lcd "   V == "

Up = 0
Do
   If Pinc.3 = 0 Then                                       'load switch pressed
      Exit Do
   End If

   If Up = 0 Then
      Set Portb.1                                           'LCD bcklt ON
      Sound Portb.0 , 1000 , 150
   Elseif Up = 128 Then
      Reset Portb.1                                         'LCD bcklt OFF
      Sound Portb.0 , 1000 , 150
   End If

   'Sense Terminal Voltage And Display It
   'Update It Every 75ms
   W = Up Mod 10
   If W = 0 Then
      M = Getadc(1)                                         'voltage
      Waitus 200
      X = 0.0025024 * M                                     '0.0025024 = resolution for 10 bit ADC

      If M >= 0 And M <= 108 Then                           'voltage acoss main output of LM338
         Q = X * 11.40
      Elseif M > 108 And M <= 432 Then
         Q = X * 11.38
      Elseif M > 432 Then
         Q = X * 11.39
      End If

      V = Abs(q)
      V = Mavgvoltage(v)
      L = Fusing(v , "000.&&")
      Locate 2 , 9
      Lcd L
   End If

   Waitms 3
   Incr Up
Loop

Sound Portb.0 , 1000 , 250
Set Portb.2                                                 'RELAY ON
Set Portb.1                                                 'LCD BCLT ON
Set Portc.2                                                 'LOAD LED ON

Cls
Lcd "    LOAD ON"
Lowerline
Lcd "  Successfully"
Waitms 800



Cls
Lcd "CURRENT:"
Lowerline
Lcd "VOLTAGE:"
Locate 1 , 15
Lcd "A "
Locate 2 , 15
Lcd "V "
'***************************** MAIN LOOP ***************************************
Do

If Pinc.3 = 0 Then                                          'load switch pressed
   Sound Portb.0 , 1000 , 250
   If Portb.2 = 1 Then                                      'if load is ON already
     Portb.2 = 0                                            'switch it OFF
     Portc.2 = 0                                            'load LED off
     Cls
     Lcd "    LOAD OFF"
     Lowerline
     Lcd "  Successfully!"
     Waitms 800
   Else                                                     'otherwise
     Portb.2 = 1
     Portc.2 = 1                                            'load LED ON
     Cls
     Lcd "    LOAD ON"
     Lowerline
     Lcd "  Successfully!"
     Waitms 800                                             'switch it ON
   End If

   'recover the display
   Cls
   If C = 0 Then
         Lcd "CURRENT:"
         Lowerline
         Lcd "VOLTAGE:"
         Locate 1 , 15
         Lcd "A "
         Locate 2 , 15
         Lcd "V "
   Else
         Lcd "POWER:"
         Locate 1 , 13
         Lcd "Watt"
         Locate 2 , 1
         Lcd "C:"
         Locate 2 , 9
         Lcd "V:"
   End If
End If

If Pinc.4 = 0 Then                                          'button mode
    If C = 0 Then
         C = 1
         Sound Portb.0 , 1000 , 250
         Cls
         Lcd "POWER:"
         Locate 1 , 13
         Lcd "Watt"
         Locate 2 , 1
         Lcd "C:"
         Locate 2 , 9
         Lcd "V:"
    Else
         C = 0
         Sound Portb.0 , 1000 , 250
         Cls
         Lcd "CURRENT:"
         Lowerline
         Lcd "VOLTAGE:"
         Locate 1 , 15
         Lcd "A "
         Locate 2 , 15
         Lcd "V "
    End If
End If
'######################################################################################## SERIAL ENABLE BUTTON EVENT
If Pinc.5 = 0 Then                                          'button serial enable

    Waitms 800

    If Pinc.5 = 1 Then                                      'button released
          Sound Portb.0 , 1000 , 250
          If S = 0 Then                                     'enable the serial transmission
             Cls
             Lcd "SERIAL  TRANSMIT"
             Lowerline
             Lcd "     ENABLED"
             S = 1                                          'set serial status flag
             Waitms 600
          Else                                              'disable the serial transmission
             Cls
             Lcd "SERIAL  TRANSMIT"
             Lowerline
             Lcd "    DISABLED"
             S = 0
             Waitms 600
          End If

          'recover the display
          Cls
          If C = 0 Then
               Lcd "CURRENT:"
               Lowerline
               Lcd "VOLTAGE:"
               Locate 1 , 15
               Lcd "A "
               Locate 2 , 15
               Lcd "V "
          Else
               Lcd "POWER:"
               Locate 1 , 13
               Lcd "Watt"
               Locate 2 , 1
               Lcd "C:"
               Locate 2 , 9
               Lcd "V:"
          End If
      Else
          Toggle Portb.1                                    'toggle LCD backlight
          Cls
          Lcd "Backlight"
          Lowerline

          If Portb.1 = 0 Then
             Lcd ":OFF"
          Else
             Lcd ":ON"
          End If
          Wait 1
          
          'recover the display
          Cls
          If C = 0 Then
               Lcd "CURRENT:"
               Lowerline
               Lcd "VOLTAGE:"
               Locate 1 , 15
               Lcd "A "
               Locate 2 , 15
               Lcd "V "
          Else
               Lcd "POWER:"
               Locate 1 , 13
               Lcd "Watt"
               Locate 2 , 1
               Lcd "C:"
               Locate 2 , 9
               Lcd "V:"
          End If
      End If
End If

W = Getadc(0)                                               'current
Waitms 2
M = Getadc(1)                                               'voltage
Waitms 2

'CURRENT CALCULATION
Y = 0.0025024 * W                                           '0.0025024 = resolution for 10 bit ADC
P = Y \ 1.68                                                'current sense resistor voltage (1.68 = gain of op-amp)
I = P \ 0.31                                                'true current through load [R(shunt)=0.31 ohm]
I = Abs(i)
I = Mavgcurrent(i)
K = Fusing(i , "000.&&")

'VOLTAGE CALCULATION
X = 0.0025024 * M                                           '0.0025024 = resolution for 10 bit ADC

If M >= 0 And M <= 108 Then                                 'voltage acoss main output of LM338
   Q = X * 11.40
Elseif M > 108 And M <= 432 Then
   Q = X * 11.38
Elseif M > 432 Then
   Q = X * 11.39
End If

V = Q - P                                                   'true voltage across load after deducing that of shunt drop
V = Abs(v)
V = Mavgvoltage(v)
L = Fusing(v , "000.&&")

Pow = I * V                                                 'calculation of instantaneous power
Pow = Abs(pow)
T = Fusing(pow , "000.&")

If Up = 50 Then                                             'update the display after fixed interval
      Up = 0                                                'release the counter
      If C = 0 Then                                         'only current and voltage
         Locate 1 , 9
         Lcd "      "
         Locate 1 , 9
         Lcd K
         Locate 2 , 9
         Lcd "      "
         Locate 2 , 9
         Lcd L
      Else                                                  'current,voltage and power
         Locate 1 , 7
         Lcd "      "
         Locate 1 , 7
         Lcd T
         Locate 2 , 3
         Lcd "      "
         Locate 2 , 3
         Lcd K
         Locate 2 , 11
         Lcd "      "
         Locate 2 , 11
         Lcd L
      End If

      If S = 1 Then                                         'sending acquired data over serial output
         Print "A" ; K ; "B" ; L ; "C" ; T ; "D"
      End If
End If



Incr Up
Loop
End                                                         'end program
'**********************************************************************************************
Function Mavgcurrent(byval Z As Single)as Single            'function for moving averages window for current

'shift the array downward and enter new data on top
F(15) = F(14)
F(14) = F(13)
F(13) = F(12)
F(12) = F(11)
F(11) = F(10)
F(10) = F(9)
F(9) = F(8)
F(8) = F(7)
F(7) = F(6)
F(6) = F(5)
F(5) = F(4)
F(4) = F(3)
F(3) = F(2)
F(2) = F(1)
F(1) = Z                                                    'data entered on top

Sum = 0
For R = 1 To 15 Step 1                                      'calculate sum of all variables
  Sum = Sum + F(r)
Next R

Sum = Sum \ 15                                              'calculate the average
Mavgcurrent = Sum                                           'return the mean value

End Function
'**********************************************************************************************
Function Mavgvoltage(byval Zv As Single)as Single           'function for moving averages window for voltage

'shift the array downward and enter new data on top
Fv(15) = Fv(14)
Fv(14) = Fv(13)
Fv(13) = Fv(12)
Fv(12) = Fv(11)
Fv(11) = Fv(10)
Fv(10) = Fv(9)
Fv(9) = Fv(8)
Fv(8) = Fv(7)
Fv(7) = Fv(6)
Fv(6) = Fv(5)
Fv(5) = Fv(4)
Fv(4) = Fv(3)
Fv(3) = Fv(2)
Fv(2) = Fv(1)
Fv(1) = Zv                                                  'data entered on top

Sumv = 0
For R = 1 To 15 Step 1                                      'calculate sum of all variables
  Sumv = Sumv + Fv(r)
Next R

Sumv = Sumv \ 15                                            'calculate the average
Mavgvoltage = Sumv                                          'return the mean value

End Function
'**********************************************************************************************
'############################################## Serial data receive complete ISR
Serialget:
Abuff = Inkey()                                             'read the input buffer
If Abuff = 65 Then                                          'A-turn ON load
     Portb.2 = 1
     Portc.2 = 1                                            'load LED ON
     Cls
     Lcd "    LOAD ON"
     Lowerline
     Lcd "  Successfully!"
     Waitms 800
Elseif Abuff = 66 Then                                      'B-turn OFF load
     Portb.2 = 0                                            'switch it OFF
     Portc.2 = 0                                            'load LED off
     Cls
     Lcd "    LOAD OFF"
     Lowerline
     Lcd "  Successfully!"
     Waitms 800
End If
Return