#include <Arduino.h>
#include <Wire.h>
#include <SoftwareSerial.h>

#include "TFT_ST7735.h"

double angle_rad = PI/180.0;
double angle_deg = 180.0/PI;
void DisplayRules();
TFT_ST7735 lcd = TFT_ST7735();
void DisplayScore();
double RedScore;
double BlueScore;
void LED(double Red, double Green, double Blue);
void Initialisation();
double MatchTime;
void MatchInitialisation();
double currentTime = 0;
double lastTime = 0;
void ShowTimer();
double getLastTime(){
    	return currentTime = millis()/1000.0 - lastTime;
}
void Match();
void ScrreTie();
void RedWins();
void BlueWins();


void DisplayRules()
{
    lcd.fillScreen(0);
    
    lcd.setTextColor(65535, 0);
    
    lcd.setCursor(35, 10);
    
    lcd.setTextSize(1);
    
    lcd.print("Magnetic Hockey");
    
    lcd.setCursor(0, 30);
    
    lcd.print("Rules:");
    
    lcd.setCursor(0, 40);
    
    lcd.print("1. Match time: 180 Seconds");
    
    lcd.setCursor(0, 50);
    
    lcd.print("2. Score as many goals as you can");
    
    lcd.setCursor(0, 70);
    
    lcd.print("3. Team with most goals   wins");
    
    lcd.setCursor(15, 100);
    
    lcd.setTextColor(2016, 0);
    
    lcd.print("Press Switch 1 to Play");
    
}

void DisplayScore()
{
    lcd.setTextSize(5);
    
    lcd.setTextColor(65535, 63488);
    
    lcd.setCursor(30, 53);
    
    lcd.print(((int) RedScore));
    
    lcd.setTextColor(65535, 31);
    
    lcd.setCursor(105, 53);
    
    lcd.print(((int) BlueScore));
    
}

void LED(double Red, double Green, double Blue)
{
    digitalWrite(28,Red);
    
    digitalWrite(29,Green);
    
    digitalWrite(30,Blue);
    
}

void Initialisation()
{
    MatchTime = 180;
    
    DisplayRules();
    
    analogWrite(44,255);
    
    analogWrite(45,255);
    
    LED(1,1,1);
    
}

void MatchInitialisation()
{
    LED(0,0,0);
    
    lastTime = millis()/1000.0;
    
    BlueScore = 0;
    
    RedScore = 0;
    
    lcd.setTextSize(3);
    
    lcd.fillScreen(65535);
    
    lcd.setTextColor(992, 65535);
    
    lcd.setCursor(40, 10);
    
    lcd.print("Score");
    
    lcd.fillRoundRect(10, 40, 65, 60, 10, 63488);
    
    lcd.fillRoundRect(85, 40, 65, 60, 10, 31);
    
    DisplayScore();
    
}

void ShowTimer()
{
    lcd.setTextSize(1);
    
    lcd.setCursor(35, 110);
    
    lcd.setTextColor(0, 65535);
    
    lcd.print(String("Time: ")+((int) (MatchTime) - (getLastTime()))+String(" Sec"));
    
}

void Match()
{
    ShowTimer();
    
    if(digitalRead(2)){
        RedScore += 1;
        DisplayScore();
        LED(0,1,1);
        tone(46,587,500); // write to buzzer
        delay(500);
        _delay(2);
        LED(0,0,0);
    }
    
    if(digitalRead(3)){
        BlueScore += 1;
        DisplayScore();
        LED(1,1,0);
        tone(46,523,500); // write to buzzer
        delay(500);
        _delay(2);
        LED(0,0,0);
    }
    
    if(((MatchTime) - (getLastTime())) < (5)){
        if(((fmod((MatchTime) - (getLastTime()),2))==(0))){
            analogWrite(44,100);
            analogWrite(45,100);
        }else{
            analogWrite(44,255);
            analogWrite(45,255);
        }
    }
    
}

void ScrreTie()
{
    lcd.fillScreen(65535);
    
    lcd.setTextSize(2);
    
    lcd.setCursor(25, 15);
    
    lcd.setTextColor(0, 65535);
    
    lcd.print("Match Draw");
    
    lcd.fillRoundRect(10, 40, 65, 60, 10, 63488);
    
    lcd.fillRoundRect(85, 40, 65, 60, 10, 31);
    
    DisplayScore();
    
    for(int __i__=0;__i__<5;++__i__)
    {
        LED(1,0,1);
        _delay(0.5);
        tone(46,523,500); // write to buzzer
        delay(500);
        LED(0,0,0);
        _delay(0.5);
    }
    
    _delay(10);
    
}

void RedWins()
{
    lcd.fillScreen(30720);
    
    lcd.setTextSize(2);
    
    lcd.setCursor(35, 15);
    
    lcd.setTextColor(65535, 30720);
    
    lcd.print("Red Wins");
    
    lcd.fillRoundRect(10, 40, 65, 60, 10, 63488);
    
    lcd.fillRoundRect(85, 40, 65, 60, 10, 31);
    
    DisplayScore();
    
    for(int __i__=0;__i__<5;++__i__)
    {
        LED(0,1,1);
        _delay(0.5);
        tone(46,523,500); // write to buzzer
        delay(500);
        LED(0,0,0);
        _delay(0.5);
    }
    
    _delay(10);
    
}

void BlueWins()
{
    lcd.fillScreen(2047);
    
    lcd.setTextSize(2);
    
    lcd.setCursor(30, 15);
    
    lcd.setTextColor(0, 2047);
    
    lcd.print("Blue Wins");
    
    lcd.fillRoundRect(10, 40, 65, 60, 10, 63488);
    
    lcd.fillRoundRect(85, 40, 65, 60, 10, 31);
    
    DisplayScore();
    
    for(int __i__=0;__i__<5;++__i__)
    {
        LED(1,1,0);
        _delay(0.5);
        tone(46,523,500); // write to buzzer
        delay(500);
        LED(0,0,0);
        _delay(0.5);
    }
    
    _delay(10);
    
}


void setup(){
    lcd.init();
     lcd.setRotation(1);
    Initialisation();
    
    pinMode(28,OUTPUT);
    pinMode(29,OUTPUT);
    pinMode(30,OUTPUT);
    pinMode(44,OUTPUT);
    pinMode(45,OUTPUT);
    pinMode(2,INPUT);
    pinMode(46,OUTPUT);
    pinMode(3,INPUT);
    pinMode(38,INPUT);
}

void loop(){
    
    if(digitalRead(38)){
        MatchInitialisation();
        while(!((MatchTime) < (getLastTime())))
        {
            _loop();
            Match();
        }
        if(((RedScore)==(BlueScore))){
            ScrreTie();
        }
        if((RedScore) > (BlueScore)){
            RedWins();
        }
        if((BlueScore) > (RedScore)){
            BlueWins();
        }
        DisplayRules();
    }
    
    _loop();
}

void _delay(float seconds){
    long endTime = millis() + seconds * 1000;
    while(millis() < endTime)_loop();
}

void _loop(){
    
}

