////////////////////////////////////////////////////////////////////////////
// Name: config.c
// Author: B. Gian James <gian@BattleDroids.net>
// Description: Structures and declarations for things stored mostly in 
//              EEPROM, like last score, high score, etc.
//
// $Id: config.c,v 1.3 2009/08/21 08:19:12 gian Exp $
////////////////////////////////////////////////////////////////////////////

#include "config.h"
#include <avr/eeprom.h>

void WriteEEHighScore(uint8 score)
{
	eeprom_write_byte((uint8*)EE_HIGHSCORE,score);
}

void WriteEEHighName(const char * name)
{
	eeprom_write_block((const void*)EE_HIGHNAME,(void*)&name,HIGHNAME_MAX);
}

void WriteEEHaveLDR(uint8 ldr)
{
	eeprom_write_byte((uint8*)EE_HAVELDR,ldr);
}

uint8 ReadEEHighScore()
{
	uint8 highScore;
	highScore = eeprom_read_byte((uint8*)EE_HIGHSCORE);
	return highScore;
}

void ReadEEHighName(char * buff)
{
	eeprom_read_block((void*)&buff[0],(const void*)EE_HIGHNAME,HIGHNAME_MAX);
}

uint8 ReadEEHaveLDR()
{
	uint8 haveLDR;
	haveLDR = eeprom_read_byte((uint8*)EE_HAVELDR);
	return haveLDR;
}