#pragma once
////////////////////////////////////////////////////////////////////////////
// Name: config.h
// Author: B. Gian James <gian@BattleDroids.net>
// Description: Structures and declarations for things stored mostly in 
//              EEPROM, like last score, high score, etc.
//
// $Id: config.h,v 1.3 2009/08/21 08:19:12 gian Exp $
////////////////////////////////////////////////////////////////////////////
#include "common.h"

#define HIGHNAME_MAX	10

// EEPROM Memory Map
#define EE_HIGHSCORE  	0x0000
#define EE_HIGHNAME		(EE_HIGHSCORE + 1)
#define EE_HAVELDR		(EE_HIGHNAME + HIGHNAME_MAX)

uint8	ReadEEHighScore(void);
void	ReadEEHighName(char *);
uint8	ReadEEHaveLDR(void);

void	WriteEEHighScore(uint8);
void	WriteEEHighName(const char *);
void	WriteEEHaveLDR(uint8);

