#pragma once
////////////////////////////////////////////////////////////////////////////
// Name: mastermind.h
// Author: B. Gian James <gian@BattleDroids.net>
// Description: The code behind the famous mastermind logic game.
//
// $Id: mastermind.h,v 1.1.1.1 2009/08/17 08:10:59 gian Exp $
////////////////////////////////////////////////////////////////////////////

#define NUM_COLORS	7
#define NUM_SLOTS	4
#define NUM_TURNS	8
#define MCU			1
#define PLAYER		0
#define TERM_COLS	80

typedef enum 
{ BLUE, RED, YELLOW, GREEN, WHITE, BLACK, ORANGE } 
Color;

typedef struct
{
	Color	color;
	char	brev;
	char *	name;
	
} ColorStruct;

typedef struct
{
	uint8	turn;
	uint8	numColorCorrect;
	uint8	numColorPlaceCorrect;
	Color 	colorChoices[NUM_SLOTS];
	
} TurnStruct;


extern ColorStruct 	ColorInfo[NUM_COLORS];
extern TurnStruct	TurnInfo[NUM_TURNS];
extern Color		ColorCompare[NUM_SLOTS];

// Prototypes
void 	InitGame(uint8 gameMaster);
uint8	ProcessColors(char * buff);
void	StartRound(uint8 round);
TurnStruct * CalcCorrect(void);
void	DisplayTurnInfo(void);