#pragma once
////////////////////////////////////////////////////////////////////////////
// Name: usart.h
// Author: B. Gian James <gian@BattleDroids.net>
// Description: USART functions for ATmega162
//
// $Id: usart.h,v 1.2 2009/08/21 06:07:02 gian Exp $
////////////////////////////////////////////////////////////////////////////

#ifdef __ARDUINO__
#define BAUD 		9600
#else
#define BAUD		57600
#endif

#define MAX_RX_SZ	32

// Prototypes
void InitUSART(void);

// Transmit
void WriteChar(unsigned char);
void WriteString(const char *);
void WriteRAMString(const char *);
void WriteInt(const int);

// Receive
char ReadChar(void);
void ReadLine(char *);
