//Code by Arvid Jense 2013   http://www.arvidjense.com
//Licenced as GPLv3 http://www.gnu.org/licenses/gpl.html
//19-2-2013

//Initialising variables


//Multiplexer
int r0 = 0;      //value of select pin at the 4051 (s0)
int r1 = 0;      //value of select pin at the 4051 (s1)
int r2 = 0;      //value of select pin at the 4051 (s2)

//Sequencer
int count = 0;   //which y pin we are selecting
int note = 0;
int seqValue = 0;
int tempoKnob = 500;
int base = 0;
int baseKnob = 0;
int chromaticScale[] = {
  -12,-11,-10,-9,-8,-7,-6,-5,-4,-3,-2,-1,0,1,2,3,4,5,6,7,8,9,10,11,12}; // 25 items
int diatonicScale[] = {
  -12,-10,-8,-7,-5,-3,-1,0,2,4,5,7,9,11,12}; //15 items
int bluesScale[] = {
  -12,-9,-7,-6,-5,-2,0,3,5,6,7,10,12}; //13 items
int state = 0;

unsigned long Timer1 = 0;
int waitTime = 200;

//On what pin the LED is connected 
#define LEDPIN 13

#define BOUNCE_DURATION 100   // define an appropriate bounce time in ms for your switches
volatile unsigned long bounceTimeLeft=0; // variable to hold ms count to debounce a pressed switch
volatile unsigned long bounceTimeRight=0; // variable to hold ms count to debounce a pressed switch

void setup(){

  //Serial.begin(9600); //This is needed for debugging on the computer
  Serial1.begin(31250); //This initialises the Serial protocol to send and recieve MIDI

  //For the multiplexers
  pinMode(4, OUTPUT);    // s0
  pinMode(5, OUTPUT);    // s1
  pinMode(6, OUTPUT);    // s2

  pinMode(LEDPIN,OUTPUT);
  pinMode(7, INPUT_PULLUP);//what reads the run knob

  attachInterrupt(1, buttonLeft, CHANGE); //pin 2
  attachInterrupt(0, buttonRight, RISING);//pin 3

  digitalWrite(LEDPIN,HIGH); //to make sure a led is lit, even though run is turned off
  /*
  //These MIDI messages make sure the Meeblip is set as desired when the instrument is 
   //turned on. The codes can be found in the Meeblip documentation
   //disabled right now, as the Meeblip firmware doesn't accept MIDI in anymore
   midiCC(51,0);  //LFO depth 0
   midiCC(52,64); //filter envelope medium
   midiCC(52,64); //filter decay medium
   midiCC(52,64); //filter attack medium
   midiCC(64,0);  //knob shift off
   midiCC(70,0);  //LFO off
   midiCC(74,127);//OSC B on
   midiCC(76,0);  //env sust off
   midiCC(78,127);//PWM on
   */
  state = map(analogRead(A1),0,1023,0,3);

}

void loop () {
  if (digitalRead(7)==0){ //if the run button is on, play the sequencer
    tempoKnob = analogRead(A2);
    waitTime = map(tempoKnob, 0, 1023, 500, 50); //A range of 16th at 30 to 300 BPM
    if (millis() - Timer1 > waitTime){
      if (digitalRead(2)== LOW){
        count++;
      }
      if (digitalRead(2)== HIGH){
        count--;
      }
      Timer1 = millis();
      readNote(count);
    }  
  }
}

//What happens when the dynamic buttons are pressed
void buttonLeft(){

  if (abs(millis() - bounceTimeLeft) > BOUNCE_DURATION && digitalRead(2)== HIGH) {

    count--;

    readNote(count);
    Timer1 = millis();
    bounceTimeLeft = millis();  // set whatever bounce time in ms is appropriate

  }
}

void buttonRight(){
  if (abs(millis() - bounceTimeRight) > BOUNCE_DURATION)  
  {
    count++;
    readNote(count);
    Timer1 = millis();
    bounceTimeRight = millis();  // set whatever bounce time in ms is appropriate
  }
}

//What reads the knobs
void readNote(int cnt){
  if (count > 7  && count < 0){
    count = 0 ;
  }

  digitalWrite(LEDPIN,LOW); //turn the led off, might be arbitrary

  //noteOn(note,0x00); //turns the note off to avoid hanging notes, 
  //but interfers with glide?

  //code to set the multiplexer to the desired mode

  // select the right bits for the multiplexer  
  r0 = bitRead(cnt,0);     
  r1 = bitRead(cnt,1);    
  r2 = bitRead(cnt,2);    
  digitalWrite(4, r0);
  digitalWrite(5, r1);
  digitalWrite(6, r2);

  //reading the value from the knobs and mapping is to a midi compatible range
  seqValue = analogRead(A0);
  baseKnob = analogRead(A1);
  base = map(baseKnob, 0 ,1023, 48, 84);//meeblip range is limited from 36 to 96

  switch (state){
  case 0:
    note = chromaticScale[map(seqValue, 3, 1023, 0, 24)];//25 items
    break;
  case 1:
    note = diatonicScale[map(seqValue, 3, 1023, 0, 14)];//15 items
    break;
  default:
    note = bluesScale[map(seqValue, 3, 1023, 0, 12)];//13 items
    break;
  }

  note = note + base;

  //is the knob is set all the way to the left, no note will be played and the
  //LED will be more dim
  if (seqValue > 3) {
    noteOn(note,0x45);
    digitalWrite(LEDPIN,HIGH);
  }
  else {
    analogWrite(LEDPIN,10);
  }

  //These makes the right binary code for midi messages
}
void noteOn(int pitch, int velocity) {
  Serial1.write(0x90);
  Serial1.write(pitch);
  Serial1.write(velocity);
}

void midiCC(int cc, int value) {
  Serial1.write(0xB0);
  Serial1.write(cc);
  Serial1.write(value);
}

















