/*
  Morse.cpp - Library for flashing Morse code.
  Created by David A. Mellis, November 2, 2007.
  Released into the public domain.
*/

#include "Arduino.h"
#include "Morse.h"

Morse::Morse(int pin)
{
  pinMode(pin, OUTPUT);
  _pin = pin;
}

void Morse::dot()
{
  delay(100); 
  digitalWrite(_pin, LOW);
  delay(100);
  digitalWrite(_pin, HIGH);
   
}

void Morse::get_temps()
{
  digitalWrite(_pin, LOW);
  delay(100);
  digitalWrite(_pin, HIGH);
  delay(100);  
}

void Morse::off()
{
    digitalWrite(_pin, HIGH);
	Morse_Status = false;
}

void Morse::on()
{
    digitalWrite(_pin, LOW);
	Morse_Status = true;
}

boolean Morse::status()
{
	return Morse_Status;
}




void Morse::dash()
{
  delay(100);
  digitalWrite(_pin, LOW);
  delay(300);
  digitalWrite(_pin, HIGH);
  
}

