import ddf.minim.*;
import ddf.minim.analysis.*;
import ddf.minim.effects.*;
import ddf.minim.signals.*;
import ddf.minim.spi.*;
import ddf.minim.ugens.*;
import controlP5.*;
import processing.serial.*;

ControlP5 cp5;
CheckBox alarmBoxes;
Button alarmButton;
Button clockButton;
Button weatherButton;
Button colorButton;
Slider  setHour;
Slider setMin;
CheckBox setAm;

AudioPlayer gentle;
AudioPlayer song;
AudioPlayer loudsong;
AudioPlayer hellarm;

Serial myPort;  // Create object from Serial class

Minim minim = new Minim(this);
timeDisplay timeDisplay = new timeDisplay();
Alarm alarm = new Alarm();
Timing timing = new Timing();

int h;
int m;
String daytime;
int alarmH;
int alarmM;
String alarmAMPM;
boolean awake = false;
color c = color(100);

int val;      // Data received from the serial port
int pressed = 0;
boolean button = false;

void setup() {
  background(0);
  //size(800, 460);
  fullScreen(2);
  smooth();

  String portName = Serial.list()[2];
  myPort = new Serial(this, portName, 9600);


  //loads music files for alarms. 
  //To use different alarms, put your own sound files in the "data" folder of the sketch.
  //Then change the names below to the file names you want to load.

  gentle = minim.loadFile("nature.mp3");
  song = minim.loadFile("happy.mp3");
  loudsong = minim.loadFile("Cena.mp3");
  hellarm = minim.loadFile("death.wav");
  cp5 = new ControlP5(this);
  buttons();
}

//variable for which display screen you are on (clock(0), alarm set(1), color select(2), or weather(3))
int display = 0;
//variable for which clock is displayed on the main screen
int timeFace = 0;

void draw() {

  //println(alarmH + ":" + alarmM + " " + alarmAMPM + " - " + h + ":" + m + " " + daytime);
  textAlign(CENTER);

  boolean clockDisplay = true;
  readButton();

  timeDisplay.getTime(); //finds the current time using set time from computer


  //get the state of the alarms (true = on, false = off);

  switch(display) {  //decides what the screen will display

  case 0: //basic clock screen
    alarmBoxes.hide(); 
    setAm.hide(); 
    setMin.hide(); 
    setHour.hide();
    alarmButton.setLabel("alarm");
    weatherButton.setLabel("weather");
    clockButton.setLabel("clock");
    colorButton.setLabel("color");
    clockDisplay = true;
    break;
  case 1: //alarm set screen
    fill(0);
    rect(0, 0, width, height);
    alarmBoxes.show();
    setAm.show(); 
    setMin.show(); 
    setHour.show();
    timing.getAlarmTime();
    timing.showAlarmTime(width/12, width*2/3, height/7);
    alarmButton.setLabel("back");
    weatherButton.setLabel("");
    clockButton.setLabel("");
    colorButton.setLabel("");
    clockDisplay = false;
    break;
  case 2: // back to clock display
    display = 0;
    clockDisplay = true;
    break;
  }

  if (clockDisplay) {
    //use the 

    switch(timeFace) { //changes between clock faces (dependant upon timeFace variable)
    case 0:
      fill(0);
      rect(0, 0, width, height);
      timeDisplay.digital();
      break;
    case 1:
      fill(0);
      rect(0, 0, width, height);
      timeDisplay.analog();
      break;
    case 2:
      timeFace = 0;
      break;
    }
  }

  timing.getAlarmTime();
  //use buttonstates of checkboxes to determine which alarms to set
  timing.multialarms();

  if (button == true) {
    if (!awake) {
      awake = true; 
      gentle.pause();
      song.pause();
      loudsong.pause();
      hellarm.pause();
    }
  }
}

void mouseClicked() {

  // when clock button is pushed, change clock face (using timeFace variable)
  if (mouseX < width/8 && mouseY > height-width/8) {
    timeFace = timeFace + 1;
  }
  // when color button is pushed, choose a random color
  if (mouseX > width-width/8 && mouseY > height-width/8) {
    c = color(random(255), random(255), random(255));
    alarmBoxes.setColorActive(c);
    setHour.setColorActive(c);
    setMin.setColorActive(c);
    setAm.setColorActive(c);
  }
  //when alarm button is pushed, show alarm set screen
  if (mouseX < width/8 && mouseY < width/8) {
    display = display + 1;
  }
}

void buttons() {
  //creates buttons and textfields to set alarms and switch between modes
  alarmBoxes = cp5.addCheckBox("checkBox").setPosition(width/4, height/18).setSize(width/10, width/10)
    .setColorBackground(color(240)).setColorForeground(color(200)).setColorActive(c)
    .setItemsPerRow(1).setSpacingColumn(30).setSpacingRow(20)
    .addItem("light wakeup", 0)
    .addItem("nature sounds", 1)
    .addItem("main alarm", 2)
    .addItem("backup alarm", 3)
    .addItem("emergency panic", 4)
    .hide(); 

  alarmButton = cp5.addButton("set alarm").setPosition(0, 0).setSize(width/8, width/8)
    .setColorBackground(color(40)).setColorForeground(color(200)).setColorActive(color(100, 175, 100));

  weatherButton = cp5.addButton("weather").setPosition(width-width/8, 0).setSize(width/8, width/8)
    .setColorBackground(color(40)).setColorForeground(color(200)).setColorActive(color(100, 175, 100));

  clockButton = cp5.addButton("clock").setPosition(0, height-width/8).setSize(width/8, width/8)
    .setColorBackground(color(40)).setColorForeground(color(200)).setColorActive(color(100, 175, 100));

  colorButton = cp5.addButton("color").setPosition(width-width/8, height-width/8).setSize(width/8, width/8)
    .setColorBackground(color(40)).setColorForeground(color(200)).setColorActive(color(100, 175, 100));

  // creates two sliders which can be used to set the time of the main alarm
  //and a button which sets AM or PM

  setHour = cp5.addSlider("HOUR")
    .setPosition(width/2, height/4)
    .setSize(width/20, height-height/3)
    .setRange(1, 12)
    .setNumberOfTickMarks(12)
    .showTickMarks(false)
    .setSliderMode(Slider.FLEXIBLE)
    .snapToTickMarks(true)
    .setColorBackground(color(255))
    .setColorForeground(color(100))
    .setColorActive(c);

  setMin = cp5.addSlider("MINUTE")
    .setPosition(width/2+width/4, height/4)
    .setSize(width/20, height-height/3)
    .setRange(0, 60)
    .setNumberOfTickMarks(60)
    .showTickMarks(false)
    .snapToTickMarks(true)
    .setSliderMode(Slider.FLEXIBLE)
    .setColorBackground(color(255))
    .setColorForeground(color(100))
    .setColorActive(c);

  setAm = cp5.addCheckBox("boxey")
    .setPosition(width-width/8, height/3)
    .setColorBackground(color(255))
    .setColorForeground(color(255))
    .setColorActive(c)
    .setColorLabel(color(255))
    .setSize(40, 40)
    .setItemsPerRow(3)
    .setSpacingColumn(30)
    .setSpacingRow(20)
    .addItem("AM", 0);
}