/* Blynk EMAIL and NOTIFICATION
 * ESP8266 example
 * www.geekstips.com
*/
#define BLYNK_PRINT Serial
#include <ESP8266WiFi.h>
#include <BlynkSimpleEsp8266.h>
#include <SimpleTimer.h>
#include <DHT.h>

// You should get Auth Token in the Blynk App.
// Go to the Project Settings (nut icon).
char auth[] = "hQ5wAYprJQf6lvqQefuEmRu7cZas0ROu";

// Your WiFi credentials.
// Set password to "" for open networks.
char ssid[] = "BT-FFA5G7";
char pass[] = "M00nshine1";

#define DHTPIN 2          // What digital pin we're connected to

// Uncomment whatever type you're using!
//#define DHTTYPE DHT11     // DHT 11
//#define DHTTYPE DHT22   // DHT 22, AM2302, AM2321
#define DHTTYPE DHT21   // DHT 21, AM2301
int alarmPin = 4;
int led1 = 16;
int led2 = 14;
DHT dht(DHTPIN, DHTTYPE);
SimpleTimer timer;

void sendSensor(){
  float h = dht.readHumidity();
  float t = dht.readTemperature(); // or dht.readTemperature(true) for Fahrenheit

  if (isnan(h) || isnan(t)) {
    Serial.println("Failed to read from DHT sensor!");
    return;
  }

  Serial.println(t);
  Serial.println(h);
  Blynk.virtualWrite(V10, h);
  Blynk.virtualWrite(V11, t);

  // SETUP the ALARM Trigger and Send EMAIL 
  // and PUSH Notification

  if(t > 28){
//    Blynk.email("vaduva.ionut.lucian@gmail.com", "ESP8266 Alert", "Temperature over 28C!");
//    Blynk.notify("ESP8266 Alert - Temperature over 28C!");
  }
}

void setup(){
  Serial.begin(115200);
  Blynk.begin(auth, ssid, pass);
  dht.begin();
  timer.setInterval(2500L, sendSensor);
}

void loop(){
  Blynk.run();
  timer.run();
}
