void setup(void) 
{
Serial.begin(115200);  
  Serial.setDebugOutput(true);
  delay(500);
WiFi.begin(ssid, password);
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
    morse.dot();
  }
  Serial.println(".");
  morse.dash();
  Serial.println("Connecting to Blynk.");
  Blynk.begin(auth, ssid, password);
  Serial.println("Done Connecting to Blynk.");
  
  RCSwitch sendSwitch = RCSwitch();
  RCSwitch recSwitch = RCSwitch();
  recSwitch.enableReceive(receive_433);
  sendSwitch.enableTransmit(send_433);
  
  timer.setInterval(60020L, Minute_Timer);
  timer.setInterval(11030L, Ten_Second_Timer);
  timer.setInterval(1000, Second_Timer);
  
  Serial.println(F("Looking for a DS2413 on the bus"));
  
  /* Try to find a device on the bus */
  oneWire.reset_search();
  delay(250);
  if (!oneWire.search(address)) 
  {
    printBytes(address, 8);
    Serial.println(F("No device found on the bus!"));
    oneWire.reset_search();
    while(1);
  }
  
  /* Check the CRC in the device address */
  if (OneWire::crc8(address, 7) != address[7]) 
  {
    Serial.println(F("Invalid CRC!"));
    while(1);
  }
  
  /* Make sure we have a DS2413 */
  if (address[0] != DS2413_FAMILY_ID) 
  {
    printBytes(address, 8);
    Serial.println(F(" is not a DS2413!"));
    while(1);
  }
  
  Serial.print(F("Found a DS2413: "));
  printBytes(address, 8);
  Serial.println(F(""));
  
  bool ok = false;
  ok = write(0x3);
  if (!ok) Serial.println(F("Wire failed"));
}
