/* ========================================
 *
 * Copyright Andyk75, 2016
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * ========================================
*/

/* ========================================
 *  Includes
 * ======================================== */
#include "persistentstorage.h"
#include <stdbool.h>

/* ========================================
 * Local Function Prototypes
 * ======================================== */
void ReadFlashContentToLocalDataArray(uint8 FlashRow);



/* ========================================
 *  global variables
 * ======================================== */
#define USERFLASHROW                        (1)

uint8 localFlashCopy[4*USER_SFLASH_ROW_SIZE];
uint8 *sflashPtr;

uint32 data[USER_SFLASH_ROW_SIZE];
uint32 *Pointer;

/* ========================================
 * Public Functions 
 * ======================================== */

void PSTOR_ReadUserFlashRow() {
    // Read the flashcontent in the local data-array
    ReadFlashContentToLocalDataArray(USERFLASHROW) ;    
}

void PSTOR_ReadInitialParameters( PersistenStorageDataNameEnum MyDataName, uint32 *datapointer ){
    
    // Get the correct adress depending on the MyDataName
    uint32 startpointer = (uint32)MyDataName;
    uint32 temp = 0; 
    
    temp = localFlashCopy[startpointer] + (localFlashCopy[startpointer+1]<<8) + (localFlashCopy[startpointer+2]<<16) + (localFlashCopy[startpointer+3]<<24);
            
    // return the correct value in a 32bit variable
    *datapointer = temp;         
}

uint32 PSTOR_WriteUserData(PersistenStorageDataNameEnum MyDataName, uint32 *dataPointer, bool WriteImmediatelytoFlash)
{
    uint32 result = 0;
    uint32 startpointer = 0; 
    uint32 temp = *dataPointer;
    
    // Read the flashcontent in the local data-array
    ReadFlashContentToLocalDataArray(USERFLASHROW) ;

    // Get the correct adress depending on the MyDataName
    startpointer = (uint32)MyDataName;
    
    // check if the new data is different than what is already there.
    localFlashCopy[startpointer] = (uint8)( (temp) & 0xFF );        
    localFlashCopy[startpointer+1] = (uint8)( (temp>>8) & 0xFF );    
    localFlashCopy[startpointer+2] = (uint8)( (temp>>16) & 0xFF );    
    localFlashCopy[startpointer+3] = (uint8)( (temp>>24) & 0xFF );    
    
    if(WriteImmediatelytoFlash) {
        // update the flash-content    
        result = CySysSFlashWriteUserRow(USERFLASHROW,(uint8 *)localFlashCopy);
    }
    else {
        result = FLASH_NOT_WRITTEN;
    }        
    return result;
}

void ReadUserData(PersistenStorageDataNameEnum MyDataName, uint8 length, uint8 *dataPointer)
{
    uint32 lengthCounter = 0;
    uint32 startpointer = (uint8) MyDataName;
    
    while(lengthCounter < length ) 
    {
        dataPointer[lengthCounter++] = localFlashCopy[startpointer++];        
    }    
}


/* ========================================
 *  Local Functions
 * ======================================== */
void ReadFlashContentToLocalDataArray(uint8 FlashRow) 
{
    uint32 dataIndex = 0;
    
    sflashPtr = (uint8 *)USER_SFLASH_BASE_ADDRESS; /* User SFlash read is direct memory read using pointers */
    Pointer = (uint32 *)USER_SFLASH_BASE_ADDRESS; 
    
    sflashPtr = sflashPtr + (FlashRow*USER_SFLASH_ROW_SIZE);
    
    for(dataIndex = 0; dataIndex < USER_SFLASH_ROW_SIZE * 4; dataIndex++)
        {
            localFlashCopy[dataIndex] = *sflashPtr++;
        }    
}


/* [] END OF FILE */
