/* ========================================
 *
 * Copyright Andyk75, 2016
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * ========================================
*/
#ifndef __POVEFFECT_H__
#define __POVEFFECT_H__
    
/* ========================================
 *  Includes
 * ======================================== */
#include <project.h>
    
    
    
/* ========================================
 * Global defines, Typedefs, Structures
 * ======================================== */
typedef enum 
{    
    Knightrider = 0,  
    ColorKnightRider, 
    Rainbowswirl,               
    Valueswirl,                    
    WS_CandyCane,                
    WS_CandyCane_2,               
    WS_CandyCane_3,             
    WS_Twinkle,                
    WS_Icicle,                   
    WS_ColorWheel,               
    RGB_Control, 
    TextAnimation,
    Animation_Max               
} e_Animation ;


typedef union rgb_t { 
    
	uint32_t rgb;
    
	struct rgb_tag { 
        uint8_t g,r,b;      /* Some Strips have G and R swapped */
    } c;
	
} led_color;

typedef union hsv_t { 
    
	uint32_t hsv;
    
	struct hsv_tag { 
        uint8_t h,s,v,pad;
    } h;
	
} hsv_color;    
    
#define SunDownStartValue   0
#define SunDownFirstThirdPassed     33
#define SunDownTwoThirdsPassed      66
#define SunDownCounterMax           100

    
/* ========================================
 * Public Functions 
 * ======================================== */
#define BOOT_CHECK() 

void Display_new_Color(uint8 red, uint8 green, uint8 blue);
void ColorKitt();
void RedKitt();
void ColorSwirl();
void ValueSwirl();
 
void CandyCane ( uint16_t count , uint32 c1, uint32 c2 );
void Twinkle( uint16_t count );
void ColorWheel( uint16_t count );
void Icicle (uint8 redraw, uint8 length, int fade_amount );           
void Sparkler ( uint16 runtime, int fade_amount , int num_sparkles ,char white );

uint32 TweenC1toC2(led_color c1, led_color c2,int amount);
int TweenC1toC2Range( uint16_t count, uint16_t x, uint32 source, uint32 target);
hsv_color RgbToHsv(led_color rgb);
led_color HsvToRgb(hsv_color hsv);
led_color hsv_to_rgb(hsv_color hsv);
hsv_color rgb_to_hsv(led_color rgb);
uint8 TweenU8toU8(uint8 source, uint8 target,int amount);
uint32 AddColor( led_color c1, led_color c2 );


#endif // __POVEFFECT_H__
/* [] END OF FILE */
