/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.FScrollbar;
import guicomponents.GComponent;
import guicomponents.GTimer;
import guicomponents.StyledString;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.font.TextHitInfo;
import java.awt.geom.GeneralPath;
import processing.core.PApplet;

public class FTextComponent
extends GComponent {
    protected float tx;
    protected float ty;
    protected float th;
    protected float tw;
    protected float ptx;
    protected float pty;
    protected float caretX;
    protected float caretY;
    protected GeneralPath gpTextDisplayArea;
    protected StyledString.TextLayoutHitInfo startTLHI = null;
    protected StyledString.TextLayoutHitInfo endTLHI = null;
    protected boolean dragging = false;
    protected final int sbPolicy;
    protected boolean autoHide = true;
    protected FScrollbar hsb;
    protected FScrollbar vsb;
    protected GTimer caretFlasher;
    protected boolean showCaret = false;

    public FTextComponent(PApplet pApplet, float f, float f2, float f3, float f4, int n) {
        super(pApplet, f, f2, f3, f4);
        this.sbPolicy = n;
        this.autoHide = (n & 0x1000) == 4096;
        this.caretFlasher = new GTimer(pApplet, this, "flashCaret", 400);
        this.caretFlasher.start();
        this.opaque = true;
    }

    void setScrollbarValues(float f, float f2) {
        float f3;
        if (this.vsb != null) {
            f3 = this.stext.getTextAreaHeight();
            this.pty = 0.0f;
            this.ptx = 0.0f;
            if (f3 < this.th) {
                this.vsb.setValue(0.0f, 1.0f);
            } else {
                this.vsb.setValue(f2 / f3, this.th / f3);
            }
        }
        if (this.hsb != null) {
            f3 = this.stext.getMaxLineLength();
            if (this.stext.getMaxLineLength() < this.tw) {
                this.hsb.setValue(0.0f, 1.0f);
            } else {
                this.hsb.setValue(f2 / f3, this.tw / f3);
            }
        }
    }

    protected boolean moveCaretStartOfLine(StyledString.TextLayoutHitInfo textLayoutHitInfo) {
        if (textLayoutHitInfo.thi.getCharIndex() == 0) {
            return false;
        }
        textLayoutHitInfo.thi = textLayoutHitInfo.tli.layout.getNextLeftHit(1);
        return true;
    }

    protected boolean moveCaretEndOfLine(StyledString.TextLayoutHitInfo textLayoutHitInfo) {
        if (textLayoutHitInfo.thi.getCharIndex() == textLayoutHitInfo.tli.nbrChars - 1) {
            return false;
        }
        textLayoutHitInfo.thi = textLayoutHitInfo.tli.layout.getNextRightHit(textLayoutHitInfo.tli.nbrChars - 1);
        return true;
    }

    protected boolean moveCaretLeft(StyledString.TextLayoutHitInfo textLayoutHitInfo) {
        TextHitInfo textHitInfo = textLayoutHitInfo.tli.layout.getNextLeftHit(textLayoutHitInfo.thi);
        if (textHitInfo == null) {
            return false;
        }
        textLayoutHitInfo.thi = textHitInfo;
        return true;
    }

    protected boolean moveCaretRight(StyledString.TextLayoutHitInfo textLayoutHitInfo) {
        TextHitInfo textHitInfo = textLayoutHitInfo.tli.layout.getNextRightHit(textLayoutHitInfo.thi);
        if (textHitInfo == null) {
            return false;
        }
        textLayoutHitInfo.thi = textHitInfo;
        return true;
    }

    public void setJustify(boolean bl) {
        this.stext.setJustify(bl);
        this.bufferInvalid = true;
    }

    public void setLocalColorScheme(int n) {
        super.setLocalColorScheme(n);
        if (this.hsb != null) {
            this.hsb.setLocalColorScheme(this.localColorScheme);
        }
        if (this.vsb != null) {
            this.vsb.setLocalColorScheme(this.localColorScheme);
        }
    }

    public void setFontNew(Font font) {
        if (font != null && font != this.fLocalFont) {
            this.fLocalFont = font;
            this.buffer.g2.setFont(this.fLocalFont);
        }
    }

    public boolean hasSelection() {
        return this.startTLHI != null && this.endTLHI != null && this.startTLHI.compareTo(this.endTLHI) != 0;
    }

    protected void calculateCaretPos(StyledString.TextLayoutHitInfo textLayoutHitInfo) {
        float[] fArray = textLayoutHitInfo.tli.layout.getCaretInfo(textLayoutHitInfo.thi);
        this.caretX = fArray[0];
        this.caretY = textLayoutHitInfo.tli.yPosInPara;
    }

    protected void processKeyTyped(KeyEvent keyEvent, boolean bl, boolean bl2) {
        char c;
        boolean bl3;
        int n = this.endTLHI.tli.startCharIndex + this.endTLHI.thi.getInsertionIndex();
        int n2 = this.startTLHI != null ? this.startTLHI.tli.startCharIndex + this.startTLHI.thi.getInsertionIndex() : n;
        int n3 = n;
        int n4 = 0;
        int n5 = 0;
        boolean bl4 = bl3 = this.startTLHI.compareTo(this.endTLHI) != 0;
        if (bl3) {
            if (n2 < n) {
                n3 = n2;
                n4 = n - n3;
            } else if (n2 > n) {
                n3 = n;
                n4 = n2 - n3;
            }
        }
        char c2 = c = keyEvent.getKeyChar();
        boolean bl5 = false;
        if (bl3) {
            this.stext.deleteCharacters(n3, n4);
            n5 = 0;
            bl5 = true;
        } else if (c == '\b') {
            if (this.stext.deleteCharacters(n3 - 1, 1)) {
                n5 = -1;
                bl5 = true;
            }
        } else if (c == '\u007f' && this.stext.deleteCharacters(n3, 1)) {
            n5 = 0;
            bl5 = true;
        }
        if (c2 >= ' ' && c2 < '\u007f' && this.stext.insertCharacters(n3, "" + keyEvent.getKeyChar())) {
            n5 = 1;
            bl5 = true;
        }
        if (bl5) {
            TextHitInfo textHitInfo;
            this.stext.getLines(this.buffer.g2);
            TextHitInfo textHitInfo2 = null;
            StyledString.TextLayoutInfo textLayoutInfo = this.stext.getTLIforCharNo(n3 += n5);
            int n6 = n3 - textLayoutInfo.startCharIndex;
            try {
                textHitInfo = textLayoutInfo.layout.getNextRightHit(n6);
            }
            catch (Exception exception) {
                textHitInfo = null;
            }
            textHitInfo2 = n6 <= 0 ? textLayoutInfo.layout.getNextLeftHit(textHitInfo) : (n6 >= textLayoutInfo.nbrChars ? textLayoutInfo.layout.getNextRightHit(textLayoutInfo.nbrChars - 1) : textLayoutInfo.layout.getNextLeftHit(textHitInfo));
            this.endTLHI.setInfo(textLayoutInfo, textHitInfo2);
            this.calculateCaretPos(this.endTLHI);
            this.startTLHI.copyFrom(this.endTLHI);
            this.bufferInvalid = true;
        }
    }

    public void flashCaret() {
        this.showCaret = !this.showCaret;
    }

    public void hsbEventHandler(FScrollbar fScrollbar) {
        this.ptx = this.hsb.getValue() * (this.stext.getMaxLineLength() + 4.0f);
        this.bufferInvalid = true;
    }

    public void vsbEventHandler(FScrollbar fScrollbar) {
        this.pty = this.vsb.getValue() * (this.stext.getTextAreaHeight() + 1.5f * this.stext.getMaxLineHeight());
        this.bufferInvalid = true;
    }
}

