/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GCScheme;
import guicomponents.GComponent;
import guicomponents.GTimer;
import java.awt.Point;
import processing.core.PApplet;

public class GActivityBar
extends GComponent {
    protected final int NBR_THUMBS = 4;
    protected int[] thumbX = new int[4];
    protected int[] thumbCol = new int[4];
    protected int[] thumbDeltaX = new int[4];
    protected int thumbY;
    protected int thumbDiameter;
    protected int trackHeight;
    protected GTimer timer;
    protected long duration;

    public GActivityBar(PApplet pApplet, int n, int n2, int n3, int n4) {
        super(pApplet, n, n2);
        this.height = Math.max(n4, 10);
        if (this.height % 2.0f != 0.0f) {
            this.height += 1.0f;
        }
        this.trackHeight = (int)(this.height - 4.0f);
        this.width = Math.max(this.height * 4.0f, (float)n3);
        this.initThumbPos();
        this.initThumbColor();
        this.timer = new GTimer(this.winApp, this, "update", 5);
        this.timer.stop();
        this.visible = false;
        this.registerAutos_DMPK(true, false, false, false);
    }

    private void initThumbColor() {
        this.thumbCol[0] = this.localColor.acbFirst;
        this.thumbCol[3] = this.localColor.acbLast;
        for (int i = 1; i < 3; ++i) {
            this.thumbCol[i] = PApplet.lerpColor((int)this.thumbCol[0], (int)this.thumbCol[3], (float)((float)i / 3.0f), (int)3);
        }
    }

    private void initThumbPos() {
        this.thumbX[0] = (int)(this.width / 2.0f + (float)(4 * this.trackHeight / 2));
        this.thumbDeltaX[0] = 1;
        for (int i = 1; i < 4; ++i) {
            this.thumbX[i] = this.thumbX[i - 1] - 1 * this.trackHeight / 2;
            this.thumbDeltaX[i] = 1;
        }
    }

    public void start(float f) {
        this.duration = f <= 0.0f ? Long.MAX_VALUE : (long)f * 1000L;
        this.initThumbPos();
        this.visible = true;
        this.timer.start();
    }

    public void stop() {
        this.visible = false;
        this.timer.stop();
    }

    public void update() {
        if (this.duration > 0L) {
            this.duration -= (long)this.timer.getInterval();
            for (int i = 0; i < 4; ++i) {
                if (this.thumbX[i] == 0 || (float)this.thumbX[i] == this.width) {
                    this.thumbDeltaX[i] = -this.thumbDeltaX[i];
                }
                int n = i;
                this.thumbX[n] = this.thumbX[n] + this.thumbDeltaX[i];
            }
        } else {
            this.visible = false;
            this.timer.stop();
        }
    }

    public void setColorScheme(int n) {
        this.localColor = GCScheme.getColor(this.winApp, n);
        this.initThumbColor();
    }

    public void draw() {
        if (!this.visible) {
            return;
        }
        this.winApp.pushStyle();
        this.winApp.style(G4P.g4pStyle);
        Point point = new Point(0, 0);
        this.calcAbsPosition(point);
        this.winApp.ellipseMode(3);
        this.winApp.rectMode(0);
        this.winApp.noStroke();
        this.winApp.fill(this.localColor.acbBorder);
        this.winApp.ellipse((float)point.x, (float)point.y + this.height / 2.0f, this.height, this.height);
        this.winApp.ellipse((float)point.x + this.width, (float)point.y + this.height / 2.0f, this.height, this.height);
        this.winApp.rect((float)point.x, (float)point.y, this.width, this.height);
        this.winApp.fill(this.localColor.acbTrack);
        this.winApp.ellipse((float)point.x, (float)point.y + this.height / 2.0f, (float)this.trackHeight, (float)this.trackHeight);
        this.winApp.ellipse((float)point.x + this.width, (float)point.y + this.height / 2.0f, (float)this.trackHeight, (float)this.trackHeight);
        this.winApp.rect((float)point.x, (float)(point.y + 2), this.width, (float)this.trackHeight);
        for (int i = 3; i >= 0; --i) {
            this.winApp.fill(this.thumbCol[i]);
            this.winApp.ellipse((float)(point.x + this.thumbX[i]), (float)point.y + this.height / 2.0f, (float)this.trackHeight, (float)this.trackHeight);
        }
        this.winApp.popStyle();
    }
}

