/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GCScheme;
import guicomponents.GComponent;
import guicomponents.GFont;
import guicomponents.GOption;
import guicomponents.GOptionGroup;
import guicomponents.GVertSlider;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import processing.core.PApplet;
import processing.core.PImage;

public class GCombo
extends GComponent {
    protected static PImage imgArrow;
    protected int startRow;
    protected int maxRows = 5;
    protected int nbrRowsToShow;
    protected GOptionGroup optGroup;
    protected GVertSlider slider;
    protected boolean expanded = false;

    public GCombo(PApplet pApplet, String[] stringArray, int n, int n2, int n3, int n4) {
        super(pApplet, n2, n3);
        this.maxRows = PApplet.constrain((int)n, (int)1, (int)25);
        this.comboCtorCore(n4);
        this.createOptions(stringArray);
        this.createSlider();
    }

    private void comboCtorCore(int n) {
        this.children = new LinkedList();
        if (imgArrow == null) {
            imgArrow = this.winApp.loadImage("combo0.png");
        }
        this.width = n;
        this.height = Math.max(this.localFont.getSize() + 4, GCombo.imgArrow.height);
        this.opaque = true;
        this.border = 1;
        this.z = 24;
        this.createEventHandler(G4P.mainWinApp, "handleComboEvents", new Class[]{GCombo.class});
        this.registerAutos_DMPK(true, true, false, false);
    }

    private void createSlider() {
        this.slider = new GVertSlider(this.winApp, (int)this.width - 10, (int)this.height, 10, this.maxRows * (int)this.height);
        this.slider.setBorder(1);
        this.slider.setVisible(false);
        this.slider.setLimits(0, 0, this.maxRows - 1);
        this.slider.addEventHandler(this, "processSliderMotion", new Class[]{GVertSlider.class});
        this.add(this.slider);
    }

    protected void createOptions(String[] stringArray) {
        this.optGroup = new GOptionGroup();
        for (int i = 0; i < stringArray.length; ++i) {
            GOption gOption = this.makeOption(stringArray[i]);
            if (gOption == null) continue;
            this.optGroup.addOption(gOption);
            this.add(gOption);
        }
        this.optGroup.setSelected(0);
        this.text = this.optGroup.selectedText();
        this.nbrRowsToShow = Math.min(stringArray.length, this.maxRows);
    }

    public GOption makeOption(String string) {
        GOption gOption = null;
        if (string != null && !string.equals("")) {
            gOption = new GOption(this.winApp, string, 0, 0, (int)this.width - 10);
            gOption.addEventHandler(this, "processOptionSelection");
            gOption.setVisible(false);
            gOption.setOpaque(true);
            gOption.setBorder(0);
        }
        return gOption;
    }

    public void setFont(String string, int n) {
        int n2 = this.textWidth;
        int n3 = this.localFont.getSize();
        this.localFont = GFont.getFont(this.winApp, string, n);
        if (n > n3) {
            this.height += (float)(n - n3);
        }
        this.setText(this.text);
        if (this.textWidth > n2) {
            this.width += (float)(this.textWidth - n2);
        }
        ArrayList<GOption> arrayList = this.optGroup.getOptions();
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList.get(i).setWidth((int)this.width - 10);
        }
        this.slider.setX((int)this.width - 10);
    }

    public void setColorScheme(int n) {
        this.localColor = GCScheme.getColor(this.winApp, n);
        this.slider.localColor = GCScheme.getColor(this.winApp, n);
        ArrayList<GOption> arrayList = this.optGroup.getOptions();
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList.get((int)i).localColor = GCScheme.getColor(this.winApp, n);
        }
    }

    public void processSliderMotion(GVertSlider gVertSlider) {
        this.startRow = this.slider.getValue();
    }

    public void processOptionSelection(GOption gOption, GOption gOption2) {
        this.text = this.optGroup.selectedText();
        if (gOption != gOption2) {
            this.fireEvent();
        }
        this.shrink();
        this.loseFocus(null);
    }

    public void setSelected(int n) {
        this.optGroup.setSelected(n);
        this.setText(this.optGroup.selectedText());
    }

    public void setSelected(String string) {
        this.optGroup.setSelected(string);
        this.setText(this.optGroup.selectedText());
    }

    public boolean addOption(String string) {
        GOption gOption = this.makeOption(string);
        boolean bl = this.optGroup.addOption(gOption);
        if (bl) {
            this.add(gOption);
        }
        return bl;
    }

    public boolean addOption(int n, String string) {
        GOption gOption = this.makeOption(string);
        boolean bl = this.optGroup.addOption(n, gOption);
        if (bl) {
            this.add(gOption);
        }
        return bl;
    }

    public void removeOption(int n) {
        GOption gOption = this.optGroup.removeOption(n);
        if (gOption != null) {
            this.remove(gOption);
        }
    }

    public void removeOption(String string) {
        GOption gOption = this.optGroup.removeOption(string);
        if (gOption != null) {
            this.remove(gOption);
        }
    }

    public int getNbrOptions() {
        return this.optGroup.getOptions().size();
    }

    public void removeAllOptions() {
        this.optGroup.getOptions().clear();
        this.setText("");
    }

    public void setOptions(String[] stringArray, int n) {
        this.createOptions(stringArray);
        this.setSelected(n);
    }

    public boolean isOver(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        Point point = new Point(0, 0);
        this.calcAbsPosition(point);
        if (this.expanded) {
            n6 = point.x;
            n5 = point.y;
            n4 = n6 + (int)this.width;
            n3 = n5 + (this.nbrRowsToShow + 1) * (int)this.height;
        } else {
            n6 = point.x + (int)this.width - GCombo.imgArrow.width - 4;
            n5 = point.y + ((int)this.height - GCombo.imgArrow.height) / 2 + 2;
            n4 = n6 + GCombo.imgArrow.width;
            n3 = n5 + GCombo.imgArrow.height;
        }
        return n >= n6 && n <= n4 && n2 >= n5 && n2 <= n3;
    }

    public void shrink() {
        this.expanded = false;
        for (int i = 0; i < this.optGroup.size(); ++i) {
            this.optGroup.get((int)i).visible = false;
        }
        this.slider.visible = false;
    }

    public void expand() {
        this.expanded = true;
        this.startRow = 0;
        this.slider.setLimits(0, 0, this.optGroup.size() - this.maxRows);
        this.takeFocus();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void loseFocus(GComponent gComponent) {
        if (!this.children.contains(gComponent)) {
            this.shrink();
            focusIsWith = null;
        }
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        if (!this.visible || !this.enabled) {
            return;
        }
        boolean bl = this.isOver(this.winApp.mouseX, this.winApp.mouseY);
        if (bl) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                if (focusIsWith != this && bl && this.z >= GCombo.focusObjectZ()) {
                    this.takeFocus();
                    break;
                }
                if (focusIsWith != this || bl) break;
                this.loseFocus(null);
                break;
            }
            case 500: {
                if (focusIsWith != this || !bl) break;
                if (this.expanded) {
                    this.shrink();
                } else {
                    this.expand();
                }
                this.mdy = Integer.MAX_VALUE;
                this.mdx = Integer.MAX_VALUE;
            }
        }
    }

    public void draw() {
        if (!this.visible) {
            return;
        }
        this.winApp.pushStyle();
        this.winApp.style(G4P.g4pStyle);
        Point point = new Point(0, 0);
        this.calcAbsPosition(point);
        if (this.border == 0) {
            this.winApp.noStroke();
        } else {
            this.winApp.strokeWeight((float)this.border);
            this.winApp.stroke(this.localColor.txfBorder);
        }
        if (this.opaque) {
            this.winApp.fill(this.localColor.txfBack);
        } else {
            this.winApp.noFill();
        }
        this.winApp.rect((float)point.x, (float)point.y, this.width, this.height);
        this.winApp.noStroke();
        this.winApp.fill(this.localColor.txfFont);
        this.winApp.textFont(this.localFont, (float)this.localFont.getSize());
        this.winApp.text(this.text, (float)(point.x + 4), (float)(point.y - 2) + (this.height - (float)this.localFont.getSize()) / 2.0f, this.width - 16.0f, this.height);
        this.winApp.fill(this.winApp.color(255, 255));
        if (imgArrow != null) {
            this.winApp.image(imgArrow, (float)point.x + this.width - (float)GCombo.imgArrow.width - 1.0f, (float)point.y + (this.height - (float)GCombo.imgArrow.height) / 2.0f);
        }
        if (this.expanded) {
            this.winApp.noStroke();
            this.winApp.fill(this.localColor.txfBack);
            this.winApp.rect((float)point.x, (float)point.y + this.height, this.width, (float)this.nbrRowsToShow * this.height);
            for (int i = 0; i < this.optGroup.size(); ++i) {
                GOption gOption = this.optGroup.get(i);
                if (i >= this.startRow && i < this.startRow + this.nbrRowsToShow) {
                    gOption.visible = true;
                    gOption.y = this.height * (float)(i - this.startRow + 1);
                    gOption.draw();
                    continue;
                }
                gOption.visible = false;
            }
            if (this.border != 0) {
                this.winApp.strokeWeight((float)this.border);
                this.winApp.stroke(this.localColor.txfBorder);
                this.winApp.noFill();
                this.winApp.rect((float)point.x, (float)point.y + this.height, this.width, (float)this.nbrRowsToShow * this.height);
            }
            if (this.optGroup.size() > this.maxRows) {
                this.slider.setVisible(true);
                this.slider.draw();
            }
        }
        this.winApp.popStyle();
    }

    public int selectedIndex() {
        return this.optGroup.selectedIndex();
    }

    public String selectedText() {
        return this.optGroup.selectedText();
    }

    public int deselectedIndex() {
        return this.optGroup.deselectedIndex();
    }

    public String deselectedText() {
        return this.optGroup.deselectedText();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.tag + "   (" + this.z + ")\n");
        if (this.children != null) {
            for (GComponent gComponent : this.children) {
                stringBuilder.append("\t" + gComponent + "\n");
            }
        }
        return new String(stringBuilder);
    }
}

