/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.FCScheme;
import guicomponents.G4P;
import guicomponents.GCScheme;
import guicomponents.GConstants;
import guicomponents.GFont;
import guicomponents.GMessenger;
import guicomponents.HotSpot;
import guicomponents.StyledString;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PFont;
import processing.core.PGraphicsJava2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GComponent
implements PConstants,
GConstants,
Comparable<Object> {
    private static int control_mode = 0;
    protected static GComponent focusIsWith = null;
    protected static GComponent keyFocusIsWith = null;
    protected static GComponent cursorIsOver;
    protected int mdx = Integer.MAX_VALUE;
    protected int mdy = Integer.MAX_VALUE;
    protected Font fLocalFont = fGlobalFont;
    public static GCScheme globalColor;
    public GCScheme localColor;
    public static int globalColorScheme;
    protected int localColorScheme = globalColorScheme;
    protected int[] palette = null;
    protected Color[] jpalette = null;
    public static Font fGlobalFont;
    public static PFont globalFont;
    public PFont localFont;
    protected static int componentNo;
    protected static final int PADH = 4;
    protected static final int PADV = 2;
    protected static final int Z_PANEL = 1024;
    protected static final int Z_STICKY = 0;
    protected static final int Z_SLIPPY = 24;
    protected PApplet winApp;
    protected GComponent parent = null;
    protected LinkedList<GComponent> children = null;
    protected HotSpot[] hotspots = null;
    protected int currSpot = -1;
    protected Object eventHandlerObject = null;
    protected Method eventHandlerMethod = null;
    protected String eventHandlerMethodName;
    protected String text = "";
    protected StyledString stext = null;
    protected int textWidth;
    protected int textAlignHorz = 1;
    protected int textAlignVert = 64;
    protected int alignX = 0;
    protected int alignY = 0;
    protected float x;
    protected float y;
    protected float width;
    protected float height;
    protected float halfWidth;
    protected float halfHeight;
    protected float cx;
    protected float cy;
    protected float rotAngle;
    protected double[] temp = new double[2];
    protected float ox;
    protected float oy;
    public int z = 0;
    public String tag;
    public int tagNo;
    protected boolean visible = true;
    protected boolean enabled = true;
    protected boolean available = true;
    protected int border = 0;
    protected boolean opaque = true;
    public int eventType = 0;
    protected PGraphicsJava2D buffer = null;
    protected boolean bufferInvalid = true;
    protected boolean regDraw = false;
    protected boolean regMouse = false;
    protected boolean regPre = false;
    protected boolean regKey = false;

    public static void ctrlMode(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                control_mode = n;
            }
        }
    }

    public static int getCtrlMode() {
        return control_mode;
    }

    public void setLocalColorScheme(int n) {
        if (this.localColorScheme != (n = Math.abs(n) % 16) || this.palette == null) {
            this.localColorScheme = n;
            this.palette = FCScheme.getColor(this.winApp, this.localColorScheme);
            this.jpalette = FCScheme.getJavaColor(this.winApp, this.localColorScheme);
            this.bufferInvalid = true;
        }
    }

    protected int whichHotSpot(float f, float f2) {
        if (this.hotspots == null) {
            return -1;
        }
        int n = -1;
        for (int i = 0; i < this.hotspots.length; ++i) {
            if (!this.hotspots[i].contains(f, f2)) continue;
            n = this.hotspots[i].id;
            break;
        }
        return n;
    }

    protected int getCurrHotSpot() {
        return this.currSpot;
    }

    private GComponent() {
    }

    public GComponent(PApplet pApplet, int n, int n2) {
        this.winApp = pApplet;
        this.tag = "#" + PApplet.nf((int)componentNo++, (int)5) + " " + this.getClass().getSimpleName();
        this.z = 0;
        if (globalColor == null) {
            globalColor = GCScheme.getColor(pApplet);
        }
        this.localColor = new GCScheme(globalColor);
        if (globalFont == null) {
            globalFont = GFont.getDefaultFont(pApplet);
        }
        this.localFont = globalFont;
        this.x = n;
        this.y = n2;
        G4P.addComponent(this.winApp, this);
    }

    public GComponent(PApplet pApplet, float f, float f2, float f3, float f4) {
        this.winApp = pApplet;
        this.setPositionAndSize(f, f2, f3, f4);
        this.rotAngle = 0.0f;
        this.z = 0;
        this.palette = FCScheme.getColor(this.winApp, this.localColorScheme);
        this.jpalette = FCScheme.getJavaColor(this.winApp, this.localColorScheme);
        this.fLocalFont = fGlobalFont;
        G4P.addComponent(this.winApp, this);
    }

    protected void setPositionAndSize(float f, float f2, float f3, float f4) {
        switch (control_mode) {
            case 0: {
                this.x = f;
                this.y = f2;
                this.width = f3;
                this.height = f4;
                this.halfWidth = this.width / 2.0f;
                this.halfHeight = this.height / 2.0f;
                this.cx = this.x + this.halfWidth;
                this.cy = this.y + this.halfHeight;
                break;
            }
            case 1: {
                this.x = f;
                this.y = f2;
                this.width = f3 - f;
                this.height = f4 - f2;
                this.halfWidth = this.width / 2.0f;
                this.halfHeight = this.height / 2.0f;
                this.cx = this.x + this.halfWidth;
                this.cy = this.y + this.halfHeight;
                break;
            }
            case 3: {
                this.cx = f;
                this.cy = f2;
                this.width = f3;
                this.height = f4;
                this.halfWidth = this.width / 2.0f;
                this.halfHeight = this.height / 2.0f;
                this.x = this.cx - this.halfWidth;
                this.y = this.cy + this.halfHeight;
            }
        }
    }

    public void addAbsoluteControl(GComponent gComponent) {
        gComponent.x -= this.x;
        gComponent.y -= this.y;
        gComponent.cx -= this.x;
        gComponent.cy -= this.y;
        gComponent.parent = this;
        this.children.addLast(gComponent);
    }

    public void addRelativeControl(GComponent gComponent) {
        gComponent.cx = gComponent.x + gComponent.halfWidth - this.halfWidth;
        gComponent.cy = gComponent.y + gComponent.halfHeight - this.halfHeight;
        gComponent.parent = this;
        this.children.addLast(gComponent);
    }

    public void addCompoundControl(GComponent gComponent, float f, float f2, float f3) {
        if (f3 == 0.0f) {
            f3 = gComponent.rotAngle;
        }
        gComponent.x = f;
        gComponent.y = f2;
        switch (control_mode) {
            case 0: 
            case 1: {
                gComponent.temp[0] = gComponent.halfWidth;
                gComponent.temp[1] = gComponent.halfHeight;
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.setToRotation(f3);
                affineTransform.transform(gComponent.temp, 0, gComponent.temp, 0, 1);
                gComponent.cx = (float)gComponent.temp[0] + f - this.halfWidth;
                gComponent.cy = (float)gComponent.temp[1] + f2 - this.halfHeight;
                break;
            }
        }
        gComponent.rotAngle = f3;
        gComponent.parent = this;
        this.winApp.unregisterDraw((Object)gComponent);
        gComponent.regDraw = false;
        gComponent.setZ(this.z);
        if (this.children == null) {
            this.children = new LinkedList();
        }
        this.children.addLast(gComponent);
        Collections.sort(this.children, new Z_Order());
    }

    public boolean addXXX(GComponent gComponent) {
        if (gComponent == null || this.children.contains(gComponent)) {
            if (G4P.messages) {
                System.out.println("Either the child component doesn't exist or has already been added to this component");
            }
            return false;
        }
        gComponent.parent = this;
        this.children.add(gComponent);
        this.winApp.unregisterDraw((Object)gComponent);
        gComponent.regDraw = false;
        if (this.localColor.getAlpha() < 255) {
            gComponent.setAlpha(this.localColor.getAlpha());
        }
        Collections.sort(this.children, new Z_Order());
        return true;
    }

    public void setRotation(float f) {
        this.rotAngle = f;
    }

    public AffineTransform getTransform(AffineTransform affineTransform) {
        if (this.parent != null) {
            affineTransform = this.parent.getTransform(affineTransform);
        }
        affineTransform.translate(this.cx, this.cy);
        affineTransform.rotate(this.rotAngle);
        return affineTransform;
    }

    protected void calcTransformedOrigin(float f, float f2) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform = this.getTransform(affineTransform);
        this.temp[0] = f;
        this.temp[1] = f2;
        try {
            affineTransform.inverseTransform(this.temp, 0, this.temp, 0, 1);
            this.ox = (float)this.temp[0] + this.halfWidth;
            this.oy = (float)this.temp[1] + this.halfHeight;
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
    }

    public boolean contains(float f, float f2) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform = this.getTransform(affineTransform);
        this.temp[0] = f;
        this.temp[1] = f2;
        try {
            affineTransform.inverseTransform(this.temp, 0, this.temp, 0, 1);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
            return false;
        }
        this.ox = (float)this.temp[0] + this.halfWidth;
        this.oy = (float)this.temp[1] + this.halfHeight;
        boolean bl = this.ox >= 0.0f && this.ox <= this.width && this.oy >= 0.0f && this.oy <= this.height;
        return bl;
    }

    protected void createEventHandler(Object object, String string, Class[] classArray) {
        try {
            this.eventHandlerMethod = object.getClass().getMethod(string, classArray);
            this.eventHandlerObject = object;
            this.eventHandlerMethodName = string;
        }
        catch (Exception exception) {
            GMessenger.message(0x1000001, this, new Object[]{string, classArray});
            this.eventHandlerObject = null;
        }
    }

    public void addEventHandler(Object object, String string) {
        try {
            this.eventHandlerObject = object;
            this.eventHandlerMethodName = string;
            this.eventHandlerMethod = object.getClass().getMethod(string, this.getClass());
        }
        catch (Exception exception) {
            GMessenger.message(0x1000002, this, new Object[]{string, new Class[]{this.getClass()}});
            this.eventHandlerObject = null;
            this.eventHandlerMethodName = "";
        }
    }

    public void addEventHandler(Object object, String string, Class[] classArray) {
        if (classArray == null) {
            classArray = new Class[]{};
        }
        try {
            this.eventHandlerObject = object;
            this.eventHandlerMethodName = string;
            this.eventHandlerMethod = object.getClass().getMethod(string, classArray);
        }
        catch (Exception exception) {
            GMessenger.message(0x1000002, this.eventHandlerObject, new Object[]{string, classArray});
            this.eventHandlerObject = null;
            this.eventHandlerMethodName = "";
        }
    }

    protected void fireEvent() {
        if (this.eventHandlerMethod != null) {
            try {
                this.eventHandlerMethod.invoke(this.eventHandlerObject, this);
            }
            catch (Exception exception) {
                GMessenger.message(-2130706429, this.eventHandlerObject, new Object[]{this.eventHandlerMethodName, exception});
            }
        }
    }

    public PApplet getPApplet() {
        return this.winApp;
    }

    protected void bringToFront() {
        if (this.parent != null) {
            this.parent.bringToFront();
        }
    }

    protected void takeFocus() {
        if (focusIsWith != null && focusIsWith != this) {
            focusIsWith.loseFocus(this);
        }
        focusIsWith = this;
        keyFocusIsWith = null;
        this.bringToFront();
    }

    protected void loseFocus(GComponent gComponent) {
        if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        focusIsWith = gComponent;
    }

    public void setFocus(boolean bl) {
        if (bl) {
            this.takeFocus();
        } else {
            this.loseFocus(null);
        }
    }

    public boolean hasFocus() {
        return this == focusIsWith;
    }

    protected boolean hasParentFocus() {
        if (this == focusIsWith) {
            return true;
        }
        if (this.parent != null) {
            this.parent.hasParentFocus();
        }
        return false;
    }

    protected boolean hasChildFocus() {
        if (this == focusIsWith) {
            return true;
        }
        if (this.children != null) {
            boolean bl = false;
            for (GComponent gComponent : this.children) {
                bl |= gComponent.hasChildFocus();
            }
            return bl;
        }
        return false;
    }

    public boolean hasKeyFocus() {
        return this == keyFocusIsWith;
    }

    public static GComponent getFocusObject() {
        return focusIsWith;
    }

    protected static int focusObjectZ() {
        return focusIsWith == null ? -1 : GComponent.focusIsWith.z;
    }

    protected boolean isChildOf(GComponent gComponent) {
        if (this == gComponent) {
            return true;
        }
        return this.parent == null ? false : this.parent.isChildOf(gComponent);
    }

    public int getEventType() {
        return this.eventType;
    }

    protected boolean mouseHasMoved(int n, int n2) {
        return this.mdx != n || this.mdy != n2;
    }

    public boolean add(GComponent gComponent) {
        if (gComponent == null || this.children.contains(gComponent)) {
            if (G4P.messages) {
                System.out.println("Either the child component doesn't exist or has already been added to this component");
            }
            return false;
        }
        gComponent.parent = this;
        this.children.add(gComponent);
        gComponent.setZ(this.z);
        this.winApp.unregisterDraw((Object)gComponent);
        gComponent.regDraw = false;
        if (this.localColor.getAlpha() < 255) {
            gComponent.setAlpha(this.localColor.getAlpha());
        }
        Collections.sort(this.children, new Z_Order());
        return true;
    }

    protected void setZ(int n) {
        this.z += n;
        if (this.children != null) {
            for (GComponent gComponent : this.children) {
                gComponent.setZ(n);
            }
        }
    }

    public void remove(GComponent gComponent) {
        this.children.remove(gComponent);
        gComponent.unsetZ(this.z);
    }

    protected void unsetZ(int n) {
        this.z -= n;
        if (this.children != null) {
            for (GComponent gComponent : this.children) {
                gComponent.unsetZ(n);
            }
        }
    }

    public void pre() {
    }

    public void draw() {
    }

    public void mouseEvent(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    protected void registerAutos_DMPK(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (bl && G4P.isAutoDrawOn(this.winApp)) {
            this.winApp.registerDraw((Object)this);
            this.regDraw = true;
        }
        if (bl2) {
            this.winApp.registerMouseEvent((Object)this);
            this.regMouse = true;
        }
        if (bl3) {
            this.winApp.registerPre((Object)this);
            this.regPre = true;
        }
        if (bl4) {
            this.winApp.registerKeyEvent((Object)this);
            this.regKey = true;
        }
    }

    public void dispose() {
        if (this.regDraw) {
            this.winApp.unregisterDraw((Object)this);
        }
        if (this.regMouse) {
            this.winApp.unregisterMouseEvent((Object)this);
        }
        if (this.regPre) {
            this.winApp.unregisterPre((Object)this);
        }
        if (this.regKey) {
            this.winApp.unregisterKeyEvent((Object)this);
        }
        G4P.dumpComponent(this);
    }

    public void changeWindow(PApplet pApplet) {
        if (this.regDraw) {
            this.winApp.unregisterDraw((Object)this);
            pApplet.registerDraw((Object)this);
        }
        if (this.regPre) {
            this.winApp.unregisterPre((Object)this);
            pApplet.registerPre((Object)this);
        }
        if (this.regMouse) {
            this.winApp.unregisterMouseEvent((Object)this);
            pApplet.registerMouseEvent((Object)this);
        }
        if (this.regKey) {
            this.winApp.unregisterKeyEvent((Object)this);
            pApplet.registerKeyEvent((Object)this);
        }
        this.winApp = pApplet;
        if (this.children != null && !this.children.isEmpty()) {
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                ((GComponent)iterator.next()).changeWindow(pApplet);
            }
        }
    }

    public boolean isOver(int n, int n2) {
        Point point = new Point(0, 0);
        this.calcAbsPosition(point);
        return n >= point.x && (float)n <= (float)point.x + this.width && n2 >= point.y && (float)n2 <= (float)point.y + this.height;
    }

    public void calcAbsPosition(Point point) {
        if (this.parent != null) {
            this.parent.calcAbsPosition(point);
        }
        point.x = (int)((float)point.x + this.x);
        point.y = (int)((float)point.y + this.y);
    }

    public GComponent getParent() {
        return this.parent;
    }

    public void setColorScheme(int n) {
        this.localColor = GCScheme.getColor(this.winApp, n);
    }

    public String getText() {
        return this.text;
    }

    public StyledString getStyledText() {
        return this.stext;
    }

    public void setTextNew(String string) {
        if (string == null || string.length() == 0) {
            string = "";
        }
        this.stext = new StyledString(string);
    }

    public void setTextNew(String string, int n) {
        if (string == null || string.length() == 0) {
            string = "";
        }
        this.stext = new StyledString(string);
    }

    public void setText(String string) {
        this.text = string;
        this.winApp.textFont(this.localFont, (float)this.localFont.getSize());
        this.textWidth = (int)this.winApp.textWidth(string);
        this.calcAlignX();
        this.calcAlignY();
    }

    public void setText(String string, int n) {
        this.text = string;
        this.winApp.textFont(this.localFont, (float)this.localFont.getSize());
        this.textWidth = (int)this.winApp.textWidth(string);
        this.setTextAlign(n);
    }

    public void setTextAlign(int n) {
        int n2 = n & 7;
        int n3 = n & 0x70;
        if (n2 == 1 || n2 == 4 || n2 == 2) {
            this.textAlignHorz = n2;
            this.calcAlignX();
        }
        if (n3 == 16 || n3 == 64 || n3 == 32) {
            this.textAlignVert = n3;
            this.calcAlignY();
        }
    }

    public void setFont(String string, int n) {
    }

    public void setFontNew(Font font) {
        this.fLocalFont = font;
    }

    public void setFontNew(PFont pFont) {
        this.fLocalFont = (Font)pFont.getNative();
    }

    protected void calcAlignX() {
        switch (this.textAlignHorz) {
            case 1: {
                this.alignX = this.border + 4;
                break;
            }
            case 2: {
                this.alignX = (int)(this.width - (float)this.textWidth - (float)this.border - 4.0f);
                break;
            }
            case 4: {
                this.alignX = (int)((this.width - (float)this.textWidth) / 2.0f);
            }
        }
    }

    protected void calcAlignY() {
        switch (this.textAlignVert) {
            case 16: {
                this.alignY = this.border + 2;
                break;
            }
            case 32: {
                this.alignY = (int)(this.height - (float)this.localFont.getSize() - (float)this.border - 2.0f);
                break;
            }
            case 64: {
                this.alignY = (int)((this.height - (float)this.localFont.getSize() - (float)this.border - 2.0f) / 2.0f);
            }
        }
    }

    public void setXY(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void setX(int n) {
        this.x = n;
    }

    public void setY(int n) {
        this.y = n;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float f) {
        this.width = f;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (this.children != null) {
            for (GComponent gComponent : this.children) {
                gComponent.setEnabled(bl);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setVisible(boolean bl) {
        if (!bl && focusIsWith == this) {
            this.loseFocus(null);
        }
        this.visible = bl;
    }

    public void setBorder(int n) {
        this.border = n;
        this.calcAlignX();
    }

    public int getBorder() {
        return this.border;
    }

    public void setOpaque(boolean bl) {
        this.opaque = bl;
    }

    public boolean getOpaque() {
        return this.opaque;
    }

    public void setAlpha(int n) {
        this.localColor.setAlpha(n);
    }

    public int getAlpha() {
        return this.localColor.getAlpha();
    }

    public String toString() {
        return this.tag + "   (" + this.z + ")";
    }

    @Override
    public int compareTo(Object object) {
        return new Integer(this.hashCode()).compareTo(new Integer(object.hashCode()));
    }

    static {
        globalColorScheme = 6;
        fGlobalFont = new Font("Dialog", 0, 11);
        componentNo = 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Z_Order
    implements Comparator<GComponent> {
        @Override
        public int compare(GComponent gComponent, GComponent gComponent2) {
            if (gComponent.z != gComponent2.z) {
                return new Integer(gComponent.z).compareTo(new Integer(gComponent2.z));
            }
            return new Integer((int)(-gComponent.y)).compareTo(new Integer((int)(-gComponent2.y)));
        }
    }
}

