/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GComponent;
import java.awt.Point;
import java.awt.event.MouseEvent;
import processing.core.PApplet;
import processing.core.PImage;

public class GImageButton
extends GComponent {
    public static final int OFF = 0;
    public static final int OVER = 1;
    public static final int DOWN = 2;
    protected static PImage[] noImage = null;
    protected int status;
    protected PImage[] bimage = new PImage[3];
    protected PImage mask;
    protected boolean reportAllButtonEvents = false;

    public GImageButton(PApplet pApplet, String string, String string2, int n, int n2, int n3) {
        super(pApplet, n2, n3);
        this.mask = this.getMask(string);
        this.bimage = this.getImages(string2, n);
        this.width = this.bimage[0].width;
        this.height = this.bimage[0].height;
        this.z = 24;
        this.createEventHandler(G4P.mainWinApp, "handleImageButtonEvents", new Class[]{GImageButton.class});
        this.registerAutos_DMPK(true, true, false, false);
    }

    public GImageButton(PApplet pApplet, String string, String[] stringArray, int n, int n2) {
        super(pApplet, n, n2);
        this.mask = this.getMask(string);
        this.bimage = this.getImages(stringArray);
        this.width = this.bimage[0].width;
        this.height = this.bimage[0].height;
        this.z = 24;
        this.createEventHandler(G4P.mainWinApp, "handleImageButtonEvents", new Class[]{GImageButton.class});
        this.registerAutos_DMPK(true, true, false, false);
    }

    protected PImage[] getImages(String string, int n) {
        n = PApplet.constrain((int)n, (int)1, (int)3);
        PImage[] pImageArray = new PImage[3];
        PImage pImage = this.winApp.loadImage(string);
        if (string == null || pImage == null) {
            this.missingFile(string);
            pImageArray = this.getErrorImage();
        } else {
            int n2;
            int n3 = pImage.width / n;
            for (n2 = 0; n2 < n; ++n2) {
                pImageArray[n2] = new PImage(n3, pImage.height, 2);
                pImageArray[n2].copy(pImage, n2 * n3, 0, n3, pImage.height, 0, 0, n3, pImage.height);
            }
            for (n2 = n; n2 < 3; ++n2) {
                pImageArray[n2] = pImageArray[n - 1];
            }
        }
        return pImageArray;
    }

    protected PImage[] getImages(String[] stringArray) {
        PImage[] pImageArray = new PImage[3];
        int n = 0;
        if (stringArray == null || stringArray.length < 1) {
            if (G4P.messages) {
                System.out.println("Error: you have not provided a list of image files for GImageButton");
            }
        } else {
            for (n = 0; n < stringArray.length; ++n) {
                pImageArray[n] = this.winApp.loadImage(stringArray[n]);
                if (pImageArray[n] != null) continue;
                this.missingFile(stringArray[n]);
            }
            for (int i = n; i < 3; ++i) {
                pImageArray[i] = pImageArray[i - 1];
            }
        }
        if (pImageArray[0] == null) {
            pImageArray = this.getErrorImage();
        }
        return pImageArray;
    }

    protected PImage getMask(String string) {
        PImage pImage = null;
        if (string != null && (pImage = this.winApp.loadImage(string)) == null) {
            this.missingFile(string);
        }
        return pImage;
    }

    protected void missingFile(String string) {
        if (G4P.messages) {
            System.out.println("\nUnable to locate file '" + string + "' for GImageButton");
        }
    }

    protected PImage[] getErrorImage() {
        if (noImage == null) {
            noImage = this.getImages("noimage3.png", 3);
        }
        return noImage;
    }

    public boolean isOver(int n, int n2) {
        Point point = new Point(0, 0);
        this.calcAbsPosition(point);
        if (n >= point.x && (float)n <= (float)point.x + this.width && n2 >= point.y && (float)n2 <= (float)point.y + this.height) {
            int n3;
            int n4;
            int n5 = n - point.x;
            int n6 = n2 - point.y;
            if (this.mask != null ? (n4 = this.mask.get(n5, n6) & 0xFFFFFF) == 0xFFFFFF : this.winApp.alpha(n3 = this.bimage[0].get(n5, n6)) != 0.0f) {
                return true;
            }
        }
        return false;
    }

    public void draw() {
        if (!this.visible) {
            return;
        }
        this.winApp.pushStyle();
        this.winApp.imageMode(0);
        Point point = new Point(0, 0);
        this.calcAbsPosition(point);
        if (this.bimage != null && this.bimage[this.status] != null) {
            this.winApp.image(this.bimage[this.status], (float)point.x, (float)point.y);
        }
        this.winApp.popStyle();
    }

    public void fireAllEvents(boolean bl) {
        this.reportAllButtonEvents = bl;
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        if (!this.visible || !this.enabled) {
            return;
        }
        boolean bl = this.isOver(this.winApp.mouseX, this.winApp.mouseY);
        if (bl) {
            cursorIsOver = this;
        } else if (cursorIsOver == this) {
            cursorIsOver = null;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                if (focusIsWith == this || !bl || this.z <= GImageButton.focusObjectZ()) break;
                this.mdx = this.winApp.mouseX;
                this.mdy = this.winApp.mouseY;
                this.status = 2;
                this.takeFocus();
                this.eventType = 770;
                if (!this.reportAllButtonEvents) break;
                this.fireEvent();
                break;
            }
            case 500: {
                if (focusIsWith != this) break;
                this.status = 0;
                this.loseFocus(null);
                this.eventType = 769;
                this.fireEvent();
                break;
            }
            case 502: {
                if (focusIsWith != this || !this.mouseHasMoved(this.winApp.mouseX, this.winApp.mouseY)) break;
                this.loseFocus(null);
                if (this.isOver(this.winApp.mouseX, this.winApp.mouseY)) {
                    this.eventType = 769;
                    this.fireEvent();
                } else if (this.reportAllButtonEvents) {
                    this.eventType = 771;
                    this.fireEvent();
                }
                this.status = 0;
                break;
            }
            case 503: {
                this.status = this.isOver(this.winApp.mouseX, this.winApp.mouseY) ? 1 : 0;
            }
        }
    }
}

