/*
 * Decompiled with CFR 0.152.
 */
package guicomponents;

import guicomponents.G4P;
import guicomponents.GKnob;
import java.awt.Point;
import processing.core.PApplet;

public class GKnobOval
extends GKnob {
    protected Point p = new Point();

    public GKnobOval(PApplet pApplet, int n, int n2, int n3, int n4, int n5, int n6) {
        super(pApplet, n, n2, n3, n4, n5, n6);
        this.start = this.convertRealAngleToOvalAngle(PApplet.radians((float)this.aLow), this.sizeRadX, this.sizeRadY);
        this.end = this.convertRealAngleToOvalAngle(PApplet.radians((float)this.aHigh), this.sizeRadX, this.sizeRadY);
        this.calcTickMarkerPositions(this.nbrTickMarks);
    }

    public void draw() {
        float f;
        if (!this.visible) {
            return;
        }
        this.p.move(0, 0);
        this.calcAbsPosition(this.p);
        this.p.x = (int)((float)this.p.x + this.cx);
        this.p.y = (int)((float)this.p.y + this.cy);
        float f2 = PApplet.radians((float)this.needleAngle);
        this.winApp.pushMatrix();
        this.winApp.translate((float)this.p.x, (float)this.p.y);
        this.winApp.pushStyle();
        this.winApp.style(G4P.g4pStyle);
        if (this.bezelWidth > 0) {
            this.winApp.noStroke();
            if (this.rotArcOnly) {
                this.winApp.fill(this.winApp.color(128, 128));
            } else {
                this.winApp.fill(this.winApp.color(128, 48));
                this.winApp.ellipse(0.0f, 0.0f, 2.0f * this.sizeRadX, 2.0f * this.sizeRadY);
                this.winApp.fill(this.winApp.color(128, 80));
            }
            this.winApp.arc(0.0f, 0.0f, 2.0f * this.sizeRadX, 2.0f * this.sizeRadY, this.start, this.end);
            if (this.valueTrackVisible) {
                this.winApp.fill(this.localColor.knobTrack);
                this.winApp.noStroke();
                f = this.convertRealAngleToOvalAngle(f2, this.sizeRadX, this.sizeRadY);
                this.winApp.arc(0.0f, 0.0f, (float)(2 * this.barRadX), (float)(2 * this.barRadY), this.start, f);
            }
            this.winApp.stroke(this.localColor.knobBorder);
            this.winApp.stroke(1.2f);
            for (int i = 0; i < this.mark.length; ++i) {
                if (i == 0 || i == this.mark.length - 1) {
                    this.winApp.strokeWeight(1.5f);
                } else {
                    this.winApp.strokeWeight(1.2f);
                }
                this.winApp.line((float)this.mark[i][0].x, (float)this.mark[i][0].y, (float)this.mark[i][1].x, (float)this.mark[i][1].y);
            }
        }
        if (this.knobRadX > 0) {
            this.winApp.stroke(this.localColor.knobBorder);
            this.winApp.strokeWeight(1.2f);
            this.winApp.fill(this.localColor.knobFill);
            if (this.rotArcOnly) {
                this.winApp.arc(0.0f, 0.0f, (float)(2 * this.knobRadX), (float)(2 * this.knobRadY), this.start, this.end);
                this.winApp.stroke(this.localColor.knobBorder);
                this.winApp.strokeWeight(1.2f);
                this.winApp.line(0.0f, 0.0f, (float)this.mark[0][0].x, (float)this.mark[0][0].y);
                this.winApp.line(0.0f, 0.0f, (float)this.mark[this.mark.length - 1][0].x, (float)this.mark[this.mark.length - 1][0].y);
            } else {
                this.winApp.ellipse(0.0f, 0.0f, (float)(2 * this.knobRadX), (float)(2 * this.knobRadY));
            }
            this.winApp.stroke(this.localColor.knobNeedle);
            this.winApp.strokeWeight(2.0f);
            f = this.convertRealAngleToOvalAngle(f2, this.sizeRadX, this.sizeRadY);
            float f3 = (float)((double)this.sizeRadX * Math.cos(f));
            float f4 = (float)((double)this.sizeRadY * Math.sin(f));
            this.calcCircumferencePosition(this.p, f3, f4, this.knobRadX, this.knobRadY);
            this.winApp.line(0.0f, 0.0f, (float)this.p.x, (float)this.p.y);
        }
        this.winApp.popStyle();
        this.winApp.popMatrix();
    }

    public boolean isOver(int n, int n2) {
        this.p.move(0, 0);
        this.calcAbsPosition(this.p);
        int n3 = (int)((float)(n - this.p.x) - this.cx);
        int n4 = (int)((float)(n2 - this.p.y) - this.cy);
        float f = (float)n3 / this.sizeRadX;
        float f2 = (float)n4 / this.sizeRadY;
        boolean bl = f * f + f2 * f2 < 1.0f;
        return bl;
    }

    public boolean isOverRotArc(int n, int n2) {
        boolean bl;
        this.p.move(0, 0);
        this.calcAbsPosition(this.p);
        int n3 = (int)((float)(n - this.p.x) - this.cx);
        int n4 = (int)((float)(n2 - this.p.y) - this.cy);
        float f = (float)n3 / this.sizeRadX;
        float f2 = (float)n4 / this.sizeRadY;
        boolean bl2 = bl = f * f + f2 * f2 < 1.0f;
        if (bl) {
            Point point = new Point(Math.round(n3), Math.round(n4));
            float f3 = point.x;
            float f4 = point.y;
            this.calcCircumferencePosition(point, f3, f4, this.sizeRadX, this.sizeRadY);
            double d = Math.atan2(n4, n3);
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            double d4 = (double)Math.abs(this.sizeRadX - this.sizeRadY) / 2.0;
            if (this.width > this.height) {
                f3 = (float)((double)f3 - d4 * d2);
                f4 = (float)((double)f4 + d4 * d3);
            } else {
                f3 = (float)((double)f3 + d4 * d2);
                f4 = (float)((double)f4 - d4 * d3);
            }
            int n5 = Math.round(PApplet.degrees((float)((float)Math.atan2(f4, f3))));
            n5 = n5 < 0 ? n5 + 360 : n5;
            bl = this.isInValidArc(n5);
        }
        return bl;
    }

    protected void calcTickMarkerPositions(int n) {
        this.mark = new Point[n][2];
        float f = PApplet.radians((float)this.aLow);
        float f2 = PApplet.radians((float)(this.aHigh - this.aLow)) / (float)(n - 1);
        for (int i = 0; i < n; ++i) {
            this.mark[i][0] = new Point();
            this.mark[i][1] = new Point();
            float f3 = this.convertRealAngleToOvalAngle(f, this.sizeRadX, this.sizeRadY);
            float f4 = (float)((double)this.sizeRadX * Math.cos(f3));
            float f5 = (float)((double)this.sizeRadY * Math.sin(f3));
            this.calcCircumferencePosition(this.mark[i][0], f4, f5, this.knobRadX, this.knobRadY);
            if (i == 0 || i == n - 1) {
                this.mark[i][1].x = Math.round(f4);
                this.mark[i][1].y = Math.round(f5);
            } else {
                this.calcCircumferencePosition(this.mark[i][1], f4, f5, this.barRadX, this.barRadY);
            }
            f += f2;
        }
        this.nbrTickMarks = n;
    }
}

