/*
 * Decompiled with CFR 0.152.
 */
package blobDetection;

import blobDetection.EdgeVertex;
import blobDetection.MetaballsTable;

public class Metaballs2D {
    protected float isovalue;
    protected int resx;
    protected int resy;
    protected float stepx;
    protected float stepy;
    protected float[] gridValue;
    protected int nbGridValue;
    protected int[] voxel;
    protected int nbVoxel;
    protected EdgeVertex[] edgeVrt;
    protected int nbEdgeVrt;
    protected int[] lineToDraw;
    protected int nbLineToDraw;

    public void init(int resx, int resy) {
        this.resx = resx;
        this.resy = resy;
        this.stepx = 1.0f / (float)(resx - 1);
        this.stepy = 1.0f / (float)(resy - 1);
        this.nbGridValue = resx * resy;
        this.gridValue = new float[this.nbGridValue];
        this.nbVoxel = this.nbGridValue;
        this.voxel = new int[this.nbVoxel];
        this.edgeVrt = new EdgeVertex[3 * this.nbVoxel];
        this.nbEdgeVrt = 3 * this.nbVoxel;
        this.lineToDraw = new int[2 * this.nbVoxel];
        this.nbLineToDraw = 0;
        int n = 0;
        int x = 0;
        while (x < resx) {
            int y = 0;
            while (y < resy) {
                int index;
                this.voxel[x + resx * y] = index = 3 * n;
                this.edgeVrt[index] = new EdgeVertex((float)x * this.stepx, (float)y * this.stepy);
                this.edgeVrt[index + 1] = new EdgeVertex((float)x * this.stepx, (float)y * this.stepy);
                this.edgeVrt[index + 2] = new EdgeVertex((float)x * this.stepx, (float)y * this.stepy);
                ++n;
                ++y;
            }
            ++x;
        }
    }

    public void computeIsovalue() {
    }

    public void computeMesh() {
        this.computeIsovalue();
        this.nbLineToDraw = 0;
        float vx = 0.0f;
        int x = 0;
        while (x < this.resx - 1) {
            float vy = 0.0f;
            int y = 0;
            while (y < this.resy - 1) {
                int iEdge;
                int offset = x + this.resx * y;
                int squareIndex = this.getSquareIndex(x, y);
                int n = 0;
                while ((iEdge = MetaballsTable.edgeCut[squareIndex][n++]) != -1) {
                    int[] edgeOffsetInfo = MetaballsTable.edgeOffsetInfo[iEdge];
                    int offx = edgeOffsetInfo[0];
                    int offy = edgeOffsetInfo[1];
                    int offAB = edgeOffsetInfo[2];
                    this.lineToDraw[this.nbLineToDraw++] = this.voxel[x + offx + this.resx * (y + offy)] + offAB;
                }
                int toCompute = MetaballsTable.edgeToCompute[squareIndex];
                if (toCompute > 0) {
                    float t;
                    if ((toCompute & 1) > 0) {
                        t = (this.isovalue - this.gridValue[offset]) / (this.gridValue[offset + 1] - this.gridValue[offset]);
                        this.edgeVrt[this.voxel[offset]].x = vx * (1.0f - t) + t * (vx + this.stepx);
                    }
                    if ((toCompute & 2) > 0) {
                        t = (this.isovalue - this.gridValue[offset]) / (this.gridValue[offset + this.resx] - this.gridValue[offset]);
                        this.edgeVrt[this.voxel[offset] + 1].y = vy * (1.0f - t) + t * (vy + this.stepy);
                    }
                }
                vy += this.stepy;
                ++y;
            }
            vx += this.stepx;
            ++x;
        }
        this.nbLineToDraw /= 2;
    }

    protected int getSquareIndex(int x, int y) {
        int squareIndex = 0;
        int offy = this.resx * y;
        int offy1 = this.resx * (y + 1);
        if (this.gridValue[x + offy] < this.isovalue) {
            squareIndex |= 1;
        }
        if (this.gridValue[x + 1 + offy] < this.isovalue) {
            squareIndex |= 2;
        }
        if (this.gridValue[x + 1 + offy1] < this.isovalue) {
            squareIndex |= 4;
        }
        if (this.gridValue[x + offy1] < this.isovalue) {
            squareIndex |= 8;
        }
        return squareIndex;
    }

    public void setIsovalue(float iso) {
        this.isovalue = iso;
    }
}

